 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kreal2cmplx
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kreal2cmplx.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Output = Input 1 + j(Input 2)
|
|       Purpose: main program for kreal2cmplx
|
|         Input:
|		char *clui_info->o_file; {Resulting output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Loose group:
|		    char *clui_info->i1_file; {Input to be used as real component}
|		    int   clui_info->i1_flag; {TRUE if -i1 specified}
|
|		    char *clui_info->i2_file; {Input to be used as imaginary component}
|		    int   clui_info->i2_flag; {TRUE if -i2 specified}
|
|		double clui_info->real_double; {Value to be used as real component if no i1, or if padding occurs}
|		int    clui_info->real_flag; {TRUE if -real specified}
|
|		double clui_info->imag_double; {Value to be used as imaginary component if no i2, or if padding occurs}
|		int    clui_info->imag_flag; {TRUE if -imag specified}
|
|        Output:
|       Returns:
|
|    Written By: Donna Koechner
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject	 real_obj=NULL, imag_obj=NULL, cmplx_obj=NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kreal2cmplx_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kreal2cmplx",
		kreal2cmplx_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kreal2cmplx_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	if (clui_info->i1_flag)
	{
           if ((real_obj = kpds_open_input_object(clui_info->i1_file))
                	== KOBJECT_INVALID)
           {
              kerror("kreal2cmplx","main", "Cannot open input object %s.",
                      clui_info->i1_file);
              kexit(KEXIT_FAILURE);
           }
	}

	if (clui_info->i2_flag)
	{
           if ((imag_obj = kpds_open_input_object(clui_info->i2_file))
                	== KOBJECT_INVALID)
           {
              kerror("kreal2cmplx","main", "Cannot open input object %s.",
                      clui_info->i2_file);
              kexit(KEXIT_FAILURE);
           }
	}

        if ((cmplx_obj = kpds_open_output_object(clui_info->o_file))
                	== KOBJECT_INVALID)
        {
           kerror("kreal2cmplx","main", "Cannot open input object %s.",
                   clui_info->o_file);
           kexit(KEXIT_FAILURE);
        }

	if (clui_info->i1_flag)
	{
           if (!kpds_copy_object_attr(real_obj, cmplx_obj))
           {
              kerror("kreal2cmplx","main",
                 "Cannot copy attributes from real input to complex output.");
              kexit(KEXIT_FAILURE);
           }
	}
	else if (clui_info->i2_flag)
	{
           if (!kpds_copy_object_attr(imag_obj, cmplx_obj))
           {
              kerror("kreal2cmplx","main",
                 "Cannot copy attributes from imaginary input to output.");
              kexit(KEXIT_FAILURE);
           }
	}
	else
        {
           kerror("kreal2cmplx","main",
              "At least on input file must be specified.");
           kexit(KEXIT_FAILURE);
        }
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!lkreal2cmplx(real_obj, imag_obj, clui_info->real_double, 
			  clui_info->imag_double, cmplx_obj))
	{
	   kexit(KEXIT_FAILURE);
	}
/* -main_library_call_end */

/* -main_after_lib_call */
        /* add history to the output object */
        if (!kpds_set_attribute(cmplx_obj, KPDS_HISTORY, kpds_history_string()))
        {
           kerror("kreal2cmplx", "main",
                  "Unable to set history on the destination object");
           kexit(KEXIT_FAILURE);
        }
 
	if (clui_info->i1_flag)
	{
           if (!kpds_copy_remaining_data(real_obj, cmplx_obj))
           {
              kerror("kreal2cmplx","main",
                 "Cannot copy remaining data from real input to output.");
              kexit(KEXIT_FAILURE);
           }
	}
	else
	{
           if (!kpds_copy_remaining_data(imag_obj, cmplx_obj))
           {
              kerror("kreal2cmplx","main",
                 "Cannot copy remaining data from imaginary input to output.");
              kexit(KEXIT_FAILURE);
           }
	}
 
        if (clui_info->i1_flag)	kpds_close_object(real_obj);
        if (clui_info->i2_flag)	kpds_close_object(imag_obj);
        kpds_close_object(cmplx_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kreal2cmplx_usage_additions
| 
|       Purpose: Prints usage additions in kreal2cmplx_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kreal2cmplx
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kreal2cmplx_usage_additions(void)
{
	kfprintf(kstderr, "\tOutput = Input 1 + j(Input 2)\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kreal2cmplx_free_args
| 
|       Purpose: Frees CLUI struct allocated in kreal2cmplx_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kreal2cmplx
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kreal2cmplx_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->o_file);
	kfree(clui_info->i1_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
