 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for klinearop
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "klinearop.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Performs linear operations (convolution/correlation)
|
|       Purpose: main program for klinearop
|
|         Input:
|		char *clui_info->i1_file; {Input object filename }
|		int   clui_info->i1_flag; {TRUE if -i1 specified}
|
|		char *clui_info->i2_file; {Input kernel filename}
|		int   clui_info->i2_flag; {TRUE if -i2 specified}
|
|		char *clui_info->o_file; {output object filename}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    M.I. group:
|			int clui_info->l_flag; {TRUE if -l specified}
|
|			double clui_info->real_double; {Real part of pad constant}
|			int    clui_info->real_flag; {TRUE if -real specified}
|
|			double clui_info->imag_double; {Imaginary part of pad constant}
|			int    clui_info->imag_flag; {TRUE if -imag specified}
|
|			int clui_info->size_logic; {Determine size of output (def: truncate)}
|			int clui_info->size_flag; {TRUE if -size specified}
|
|		    int clui_info->c_flag; {TRUE if -c specified}
|
|		Loose group:
|		    int clui_info->w_flag; {TRUE if -w specified}
|
|		    int clui_info->h_flag; {TRUE if -h specified}
|
|		    int clui_info->d_flag; {TRUE if -d specified}
|
|		    int clui_info->t_flag; {TRUE if -t specified}
|
|		    int clui_info->e_flag; {TRUE if -e specified}
|
|		int clui_info->flip_logic; {Kernel reflection (def: convolution)}
|		int clui_info->flip_flag; {TRUE if -flip specified}
|
|		int clui_info->upcast_flag; {TRUE if -upcast specified}
|
|		int clui_info->w0_int; {Width location of kernel origin}
|		int clui_info->w0_flag; {TRUE if -w0 specified}
|
|		int clui_info->h0_int; {Height location of kernel origin}
|		int clui_info->h0_flag; {TRUE if -h0 specified}
|
|		int clui_info->d0_int; {Depth location of kernel origin}
|		int clui_info->d0_flag; {TRUE if -d0 specified}
|
|		int clui_info->t0_int; {Time location of kernel origin}
|		int clui_info->t0_flag; {TRUE if -t0 specified}
|
|		int clui_info->e0_int; {Element location of kernel origin}
|		int clui_info->e0_flag; {TRUE if -e0 specified}
|
|		int clui_info->wp_int; {Sub-object width position.}
|		int clui_info->wp_flag; {TRUE if -wp specified}
|
|		int clui_info->ws_int; {Sub-object width size.}
|		int clui_info->ws_flag; {TRUE if -ws specified}
|
|		int clui_info->hp_int; {Sub-object height position.}
|		int clui_info->hp_flag; {TRUE if -hp specified}
|
|		int clui_info->hs_int; {Sub-object height size.}
|		int clui_info->hs_flag; {TRUE if -hs specified}
|
|		int clui_info->dp_int; {Sub-object depth position.}
|		int clui_info->dp_flag; {TRUE if -dp specified}
|
|		int clui_info->ds_int; {Sub-object depth size.}
|		int clui_info->ds_flag; {TRUE if -ds specified}
|
|		int clui_info->tp_int; {Sub-object time position.}
|		int clui_info->tp_flag; {TRUE if -tp specified}
|
|		int clui_info->ts_int; {Sub-object time size.}
|		int clui_info->ts_flag; {TRUE if -ts specified}
|
|		int clui_info->ep_int; {Sub-object elements position.}
|		int clui_info->ep_flag; {TRUE if -ep specified}
|
|		int clui_info->es_int; {Sub-object elements size.}
|		int clui_info->es_flag; {TRUE if -es specified}
|
|        Output:
|       Returns:
|
|    Written By: Jonio Roberto de Hollanda Cavalcanti, Ramiro Jordan
|          Date: Apr 13, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject src = NULL;	/* source object */
        kobject kernel = NULL;	/* kernel object */
        int *offset = NULL;	/* indicates new kernel offset values */
        int filtering_type;     /* linear or circular */
        int size_type;          /* truncate or extend, output size */
        int reflection;         /* convolution or correlation type operation */
        float real_pad_value;   /* real value for padding object */
        float img_pad_value;    /* imaginary value for padding object */
        int  num_dim, index;
        long *dim_list;
        int  *sub_size;
        int  *sub_pos;
        char *prog = "main";    /* main/library name (for error reporting) */
        char *rtn = "klinearop";  /* routine name (for error reporting) */
        int w,h,d,t,e;
        int upcast;
        kobject dest=NULL;           /* destination object */
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(klinearop_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "klinearop",
		klinearop_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	klinearop_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        /*
         * Open the source, kernel and destination data objects using the
         * kpds_open_input_object and kpds_open_output_object calls.
         * These calls will open the source, kernel and
         * destination data objects with the flags set correctly.  If an open
         * fails, report the error using kerror, close opened objects if
         * necessary, and exit the program using the kexit call.
         */
 
        if ((src = kpds_open_input_object(clui_info ->i1_file) ) 
		== KOBJECT_INVALID)
        {
            kerror( rtn, prog, "Cannot open source object.");
            kexit(KEXIT_FAILURE);
        }
 
        if ((kernel = kpds_open_input_object(clui_info ->i2_file) )
		== KOBJECT_INVALID)
        {
            kerror( rtn, prog, "Cannot open kernel object.");
            kpds_close_object(src);
            kexit(KEXIT_FAILURE);
        }

        if ((dest = kpds_open_output_object(clui_info ->o_file) ) 
		 == KOBJECT_INVALID)
        {
            kerror( rtn, prog, "Cannot open destination object.");
            kpds_close_object(src);
            kexit(KEXIT_FAILURE);
        }

        /*
         * The lklinearop library should have no side effects on the
         * destination object.  It will only manipulate the value data,
         * the mask, if it exists, and the attributes of the destination
         * data object that are related to the filtering operation.
         *
         * Since the source object may contain additional attributes
         * that may or may not be part of the data model,
         * the source object needs to be copied to the destination object
         * so that the user is not surprised by unwanted side effects.
         * Example: removal of map or location data.
         *
         * NOTE: The user can use the kpds_copy_object_data and
         * kpds_copy_object_attr functions to copy data and attributes
         * between source and destination objects separatedly.
         *
         * If the copy function fails, report the error, close the source
         * and destination objects, and exit.
         */
 
        if (!kpds_copy_object_attr(src, dest))
        {
            kerror( rtn, prog, "kpds_copy_object failed.");
            kpds_close_object(src);
            kpds_close_object(dest);
            kexit(KEXIT_FAILURE);
        }

        /*
        * Assign variables.  The clui_info structure is created by
        * the code generators using the user interface specification file
        * (kfilter.pane), and this structure is located in the kfilter.h
        * file.
        *
        * Below, we have assigned the structure variables to local
        * variables.  In this example, this step is not required, since
        * nothing is done to the variables before they are passed to the
        * library lklinearop.
        *
        * The filtering_type variable receives the user selection on the
        * method to perform the filtering operation.  There are two options:
        * 1) linear (default); padding is required (default values for
        *    the real and imaginary parts are 0)
        * 2) circular; no padding is required 
	*
        * In addition, if new parameters for the origin ("sweet spot") of
        * the kernel are passed by the user, use new values for origin. 
        * Default values are read from the kernel object.
	*                     wval (width)
        *                     hval (height) 
	*                     dval (depth)
        *                     tval (time) 
        *                     eval (elements) 
        *
	* Dimension of filtering result is determined, two options:
        * 1) truncate: result has the same dimensions as the input object
        *    (size_type=0=truncate)
        * 2) extend: the new row and column sizes are determined 
        *    new dimension = object dimension + kernel dimension - 1 
        *    (size_type=1=extend)
        *
        * Reflection process is determined.  Two options:
	* 1) Flip kernel (eg. convolution) is default.
	* 2) No flip (eg. correlation)
        *
        * Finally set up the filtering directions. There are five
        * directions available.
        *
        *      w - width.
        *      h - height.
        *      d - depth.
        *      t - time.
        *      e - element.
        * 
        * If the number of directions is smaller than the kernel dimension
        * print error message.
        */
        size_type = 1;
        if (clui_info->size_flag) size_type = clui_info->size_logic;
        reflection = clui_info->flip_logic;

	real_pad_value = 0.0;
	img_pad_value = 0.0;
        if (clui_info->l_flag == 1) {
	   filtering_type = 0;
	   real_pad_value = clui_info->real_double;
	   img_pad_value = clui_info->imag_double;
        }
        else if (clui_info->c_flag == 1)
             filtering_type = 1;

        if (!kpds_get_attribute(kernel, KPDS_VALUE_SIZE,&w,&h,&d,&e,&t)) {
            kerror( rtn, prog, "kpds_get_attribute failed for kernel.");
            kexit(KEXIT_FAILURE);
        }

       /*
	* Set the default sweet spot for the kernel. 
        * It will be obtained from the KPDS_KERNEL_ORIGIN attribute
        * of the kernel in the lklinearop function if there is no 
        * sweet spot selection from the pane. 
        */	
        if (clui_info->w0_flag || clui_info->h0_flag || clui_info->h0_flag ||
            clui_info->t0_flag || clui_info->e0_flag)
        {
         offset = (int *) kmalloc(5*sizeof(int));
	 if (offset == NULL){
             kerror( rtn, prog, "Cannot allocate variable offset");
             kexit(KEXIT_FAILURE);
	 }
         offset[0] = offset[1] = offset[2] =  0;
         offset[3] = offset[4] = 0;
	 if (clui_info->w0_flag ) offset[0]=clui_info->w0_int;
	 if (clui_info->h0_flag ) offset[1]=clui_info->h0_int;
	 if (clui_info->d0_flag ) offset[2]=clui_info->d0_int;
	 if (clui_info->t0_flag ) offset[3]=clui_info->t0_int;
	 if (clui_info->e0_flag ) offset[4]=clui_info->e0_int;
        }

       /*
        * Select sub-object size for processing. 
        * Default is the whole object.
        * Check dimension size of input object.
        *
        */
        sub_size= (int *) kmalloc(5*sizeof(int));
	if (sub_size== NULL){
            kerror( rtn, prog, "Cannot allocate sub_size.");
            kexit(KEXIT_FAILURE);
	}
	if (!kpds_get_attribute(src, KPDS_VALUE_SIZE,&sub_size[0],&sub_size[1],
                                     &sub_size[2],&sub_size[3],&sub_size[4])) {
            kerror( rtn, prog, "kpds_get_attribute failed for src.");
            kexit(KEXIT_FAILURE);
	}
	if (w>sub_size[0]) {
	 kerror(rtn, prog, 
                    "Width Size: Kernel is not sub-object of object.");
         kexit(KEXIT_FAILURE);
        }
          
	if (h>sub_size[1]) {
	 kerror(rtn, prog, 
                    "Height Size: Kernel is not sub-object of object.");
         kexit(KEXIT_FAILURE);
        }
	if (d>sub_size[2]) {
	 kerror(rtn, prog, 
                    "Depth Size: Kernel is not sub-object of object.");
         kexit(KEXIT_FAILURE);
        }
	if (t>sub_size[3]) {
	 kerror(rtn, prog, 
                    "Time Size: Kernel is not sub-object of object.");
         kexit(KEXIT_FAILURE);
        }
	if (e>sub_size[4]) {
	 kerror(rtn, prog, 
                    "Element Size: Kernel is not sub-object of object.");
         kexit(KEXIT_FAILURE);
        }
        sub_size[0] += (w-1);
        sub_size[1] += (h-1);
        sub_size[2] += (d-1);
        sub_size[3] += (t-1);
        sub_size[4] += (e-1);
        if (clui_info->ws_flag) sub_size[0] = clui_info->ws_int;
        if (clui_info->hs_flag) sub_size[1] = clui_info->hs_int; 
        if (clui_info->ds_flag) sub_size[2] = clui_info->ds_int;
        if (clui_info->ts_flag) sub_size[3] = clui_info->ts_int;
        if (clui_info->es_flag) sub_size[4] = clui_info->es_int;

       /*
        * Select sub-object position for processing. 
        * Default is the top left corner.
        *
        */
        sub_pos= (int *) kmalloc(5*sizeof(int));
	if (sub_pos== NULL){
            kerror( rtn, prog, "Cannot allocate sub_pos.");
            kexit(KEXIT_FAILURE);
	}
        sub_pos[0]=sub_pos[1]=0;
        sub_pos[2]=sub_pos[3]=sub_pos[4]=0;
        if (clui_info->wp_flag) sub_pos[0] = clui_info->wp_int;
        if (clui_info->hp_flag) sub_pos[1] = clui_info->hp_int; 
        if (clui_info->dp_flag) sub_pos[2] = clui_info->dp_int;
        if (clui_info->tp_flag) sub_pos[3] = clui_info->tp_int;
        if (clui_info->ep_flag) sub_pos[4] = clui_info->ep_int;

       /*
        * Select kernel directions for processing. 
        * Check to see whether the directions for
        * processing and the kernel dimensions agree.
        * Also, direction not available in the kernel
        * will not be processed.
        *
        */
        num_dim = 0;
	if (clui_info->w_flag) num_dim++;
	if (clui_info->h_flag) num_dim++;
	if (clui_info->d_flag) num_dim++;
	if (clui_info->t_flag) num_dim++;
	if (clui_info->e_flag) num_dim++;
        index = 0;
	if (w>1) index++;
	if (h>1) index++;
	if (d>1) index++;
	if (t>1) index++;
	if (e>1) index++;

        if (index > num_dim)
        {
         kerror(rtn,prog,"Directions selected do not match kernel dimension.");
         kexit(KEXIT_FAILURE);
        }

        dim_list = (long *) kmalloc(num_dim*sizeof(long));
        if (dim_list == NULL){
	    kerror(rtn, prog, "Cannot allocate dimensions.");
            kexit(KEXIT_FAILURE);
          }

        index = 0;
        if (clui_info->w_flag ) dim_list[index++] = KWIDTH;
        if (clui_info->h_flag ) dim_list[index++] = KHEIGHT;
        if (clui_info->d_flag ) dim_list[index++] = KDEPTH;
        if (clui_info->t_flag ) dim_list[index++] = KTIME;
        if (clui_info->e_flag ) dim_list[index++] = KELEMENTS;

       /*
        * Set the upcast option. If this option is set true
        * the data type of the kernel and the source/destination
        * will set to DOUBLE.
        */
        upcast = clui_info->upcast_flag;
/* -main_before_lib_call_end */

/* -main_library_call */
        /*
         * Once all of the preliminary work has been done, pass the source,
         * kernel, and destination objects.  Also, pass  other parameters to
         * the library.
         * After execution of lklinearop close the objects and exit the
         * kfilter routine.
         */
          if (!lklinearop(src, kernel, filtering_type,
                        real_pad_value, img_pad_value, offset,
                        size_type, reflection, num_dim, dim_list,
                        sub_size, sub_pos, upcast, dest))
          {
           kpds_close_object(src);
           kpds_close_object(kernel);
           kpds_close_object(dest);
	   kerror(rtn, prog, "lklinearop failed.");
           kexit(KEXIT_FAILURE);
          }
/* -main_library_call_end */

/* -main_after_lib_call */
        /* add history to the output object */
        if (!kpds_set_attribute(dest, KPDS_HISTORY, kpds_history_string()))
        {
           kerror("klinearop", "main",
                  "Unable to set history on the destination object");
            kexit(KEXIT_FAILURE);
        }
 

       /*
        * If the library call succeeded, close the source, kernel and
        * destination data objects using kpds_close_object and exit
        * using kexit.
        */
        kpds_close_object(src);
        kpds_close_object(kernel);
        kpds_close_object(dest);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: klinearop_usage_additions
| 
|       Purpose: Prints usage additions in klinearop_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname klinearop
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void klinearop_usage_additions(void)
{
	kfprintf(kstderr, "\tPerforms linear operations (convolution/correlation)\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: klinearop_free_args
| 
|       Purpose: Frees CLUI struct allocated in klinearop_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname klinearop
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
klinearop_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i1_file);
	kfree(clui_info->i2_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
