 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kinverse
   >>>> 
   >>>>    Written By: Scott Wilson
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kinverse_h_
#define _kinverse_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include <kdatamanip/kdatamanip.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kinverse/uis/kinverse.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  source data object (FFT) (required infile)
 */
char	*i1_file;	/* source data object (FFT) FILENAME */
int	 i1_flag;	/* source data object (FFT) FLAG */

/*
 *  PSF data object (FFT) (required infile)
 */
char	*i2_file;	/* PSF data object (FFT) FILENAME */
int	 i2_flag;	/* PSF data object (FFT) FLAG */

/*
 *  filtered data object (FFT) (required outfile)
 */
char	*o_file;	/* filtered data object (FFT) FILENAME */
int	 o_flag;	/* filtered data object (FFT) FLAG */

/*
 *  filter threshold (magnitude) (optional double)
 */
double	 t_double;	/* filter threshold (magnitude) DOUBLE */
int	 t_flag;   	/* filter threshold (magnitude) FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kinverse_get_args PROTO((kform *));
void kinverse_usage_additions PROTO((void));
void kinverse_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
