 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kinset
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kinset.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Inset Object 2 into Object 1
|
|       Purpose: main program for kinset
|
|         Input:
|		char *clui_info->i1_file; {Base input image}
|		int   clui_info->i1_flag; {TRUE if -i1 specified}
|
|		char *clui_info->i2_file; {Second (inset) input image}
|		int   clui_info->i2_flag; {TRUE if -i2 specified}
|
|		char *clui_info->o_file; {Resulting output object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		int clui_info->insetvalid_logic; {If Object has Mask, Only Inset VALID DataIf}
|		int clui_info->insetvalid_flag; {TRUE if -insetvalid specified}
|
|		double clui_info->real_double; {Real constant pad level}
|		int    clui_info->real_flag; {TRUE if -real specified}
|
|		double clui_info->imag_double; {Imaginary constant pad level}
|		int    clui_info->imag_flag; {TRUE if -imag specified}
|
|		int clui_info->padvalid_logic; {Identify padded data added by this program as valid or invalid in mask}
|		int clui_info->padvalid_flag; {TRUE if -padvalid specified}
|
|		int   clui_info->mapping_list; {Defines map treatment when some, but not all, objects have maps }
|		char *clui_info->mapping_label;
|		int   clui_info->mapping_flag; {TRUE if -mapping specified}
|
|		Loose group:
|		    int clui_info->attr_flag; {TRUE if -attr specified}
|
|		    int clui_info->woff_int; {Insert region beginning at this width coordinate}
|		    int clui_info->woff_flag; {TRUE if -woff specified}
|
|		    int clui_info->hoff_int; {Insert region beginning at this height coordinate}
|		    int clui_info->hoff_flag; {TRUE if -hoff specified}
|
|		    int clui_info->doff_int; {Insert region beginning at this depth coordinate}
|		    int clui_info->doff_flag; {TRUE if -doff specified}
|
|		    int clui_info->toff_int; {Insert region beginning at this time coordinate}
|		    int clui_info->toff_flag; {TRUE if -toff specified}
|
|		    int clui_info->eoff_int; {Insert region beginning at this element coordinate}
|		    int clui_info->eoff_flag; {TRUE if -eoff specified}
|
|        Output:
|       Returns:
|
|    Written By: Donna Koechner and Mark Young
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject src1_obj;
	kobject src2_obj;
	kobject dst_obj;
	int 	mapping;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kinset_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kinset",
		kinset_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kinset_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	if ((src1_obj = kpds_open_input_object(clui_info->i1_file)) 
		== KOBJECT_INVALID)
        { 
	   kerror("kinset","main", "Cannot open input object %s.",
                   clui_info->i1_file);
           kexit(KEXIT_FAILURE);
        }

	if ((src2_obj = kpds_open_input_object(clui_info->i2_file)) 
		== KOBJECT_INVALID)
        { 
	   kerror("kinset","main", "Cannot open input object %s.",
                   clui_info->i2_file);
           kexit(KEXIT_FAILURE);
        }

        if ((dst_obj = kpds_open_output_object(clui_info->o_file)) 
		== KOBJECT_INVALID)        
	{ 
	   kerror("kinset","main", "Cannot open output object %s.",
                   clui_info->o_file);
           kexit(KEXIT_FAILURE);
        }

        if (!kpds_copy_object_attr(src1_obj, dst_obj))
        {
           kerror("kinset","main",
                  "Cannot copy attributes from input1 to output object.");
           kexit(KEXIT_FAILURE);
        }

        if (clui_info->mapping_list == 1)
           mapping = KAPU_USE_COMMON_MAP;
        else
           mapping = KAPU_MAP_ALL_DATA;

/* attr option is never used! */
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!kapu_inset(src1_obj, src2_obj, 
		clui_info->woff_flag, clui_info->woff_int,
		clui_info->hoff_flag, clui_info->hoff_int,
		clui_info->doff_flag, clui_info->doff_int,
		clui_info->toff_flag, clui_info->toff_int,
		clui_info->eoff_flag, clui_info->eoff_int,
		clui_info->real_double, clui_info->imag_double,
		clui_info->padvalid_logic, clui_info->insetvalid_logic, 
		mapping, dst_obj))
	{
	   kexit(KEXIT_FAILURE);
	}
/* -main_library_call_end */

/* -main_after_lib_call */
        /* add history to the output object */
        if (!kpds_set_attribute(dst_obj, KPDS_HISTORY, kpds_history_string()))
        {
           kerror("kinset", "main", 
                  "Unable to set history on the destination object");
           kexit(KEXIT_FAILURE);
        }
 
        if (!kpds_copy_remaining_data(src1_obj, dst_obj))
        {
           kerror("kinset","main",
                  "Cannot copy remaining data from input1 to output object.");
           kexit(KEXIT_FAILURE);
        }
 
        kpds_close_object(src1_obj);
        kpds_close_object(src2_obj);
        kpds_close_object(dst_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kinset_usage_additions
| 
|       Purpose: Prints usage additions in kinset_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kinset
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kinset_usage_additions(void)
{
	kfprintf(kstderr, "\tInset Object 2 into Object 1\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kinset_free_args
| 
|       Purpose: Frees CLUI struct allocated in kinset_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kinset
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kinset_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i1_file);
	kfree(clui_info->i2_file);
	kfree(clui_info->o_file);
	kfree(clui_info->mapping_label);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
