 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for khisto
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "khisto.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Compute Histogram for Data Object
|
|       Purpose: main program for khisto
|
|         Input:
|		char *clui_info->i_file; {Input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {Output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		char *clui_info->igate_file; {Gating input data object}
|		int   clui_info->igate_flag; {TRUE if -igate specified}
|
|		int clui_info->bins_int; {number of histogram bins}
|		int clui_info->bins_flag; {TRUE if -bins specified}
|
|		double clui_info->binwidth_double; {width of histogram bin}
|		int    clui_info->binwidth_flag; {TRUE if -binwidth specified}
|
|		double clui_info->min_double; {Min side of min histogram bin}
|		int    clui_info->min_flag; {TRUE if -min specified}
|
|		int clui_info->oob_flag; {TRUE if -oob specified}
|
|		Optional M.E. group:
|		    int clui_info->whole_flag; {TRUE if -whole specified}
|
|		    Loose group:
|			int clui_info->w_flag; {TRUE if -w specified}
|
|			int clui_info->h_flag; {TRUE if -h specified}
|
|			int clui_info->d_flag; {TRUE if -d specified}
|
|			int clui_info->t_flag; {TRUE if -t specified}
|
|			int clui_info->e_flag; {TRUE if -e specified}
|
|        Output:
|       Returns:
|
|    Written By: Scott Wilson
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject in_obj = NULL;
	kobject gate_obj = NULL;
	kobject out_obj = NULL;
        int w,h,d,t,e;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(khisto_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "khisto",
		khisto_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	khisto_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	if ((in_obj = kpds_open_input_object(clui_info->i_file)) 
		== KOBJECT_INVALID)
        {
           kerror("khisto","main", "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }

        if (clui_info->igate_flag) {
           gate_obj = kpds_open_input_object(clui_info->igate_file);
	   if (gate_obj == KOBJECT_INVALID) {
              kerror("khisto", "main", "Cannot open gating input object.");
              kexit(KEXIT_FAILURE);
           }
	}

	if ((out_obj = kpds_open_output_object(clui_info->o_file)) 
		== KOBJECT_INVALID)
        {
           kerror("khisto","main", "Cannot open output object.");
           kexit(KEXIT_FAILURE);
        }

        if (!kpds_copy_object_attr(in_obj, out_obj))
	{
           kerror("khisto","main", 
		  "Unable to copy attributes from input to output object.");
           kexit(KEXIT_FAILURE);
        }

	w=h=d=t=e=0;
	if (clui_info->whole_flag)
        {
          w=h=d=t=e=1;
        }
        else
        {
          if (clui_info->w_flag) w=1;
	  if (clui_info->h_flag) h=1;
	  if (clui_info->d_flag) d=1;
	  if (clui_info->t_flag) t=1;
	  if (clui_info->e_flag) e=1;
        }
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!lkhisto(in_obj,gate_obj,
                        w,h,d,t,e,
			clui_info->min_double,
                        clui_info->binwidth_double,
                        clui_info->bins_int,
                        clui_info->oob_flag,
			out_obj)) kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("khisto", "main", 
		  "Unable to set history on the destination object");
            kexit(KEXIT_FAILURE);
	}
	
	kpds_close_object(in_obj);
	kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: khisto_usage_additions
| 
|       Purpose: Prints usage additions in khisto_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname khisto
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void khisto_usage_additions(void)
{
	kfprintf(kstderr, "\tCompute Histogram for Data Object\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: khisto_free_args
| 
|       Purpose: Frees CLUI struct allocated in khisto_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname khisto
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
khisto_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
	kfree(clui_info->igate_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
