 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kgenloc
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kgenloc.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Generate Location Data
|
|       Purpose: main program for kgenloc
|
|         Input:
|		char *clui_info->o_file; {Resulting output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		char *clui_info->i_file; {First Input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		double clui_info->xbegin_double; {Explicit Location Begin for X dimension}
|		int    clui_info->xbegin_flag; {TRUE if -xbegin specified}
|
|		double clui_info->xend_double; {Explicit Location End for X dimension}
|		int    clui_info->xend_flag; {TRUE if -xend specified}
|
|		double clui_info->ybegin_double; {Explicit Location Begin for Y dimension}
|		int    clui_info->ybegin_flag; {TRUE if -ybegin specified}
|
|		double clui_info->yend_double; {Explicit Location End for Y dimension}
|		int    clui_info->yend_flag; {TRUE if -yend specified}
|
|		double clui_info->zbegin_double; {Explicit Location Begin for Z dimension}
|		int    clui_info->zbegin_flag; {TRUE if -zbegin specified}
|
|		double clui_info->zend_double; {Explicit Location End for Z dimension}
|		int    clui_info->zend_flag; {TRUE if -zend specified}
|
|		int clui_info->grid_toggle; {Grid Type to use when creating Location Data}
|		int clui_info->grid_flag; {TRUE if -grid specified}
|
|		int clui_info->wsize_int; {Width of location data}
|		int clui_info->wsize_flag; {TRUE if -wsize specified}
|
|		int clui_info->hsize_int; {Height of location data}
|		int clui_info->hsize_flag; {TRUE if -hsize specified}
|
|		int clui_info->dsize_int; {Depth of location data}
|		int clui_info->dsize_flag; {TRUE if -dsize specified}
|
|		int   clui_info->type_list; {Data type of location data}
|		char *clui_info->type_label;
|		int   clui_info->type_flag; {TRUE if -type specified}
|
|        Output:
|       Returns:
|
|    Written By: Steve Kubica
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject in_obj = NULL;
	kobject out_obj = NULL;

	int wid;
	int hgt;
	int dep;
	int dim;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kgenloc_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kgenloc",
		kgenloc_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kgenloc_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	/* -- assign the specified location sizes as defaults -- */
	wid = clui_info->wsize_int;
	hgt = clui_info->hsize_int;
	dep = clui_info->dsize_int;

	if ((out_obj = kpds_open_output_object(clui_info->o_file)) == NULL)
        {
           kerror("klocxform","main", "Cannot open output object.");
           kexit(KEXIT_FAILURE);
        }

	/* 
	 *  If an input was specified, then we will try to use it to
	 *  determine the size of the location segment.  We will try
	 *  the following two things to find a size :
	 *    1) if the input has a location segment, use its size
	 *    2) if the input has a value segment, use its w,h,d size
	 *       with the dimension size coming from the clui.
	 *   
	 *  Otherwise, we will just use the specified size parameters.
	 */

	/* -- set up location size .. depends on if input is specified -- */
	if (clui_info->i_flag)
	{
	   if ((in_obj = kpds_open_input_object(clui_info->i_file)) == NULL)
	   {
	      kerror("kgenloc","main", "Cannot open input object.");
	      kexit(KEXIT_FAILURE);
	   }

	   /* -- initialize _every_ segment in destination ... -- */
	   if (!kpds_copy_object_attr(in_obj, out_obj))
	   {
	      kerror("klocxform","main", 
		     "Unable to copy attributes from input to output object.");
	      kexit(KEXIT_FAILURE);
	   }

	   /* -- if input had location, then get location size -- */
	   if (kpds_query_location(out_obj))
	   {
	      if (!kpds_get_attribute(out_obj, KPDS_LOCATION_SIZE, 
				      &wid, &hgt, &dep, &dim))
	      {
		 kerror("kgenloc","main", "Unable to initialize destination "
			"location segment size.");
		 kexit(KEXIT_FAILURE);
	      }
	      
	      /* -- destroy location so we can create in library call -- */
	      if (!kpds_destroy_location(out_obj))
	      {
		 kerror("klocxform","main", 
			"Unable to destroy temporary location segment.");
		 kexit(KEXIT_FAILURE);
	      }
	   }

	   /* -- no location, so try to get value size and use that -- */
	   else if (kpds_query_value(out_obj))
	   {
	      if (!kpds_get_attribute(out_obj, KPDS_VALUE_SIZE, 
				      &wid, &hgt, &dep, NULL, NULL))
	      {
		 kerror("kgenloc","main", "Unable to determine size "
			"of source value segment size.");
		 kexit(KEXIT_FAILURE);
	      }
	   }
	}
/* -main_before_lib_call_end */

/* -main_library_call */
	/* -- create the location data-- */
	lkgenloc(clui_info->xbegin_double,
		 clui_info->ybegin_double,
		 clui_info->zbegin_double,
		 clui_info->xend_double,
		 clui_info->yend_double,
		 clui_info->zend_double,
		 clui_info->grid_toggle,
		 wid, hgt, dep,  
		 kdatatype_to_define(clui_info->type_label),
		 out_obj);  
/* -main_library_call_end */

/* -main_after_lib_call */
	/* -- add history to the output object -- */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("klocxform", "main", 
		  "Unable to set history on the destination object");
            kexit(KEXIT_FAILURE);
	}

	/* -- if we had a source object, then copy the remaining segments -- */
	if (clui_info->i_flag)
	   if (!kpds_copy_remaining_data(in_obj, out_obj))
	   {
	      kerror("klocxform","main", 
		     "Unable to copy remaining data from input to output "
		     "object.");
	      kexit(KEXIT_FAILURE);
	   }

	if (clui_info->i_flag)
	   kpds_close_object(in_obj);

	kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kgenloc_usage_additions
| 
|       Purpose: Prints usage additions in kgenloc_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgenloc
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kgenloc_usage_additions(void)
{
	kfprintf(kstderr, "\tGenerate Location Data\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kgenloc_free_args
| 
|       Purpose: Frees CLUI struct allocated in kgenloc_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgenloc
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kgenloc_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->o_file);
	kfree(clui_info->i_file);
	kfree(clui_info->type_label);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
