 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kgconst.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kgconst_get_args
| 
|       Purpose: Gets command line args for kgconst
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgconst
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kgconst_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kgconst is out of sync with arguments specified in kgconst's *.pane file; please rerun ghostwriter on kgconst.";


	/*
	 * allocate the kgconst structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_int(pane, "wsize",
			  &(clui_info->wsize_int),
			  &(clui_info->wsize_flag))))
	{
	    kerror(NULL, "kgconst_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "hsize",
			  &(clui_info->hsize_int),
			  &(clui_info->hsize_flag))))
	{
	    kerror(NULL, "kgconst_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "dsize",
			  &(clui_info->dsize_int),
			  &(clui_info->dsize_flag))))
	{
	    kerror(NULL, "kgconst_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "tsize",
			  &(clui_info->tsize_int),
			  &(clui_info->tsize_flag))))
	{
	    kerror(NULL, "kgconst_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "esize",
			  &(clui_info->esize_int),
			  &(clui_info->esize_flag))))
	{
	    kerror(NULL, "kgconst_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "real",
			  &(clui_info->real_double),
			  &(clui_info->real_flag))))
	{
	    kerror(NULL, "kgconst_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "imag",
			  &(clui_info->imag_double),
			  &(clui_info->imag_flag))))
	{
	    kerror(NULL, "kgconst_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "type", KVF_LIST_LABEL,
			  &(clui_info->type_label),
			  &(clui_info->type_flag)) &&
	      kclui_get_value(pane, "type", KVF_LIST_VAL,
			  &(clui_info->type_list),
			  &(clui_info->type_flag))))
	{
	    kerror(NULL, "kgconst_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kgconst_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



