 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kgconst
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kgconst.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Generate Object Containing Constant Value Data
|
|       Purpose: main program for kgconst
|
|         Input:
|		char *clui_info->o_file; {Output file containing constant value data}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		int clui_info->wsize_int; {Width size of constant value data}
|		int clui_info->wsize_flag; {TRUE if -wsize specified}
|
|		int clui_info->hsize_int; {Height size of constant value data}
|		int clui_info->hsize_flag; {TRUE if -hsize specified}
|
|		int clui_info->dsize_int; {Depth size of constant value data}
|		int clui_info->dsize_flag; {TRUE if -dsize specified}
|
|		int clui_info->tsize_int; {Time size of constant value data}
|		int clui_info->tsize_flag; {TRUE if -tsize specified}
|
|		int clui_info->esize_int; {Element dimension size of constant value data}
|		int clui_info->esize_flag; {TRUE if -esize specified}
|
|		double clui_info->real_double; {Real constant level}
|		int    clui_info->real_flag; {TRUE if -real specified}
|
|		double clui_info->imag_double; {Imaginary constant level}
|		int    clui_info->imag_flag; {TRUE if -imag specified}
|
|		int   clui_info->type_list; {Data type of constant value data}
|		char *clui_info->type_label;
|		int   clui_info->type_flag; {TRUE if -type specified}
|
|        Output:
|       Returns:
|
|    Written By: Donna Koechner
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject out_obj;
	int	type;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kgconst_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kgconst",
		kgconst_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kgconst_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((out_obj = kpds_open_output_object(clui_info->o_file))
		== KOBJECT_INVALID) {
	   kerror("kgconst", "main", "Failed to open output object");
           kexit(KEXIT_FAILURE);
	}

	type = kdatatype_to_define(clui_info->type_label);
/* -main_before_lib_call_end */

/* -main_library_call */
        if (!(lkgconst(clui_info->wsize_int, clui_info->hsize_int,
                clui_info->dsize_int, clui_info->tsize_int,
                clui_info->esize_int, clui_info->real_double,
                clui_info->imag_double, type, out_obj)) ) {
	   kexit(KEXIT_FAILURE);
	}
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("kgconst", "main", 
		  "Unable to set history on the destination object");
	   kexit(KEXIT_FAILURE);
	}

        kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kgconst_usage_additions
| 
|       Purpose: Prints usage additions in kgconst_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgconst
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kgconst_usage_additions(void)
{
	kfprintf(kstderr, "\tGenerate Object Containing Constant Value Data\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kgconst_free_args
| 
|       Purpose: Frees CLUI struct allocated in kgconst_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgconst
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kgconst_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->o_file);
	kfree(clui_info->type_label);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
