 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kformats
   >>>> 
   >>>>    Written By: 
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 15, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kformats_h_
#define _kformats_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kformats/uis/kformats.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Input data object (required infile)
 */
char	*i_file;	/* Input data object FILENAME */
int	 i_flag;	/* Input data object FLAG */

/*
 *  Resulting output data object (required outfile)
 */
char	*o_file;	/* Resulting output data object FILENAME */
int	 o_flag;	/* Resulting output data object FLAG */

/*----- required ME group ----*/
/*
 *  Output in ASCII format (optional flag)
 */
int	 ascii_flag;  	/* Output in ASCII format FLAG */

/*
 *  Output as VIFF (Khoros 2.0 Format) (optional flag)
 */
int	 viff_flag;  	/* Output as VIFF (Khoros 2.0 Format) FLAG */

/*
 *  Output in Application Visualization System (AVS) format (optional flag)
 */
int	 avs_flag;  	/* Output in Application Visualization System (AVS) format FLAG */

/*
 *  Output in X Bitmap (XBM) format (optional flag)
 */
int	 xbm_flag;  	/* Output in X Bitmap (XBM) format FLAG */

/*
 *  Output in ARF Format (optional flag)
 */
int	 arf_flag;  	/* Output in ARF Format FLAG */

/*
 *  Output as Xvimage (Khoros 1.0 Format) (optional flag)
 */
int	 xvimage_flag;  	/* Output as Xvimage (Khoros 1.0 Format) FLAG */

/*
 *  Output in Portable Any Map (PNM) format (optional flag)
 */
int	 pnm_flag;  	/* Output in Portable Any Map (PNM) format FLAG */

/*
 *  Output in X Window Dump (XWD) format (optional flag)
 */
int	 xwd_flag;  	/* Output in X Window Dump (XWD) format FLAG */

/*
 *  Output in Raw (headerless) format (optional flag)
 */
int	 raw_flag;  	/* Output in Raw (headerless) format FLAG */

/*
 *  Output in X Pixmap (XPM) format (optional flag)
 */
int	 xpm_flag;  	/* Output in X Pixmap (XPM) format FLAG */

/*
 *  Output in Sun Raster format (optional flag)
 */
int	 rast_flag;  	/* Output in Sun Raster format FLAG */

/*
 *  Supported format not available via the format flags (optional string)
 */
char	*format_string;	/* Supported format not available via the format flags STRING */
int	 format_flag;   	/* Supported format not available via the format flags FLAG */

/*-- required ME group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kformats_get_args PROTO((kform *));
void kformats_usage_additions PROTO((void));
void kformats_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
