 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kcomment
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kcomment.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Change the Comment on a Data Object
|
|       Purpose: main program for kcomment
|
|         Input:
|		char *clui_info->i_file; {Input Data Object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->s_string; {Comment String}
|		int   clui_info->s_flag; {TRUE if -s specified}
|
|		char *clui_info->o_file; {Resulting Output Data Object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Optional M.E. group:
|		    int clui_info->ed_logic; {Edit Existing Comment}
|		    int clui_info->ed_flag; {TRUE if -ed specified}
|
|		    int clui_info->re_flag; {TRUE if -re specified}
|
|		    int clui_info->pr_flag; {TRUE if -pr specified}
|
|		    int clui_info->ap_flag; {TRUE if -ap specified}
|
|        Output:
|       Returns:
|
|    Written By: Steven Kubica
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject iobj = NULL;
	kobject oobj = NULL;

	char *fname = NULL;
	char *oldcomment = NULL;
	char *newcomment = NULL;
	char *tmp_filename = NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kcomment_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kcomment",
		kcomment_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kcomment_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	/*
         *   This routine is rather unconventional...
	 *   The approach taken here is to open the input object
         *   and snag a copy of the comment to be edited with
         *   keditfile().  
         * 
	 *   Once the comment is "finished" two things can happen :
         *    - If there is an output specified, the input is copied to 
         *      the output and the new comment is assigned.  
	 *    - If there is not an output specified, the input is copied
         *      to a temporary output, the comment is assigned, and
         *      then the the temporary output is copied over the input.
	 */ 

	/* open the input object */
	if ((iobj = kpds_open_input_object(clui_info->i_file))
		== KOBJECT_INVALID)
	{
  	   kerror("kcomment","main",
		  "Unable to open input data object '%s'.",
		  clui_info->i_file );
	   kexit(KEXIT_FAILURE);
	}
/* -main_before_lib_call_end */

/* -main_library_call */
	/* do they want to replace it? */
	if (clui_info->re_flag)
 	   newcomment = clui_info->s_string;


	/* do they want to append or prepend to it? */
	else if (clui_info->ap_flag || clui_info->pr_flag)
	{
 	   /* get the old comment */
	   if (!kpds_get_attribute(iobj,KPDS_COMMENT,&oldcomment))
	   {
	      kerror("kcomment", "main",
		     "Unable to retreive old comment from %s.", 
		     clui_info->i_file);
 	      kpds_close_object(iobj);
	      kexit(KEXIT_FAILURE);
	   }
 
	   /* append or prepend to the comment */
	   if (clui_info->ap_flag) {
              /* need \0 to terminate new string */
	      newcomment = kstring_3cat(oldcomment,clui_info->s_string,
				 	'\0',NULL);
	   }
           else
              newcomment = kstrcat(clui_info->s_string,oldcomment);

	}

	/* do they want to edit it? */
	else if (clui_info->ed_logic)
	{
	   /*  get the old comment */
	   if (!kpds_get_attribute(iobj,KPDS_COMMENT,&oldcomment))
	   {
	      kerror("kcomment", "main",
		     "Unable to retreive old comment from %s.", 
		     clui_info->i_file);
 	      kpds_close_object(iobj);
	      kexit(KEXIT_FAILURE);
	   }

	      /* 
	       *   write out the old comment to a temporary file
	       */
	   tmp_filename = ktempnam(NULL,"kcomment");
	   kwritefile(tmp_filename, oldcomment, 0);
	   
	      /* 
	       *   let user edit this file
	       */
	   keditfile(tmp_filename,FALSE,NULL);

	      /*
	       *   read in the new comment
	       */
	   newcomment = kreadfile(tmp_filename, NULL);
	   kunlink(tmp_filename);
	}
/* -main_library_call_end */

/* -main_after_lib_call */
	/* if there is an output file, copy the input and set the comment */
	if (clui_info->o_flag)
    	{

	    /* open the output file */
	    oobj = kpds_open_output_object(clui_info->o_file);
            if (oobj == NULL)
            {
  	       kerror("kcomment", "main",
		      "Unable to open output object %s.", clui_info->o_file);
               kfree(newcomment);
               kpds_close_object(iobj);
 	       kexit(KEXIT_FAILURE);
            }
	   
	    /* copy the input */
	    if (!kpds_copy_object(iobj,oobj))
            {
  	       kerror("kcomment", "main",
		      "Unable to copy input to temporary object %s.", 
		       tmp_filename);
               kfree(newcomment);
   	       kpds_close_object(iobj);
               kpds_close_object(oobj);
               kexit(KEXIT_FAILURE);
            }


 	    /* set the comment */
	    if (!kpds_set_attribute(oobj,KPDS_COMMENT,newcomment))
            {
  	       kerror("kcomment", "main",
		      "Failed to set the new comment on output object %s.", 
		       clui_info->o_file);
               kfree(newcomment);
               kpds_close_object(iobj);
               kpds_close_object(oobj);
 	       kexit(KEXIT_FAILURE);
            }

            /* close both of the input and output objects */
            kfree(newcomment);
  	    kpds_close_object(iobj);
            kpds_close_object(oobj);
	}
	else  /* make a temporary output, and copy it over the input */
	{

	    tmp_filename = ktempnam(NULL,"kcomment");
 	    oobj = kpds_open_output_object(tmp_filename);
            if (oobj == NULL)
            {
  	       kerror("kcomment", "main",
		      "Unable to temporary output object %s.", tmp_filename);
               kfree(newcomment);
               kpds_close_object(iobj);
 	       kexit(KEXIT_FAILURE);
            }
	    
	    /* copy the input */
	    if (!kpds_copy_object(iobj,oobj))
            {
  	       kerror("kcomment", "main",
		      "Unable to copy input to temporary object %s.", 
		       tmp_filename);
               kfree(newcomment);
   	       kpds_close_object(iobj);
               kpds_close_object(oobj);
               kexit(KEXIT_FAILURE);

            }

 	    /* set the comment */
	    if (!kpds_set_attribute(oobj,KPDS_COMMENT,newcomment))
            {
  	       kerror("kcomment", "main",
		      "Failed to set the new comment on output object %s.", 
		       clui_info->o_file);
               kfree(newcomment);
   	       kpds_close_object(iobj);
               kpds_close_object(oobj);
               kexit(KEXIT_FAILURE);
            }

            /* close both of the input and output objects */
            kfree(newcomment);
	    kpds_close_object(iobj);
            kpds_close_object(oobj);

	    /* copy it back */
	    if (kcopyfile(tmp_filename,clui_info->i_file) == -1) 
            {
  	       kerror("kcomment", "main",
		      "Unable to copy temporary object %s over input.\n"
		      "Input is unchanged.", tmp_filename);
               kexit(KEXIT_FAILURE);
            }
                
            /* get rid of the temporary output file */
	    kunlink(tmp_filename);
	}	
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kcomment_usage_additions
| 
|       Purpose: Prints usage additions in kcomment_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcomment
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kcomment_usage_additions(void)
{
	kfprintf(kstderr, "\tChange the Comment on a Data Object\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kcomment_free_args
| 
|       Purpose: Frees CLUI struct allocated in kcomment_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcomment
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kcomment_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->s_string);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
