 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kcmplx.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kcmplx_get_args
| 
|       Purpose: Gets command line args for kcmplx
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcmplx
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kcmplx_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kcmplx is out of sync with arguments specified in kcmplx's *.pane file; please rerun ghostwriter on kcmplx.";


	/*
	 * allocate the kcmplx structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kcmplx_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kcmplx_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "conj",
			  &(clui_info->conj_flag))))
	{
	    kerror(NULL, "kcmplx_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "p2r",
			  &(clui_info->p2r_flag))))
	{
	    kerror(NULL, "kcmplx_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "r2p",
			  &(clui_info->r2p_flag))))
	{
	    kerror(NULL, "kcmplx_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



