 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kaxis
   >>>> 
   >>>>    Written By: Donna Koechner, Steve Kubica
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kaxis_h_
#define _kaxis_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kaxis/uis/kaxis.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  input data object (required infile)
 */
char	*i_file;	/* input data object FILENAME */
int	 i_flag;	/* input data object FLAG */

/*
 *  resulting data object (required outfile)
 */
char	*o_file;	/* resulting data object FILENAME */
int	 o_flag;	/* resulting data object FLAG */

/*----- optional ME group ----*/
/*
 *  assign input width data to output width axis (optional flag)
 */
int	 ww_flag;  	/* assign input width data to output width axis FLAG */

/*
 *  Assign input width data to output height axis (optional flag)
 */
int	 wh_flag;  	/* Assign input width data to output height axis FLAG */

/*
 *  Assign input width data to output depth axis (optional flag)
 */
int	 wd_flag;  	/* Assign input width data to output depth axis FLAG */

/*-- optional ME group end ---*/

/*----- optional ME group ----*/
/*
 *  Assign input height data to output width axis (optional flag)
 */
int	 hw_flag;  	/* Assign input height data to output width axis FLAG */

/*
 *  Assign input height data to output height axis (optional flag)
 */
int	 hh_flag;  	/* Assign input height data to output height axis FLAG */

/*
 *  Assign input height data to output depth axis (optional flag)
 */
int	 hd_flag;  	/* Assign input height data to output depth axis FLAG */

/*-- optional ME group end ---*/

/*----- optional ME group ----*/
/*
 *  Assign input depth data to output width axis (optional flag)
 */
int	 dw_flag;  	/* Assign input depth data to output width axis FLAG */

/*
 *  Assign input depth data to output height axis (optional flag)
 */
int	 dh_flag;  	/* Assign input depth data to output height axis FLAG */

/*
 *  Assign input depth data to output depth axis (optional flag)
 */
int	 dd_flag;  	/* Assign input depth data to output depth axis FLAG */

/*-- optional ME group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kaxis_get_args PROTO((kform *));
void kaxis_usage_additions PROTO((void));
void kaxis_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
