 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kaxis
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kaxis.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Reorient Data on the Width, Height, and Depth Axes
|
|       Purpose: main program for kaxis
|
|         Input:
|		char *clui_info->i_file; {input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {resulting data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Optional M.E. group:
|		    int clui_info->ww_flag; {TRUE if -ww specified}
|
|		    int clui_info->wh_flag; {TRUE if -wh specified}
|
|		    int clui_info->wd_flag; {TRUE if -wd specified}
|
|		Optional M.E. group:
|		    int clui_info->hw_flag; {TRUE if -hw specified}
|
|		    int clui_info->hh_flag; {TRUE if -hh specified}
|
|		    int clui_info->hd_flag; {TRUE if -hd specified}
|
|		Optional M.E. group:
|		    int clui_info->dw_flag; {TRUE if -dw specified}
|
|		    int clui_info->dh_flag; {TRUE if -dh specified}
|
|		    int clui_info->dd_flag; {TRUE if -dd specified}
|
|        Output:
|       Returns:
|
|    Written By: Donna Koechner, Steve Kubica
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject src=NULL, dst=NULL;
	int inwidth=0, inheight=0, indepth=0;
	int outwidth=0, outheight=0, outdepth=0;
	int axis1=KWIDTH, axis2=KHEIGHT, axis3=KDEPTH;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kaxis_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kaxis",
		kaxis_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kaxis_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	/* 
	 *  First check that no more than one input dimension has been
	 *  assigned to each output axis.
	 */
	if (clui_info->ww_flag)
	{
	   inwidth ++;
	   outwidth ++;
	   axis1=KWIDTH;
	}
	if (clui_info->wh_flag)
	{
	   inwidth ++;
	   outheight ++;
	   axis2=KWIDTH;
	}
	if (clui_info->wd_flag)
	{
	   inwidth ++;
	   outdepth ++;
	   axis3=KWIDTH;
	}
	if (clui_info->hw_flag)
	{	
	   inheight ++;
	   outwidth ++;
	   axis1=KHEIGHT;
	}
	if (clui_info->hh_flag)
	{
	   inheight ++;
	   outheight ++;
	   axis2=KHEIGHT;
	}
	if (clui_info->hd_flag)
	{
	   inheight ++;
	   outdepth ++;
	   axis3=KHEIGHT;
	}
	if (clui_info->dw_flag)
	{
	   indepth ++;
	   outwidth ++;
	   axis1=KDEPTH;
	}
	if (clui_info->dh_flag)
	{
	   indepth ++;
	   outheight ++;
	   axis2=KDEPTH;
	}
	if (clui_info->dd_flag)
	{
	   indepth ++;
	   outdepth ++;
	   axis3=KDEPTH;
	}
	kinfo(KVERBOSE,"inwidth=%d, inheight=%d, indepth=%d, outwidth=%d, outheight=%d, outdepth=%d", 
		inwidth, inheight, indepth, outwidth, outheight, outdepth);
	if ((inwidth  > 1) || (inheight  > 1) || (indepth  > 1) ||
	    (outwidth > 1) || (outheight > 1) || (outdepth > 1) )
	{
            kerror("kaxis", "main",
            "One and only one input axis may be assigned to each output axis.");
            kexit(KEXIT_FAILURE);
	}
	if (outwidth == 0)
	{  
	   if (inwidth == 0)
	      axis1=KWIDTH;
	   else
	   {
	      if (clui_info->wh_flag)
	         axis1 = KHEIGHT;
	      else if (clui_info->wd_flag)
		 axis1 = KDEPTH;
	      else 
	      {
	         kerror("kaxis", "main", "cannot determine output width axis");
	 	 kexit(KEXIT_FAILURE);
	      }
	   }
	}
	if (outheight == 0)
	{
	   if (inheight == 0)
	      axis2=KHEIGHT;
	   else
	   {
	      if (clui_info->hw_flag)
	         axis2 = KWIDTH;
	      else if (clui_info->hd_flag)
	         axis2 = KDEPTH;
	      else 
	      {
	         kerror("kaxis", "main", "cannot determine output height axis");
	 	 kexit(KEXIT_FAILURE);
	      }
	   }
	}
	if (outdepth == 0)
	{
	   if (indepth == 0)
	      axis3=KDEPTH;
	   else
	   {
	      if (clui_info->dw_flag)
	         axis3 = KWIDTH;
	      else if (clui_info->dh_flag)
	         axis3 = KHEIGHT;
	      else 
	      {
	         kerror("kaxis", "main", "cannot determine output depth axis");
	 	 kexit(KEXIT_FAILURE);
	      }
	   }
	}

	/*
	 *  Open the source and destination objects. 
 	 */

	 if ((src=kpds_open_input_object(clui_info->i_file)) == KOBJECT_INVALID)
	 {
            kerror("kaxis", "main",
            	"Unable to open source object %s.", clui_info->i_file);
            kexit(KEXIT_FAILURE);
	 }
	 if ((dst=kpds_open_output_object(clui_info->o_file))==KOBJECT_INVALID)
	 {
            kerror("kaxis", "main",
            	"Unable to open destination object %s.", clui_info->o_file);
            kexit(KEXIT_FAILURE);
	 }
/* -main_before_lib_call_end */

/* -main_library_call */
#if 0

/* temporarily commented out -- IT SHOULD WORK, but it doesn't..
	oh well...				Steve K & Donna */
#endif

	/*
	 *  Set the axis attribute on the input object 
	 */
	kinfo(KVERBOSE,"axis1=%d, axis2=%d, axis3=%d", axis1, axis2, axis3);
	 if (!(kpds_set_attribute(src,KPDS_AXIS_ASSIGNMENT,axis1,axis2,axis3)))
	 {
            kerror("kaxis", "main",
                "Unable to set axis assignment attribute on source object.");
            kexit(KEXIT_FAILURE);
         }

	/*  
	 *  Copy the input object attributes to the output object.
	 */
	 if (!kpds_copy_object(src, dst))
	 {
            kerror("kaxis", "main",
                "Unable to copy source to destination object.");
            kexit(KEXIT_FAILURE);
         }

#if 0

/* v-TEMPORARILY ADDED IN---------- */
        /*
         *  TEMPORARILY ADDED IN 
         *  Set the axis attribute on the input object
         */
        kinfo(KVERBOSE,"axis1=%d, axis2=%d, axis3=%d", axis1, axis2, axis3);
         if (!(kpds_set_attribute(dst,KPDS_AXIS_ASSIGNMENT,axis1,axis2,axis3)))
         {
            kerror("kaxis", "main",
                "Unable to set axis assignment attribute on destination object.");
            kexit(KEXIT_FAILURE);
         }

	/* force the dst index order to sync */
	kdms_set_attribute(dst, KDMS_SEGMENT_VALUE, KDMS_COUPLING, KDEMAND);
	kdms_sync(dst, KDMS_SEGMENT_VALUE, KPRES2PHYS);
#endif

/* ^-TEMPORARILY ADDED IN---------- */
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(dst, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("kaxis", "main", 
		  "Unable to set a history on the destination object");
            kexit(KEXIT_FAILURE);
	}

	/* tidy up the objects */
	kpds_close_object(dst);
	kpds_close_object(src);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kaxis_usage_additions
| 
|       Purpose: Prints usage additions in kaxis_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kaxis
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kaxis_usage_additions(void)
{
	kfprintf(kstderr, "\tReorient Data on the Width, Height, and Depth Axes\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kaxis_free_args
| 
|       Purpose: Frees CLUI struct allocated in kaxis_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kaxis
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kaxis_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
