 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kasc2time
   >>>> 
   >>>>    Written By: John Salas, Steve Kubica
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kasc2time_h_
#define _kasc2time_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include "ksegops/ksegops.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kasc2time/uis/kasc2time.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  ASCII input data file containing new data segment (required infile)
 */
char	*i1_file;	/* ASCII input data file containing new data segment FILENAME */
int	 i1_flag;	/* ASCII input data file containing new data segment FLAG */

/*
 *  output data object (required outfile)
 */
char	*o_file;	/* output data object FILENAME */
int	 o_flag;	/* output data object FLAG */

/*
 *  data object input to insert the new segment into (optional infile)
 */
char	*i2_file;	/* data object input to insert the new segment into FILENAME */
int	 i2_flag;	/* data object input to insert the new segment into FLAG */

/*
 *  starting point in ASCII file to start importing at (optional integer)
 */
int	 so_int; 	/* starting point in ASCII file to start importing at INT */
int	 so_flag;	/* starting point in ASCII file to start importing at FLAG */

/*
 *  time (optional integer)
 */
int	 tsize_int; 	/* time INT */
int	 tsize_flag;	/* time FLAG */

/*
 *  data type (Optional list)
 */
int	 type_list;	/* data type LIST INDEX */
char	 *type_label;	/* data type LIST LABEL */
int	 type_flag;	/* data type FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kasc2time_get_args PROTO((kform *));
void kasc2time_usage_additions PROTO((void));
void kasc2time_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
