 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for karith1
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "karith1.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Single Operator Pointwise Arithmetic
|
|       Purpose: main program for karith1
|
|         Input:
|		char *clui_info->i_file; {input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {resulting output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    int clui_info->abs_flag; {TRUE if -abs specified}
|
|		    int clui_info->sin_flag; {TRUE if -sin specified}
|
|		    int clui_info->sqrt_flag; {TRUE if -sqrt specified}
|
|		    int clui_info->asin_flag; {TRUE if -asin specified}
|
|		    int clui_info->cbrt_flag; {TRUE if -cbrt specified}
|
|		    int clui_info->cos_flag; {TRUE if -cos specified}
|
|		    int clui_info->neg_flag; {TRUE if -neg specified}
|
|		    int clui_info->acos_flag; {TRUE if -acos specified}
|
|		    int clui_info->recip_flag; {TRUE if -recip specified}
|
|		    int clui_info->tan_flag; {TRUE if -tan specified}
|
|		    int clui_info->ceil_flag; {TRUE if -ceil specified}
|
|		    int clui_info->atan_flag; {TRUE if -atan specified}
|
|		    int clui_info->floor_flag; {TRUE if -floor specified}
|
|		    int clui_info->sinh_flag; {TRUE if -sinh specified}
|
|		    int clui_info->trunc_flag; {TRUE if -trunc specified}
|
|		    int clui_info->asinh_flag; {TRUE if -asinh specified}
|
|		    int clui_info->fract_flag; {TRUE if -fract specified}
|
|		    int clui_info->cosh_flag; {TRUE if -cosh specified}
|
|		    int clui_info->lgamma_flag; {TRUE if -lgamma specified}
|
|		    int clui_info->acosh_flag; {TRUE if -acosh specified}
|
|		    int clui_info->erf_flag; {TRUE if -erf specified}
|
|		    int clui_info->tanh_flag; {TRUE if -tanh specified}
|
|		    int clui_info->erfc_flag; {TRUE if -erfc specified}
|
|		    int clui_info->atanh_flag; {TRUE if -atanh specified}
|
|		    int clui_info->sinc_flag; {TRUE if -sinc specified}
|
|		    int clui_info->not_flag; {TRUE if -not specified}
|
|		    int clui_info->clear_flag; {TRUE if -clear specified}
|
|		    int clui_info->set_flag; {TRUE if -set specified}
|
|        Output:
|       Returns:
|
|    Written By: Scott Wilson, Donna Koechner, Mark Young, Ashish Malhotra
|          Date: Apr 12, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject in_obj = NULL;
	kobject out_obj = NULL;
	char    *function = NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(karith1_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "karith1",
		karith1_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	karith1_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	if ((in_obj = kpds_open_input_object(clui_info->i_file)) 
		== KOBJECT_INVALID)
        {
           kerror("karith1","main", "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }

	if ((out_obj = kpds_open_output_object(clui_info->o_file)) 
		== KOBJECT_INVALID)
        {
           kerror("karith1","main", "Cannot open output object.");
           kexit(KEXIT_FAILURE);
        }

        if (clui_info->abs_flag)
	   function = "abs";
        else if (clui_info->sqrt_flag)
	   function = "sqrt";
        else if (clui_info->cbrt_flag)
	   function = "cbrt";
        else if (clui_info->neg_flag)
	   function = "neg";
        else if (clui_info->recip_flag)
	   function = "recip";
        else if (clui_info->sin_flag)
	   function = "sin";
        else if (clui_info->asin_flag)
	   function = "asin";
        else if (clui_info->cos_flag)
	   function = "cos";
        else if (clui_info->acos_flag)
	   function = "acos";
        else if (clui_info->tan_flag)
	   function = "tan";
        else if (clui_info->atan_flag)
	   function = "atan";
        else if (clui_info->sinh_flag)
	   function = "sinh";
        else if (clui_info->asinh_flag)
	   function = "asinh";
        else if (clui_info->cosh_flag)
	   function = "cosh";
        else if (clui_info->acosh_flag)
	   function = "acosh";
        else if (clui_info->tanh_flag)
	   function = "tanh";
        else if (clui_info->atanh_flag)
	   function = "atanh";
        else if (clui_info->sinc_flag)
	   function = "sinc";
        else if (clui_info->ceil_flag)
	   function = "ceil";
        else if (clui_info->floor_flag)
	   function = "floor";
        else if (clui_info->trunc_flag)
	   function = "trunc";
        else if (clui_info->fract_flag)
	   function = "fract";
        else if (clui_info->erfc_flag)
	   function = "erfc";
        else if (clui_info->erf_flag)
	   function = "erf";
        else if (clui_info->lgamma_flag)
	   function = "lgamma";
        else if (clui_info->not_flag)
	   function = "not";
	else if (clui_info->clear_flag)
	   function = "clear";
	else if (clui_info->set_flag)
	   function = "set";
	else 
	{
           kerror("karith1","main", "Valid operation flag not supplied.");
           kexit(KEXIT_FAILURE);
        }

        if (!kpds_copy_object_attr(in_obj, out_obj))
	{
           kerror("karith1","main", 
		  "Unable to copy attributes from input to output object.");
           kexit(KEXIT_FAILURE);
        }
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!lkarith1(in_obj, function, out_obj))
	   kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("karith1", "main", 
		  "Unable to set history on the destination object");
            kexit(KEXIT_FAILURE);
	}
	
        if (!kpds_copy_remaining_data(in_obj, out_obj))
	{
           kerror("karith1","main", 
		  "Unable to copy remaining data from input to output object.");
           kexit(KEXIT_FAILURE);
        }

	kpds_close_object(in_obj);
	kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: karith1_usage_additions
| 
|       Purpose: Prints usage additions in karith1_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname karith1
|          Date: Apr 12, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void karith1_usage_additions(void)
{
	kfprintf(kstderr, "\tSingle Operator Pointwise Arithmetic\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: karith1_free_args
| 
|       Purpose: Frees CLUI struct allocated in karith1_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname karith1
|          Date: Apr 12, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
karith1_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
