#!/bin/sh

#
# Khoros: $Id$
#
# $Log$
#

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.

#************************************************************
#
#  Routine Name: klicense - Khoros Free Access License Information
#
#       Purpose: This program will display the Khoros Free Access 
#		 license.
#
#         Input: None
#
#    Written By: Tom Sauer & Steve Jorgensen
#          Date: Aug 27, 1994
# Modifications: 
#
#************************************************************/

# This section begins a useful library of routines that are general enough to
# be used in other sh scripts.
# ------------------------------------------------------------------------
# set up some other standard commands.
# eventually we should do something like the below code for echo,
# check for each of them on the path.  Oh for perl!
 
  cp="cp"
  mv="mv -f"
  rm="rm -f"
 awk="awk"
 sed="sed"
grep="grep"
TMPDIR=${TMPDIR:-/tmp}


# clean up if they interrupt the script.
#----------------------------------------------------------
cleanup()
{
        echo ""
        $rm $TMPDIR/klicense.*.$$
        echo ""
        exit 0
}
trap cleanup 2

# build a $echoN variable and $echoEnd combination that will give
# will allow the echon procedure to work well.
FindEchoN()
{
        # build a list of potential echos, starting with sh built-in
        echoEnd=""
        elist="echo"
        for dir in `echo $PATH | $sed -e 's/:/ /g'`; do
                [ -x "$dir/echo" ] && elist="$elist $dir/echo"
        done
 
        # work through list, see if one of them groks -n
        for echo in $elist; do
                result=`$echo -n hello`
                if [ "$result" != "-n hello" ]; then
                        echoN="$echo -n"
                        break
                fi
        done
        if [ "$echoN" = "" ]; then
                echoN=echo
                echoEnd="\c"
                result=`$echoN "testing"$echoEnd`
                if [ "$result" != "testing" ]; then
                        unset echoEnd
                fi
        fi
}

# quitting
quit()
{
        cleanup
}

# echo without without return
echon()
{
        $echoN "$* $echoEnd"
}

# clear screen function
clr()
{
        clear
}

# find the more or page program
findmore()
{
        pager="/usr/ucb/more"
        if [ -x $pager ]; then
                return
        fi

        dlist=`echo $PATH | $sed -e 's/:/ /g'`

        for dir in $dlist; do
                if [ -x "$dir/more" ]; then
                        pager="$dir/more"
                        return
                fi
        done

        for dir in $dlist; do
                if [ -x "$dir/page" ]; then
                        pager="$dir/page"
                        return
                fi
        done

        for dir in $dlist; do
                if [ -x "$dir/pg" ]; then
                        pager="$dir/pg"
                        return
                fi
        done

        pager="none"
}

# Display the Khoros Free Access License
dislicense()
{
	boot_path=`kecho -tb bootstrap -echo path`
	lic_path="$boot_path/repos/license/License"
	findmore
	clr
	if [ "$pager" != "none" ]; then
                $pager $lic_path
	else
		cat $lic_path
	fi

}

# This section begins the main program part of the sh script
# ------------------------------------------------------------------------

clr
FindEchoN
$echoN "Formatting Khoros Free Access License for display.....Please wait..."
dislicense
quit

