#!/bin/sh
#
#
#  Khoros: $Id$
#

#
# $Log$
#

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.

#************************************************************
#
#  Routine Name: kgenmake - makes the makefile for imake
#
#       Purpose: This program call imake to generate a
#		 Makefile from an Imakefile. Imake is
#		 with the appropriate include paths and
#		 template files.
#
#         Input: None
#
#        Output: A new Makefile
#
#      Comments: 
#        Status: Public Routine
#    Written By: Tom Sauer
#          Date: 10-April-93
#      Verified:
#  Side Effects:
# Modifications: Converted from kgenmake in Khoros 1.0 (TS)
#		 Converted to Bourne shell from K2 csh version (neilb)
#		 Modified to add support for multiple toolbox files (neilb)
#		 Modified to use bootstrap instead of khoros toolbox (MY)
#		 Modified to use dataserv as well as khoros toolbox (MY/JS)
#		 Modified to khoros toolbox to design (MY/SJ)
#
#************************************************************/

arg_list=$*
arg_num=$#

# Standard header for error messages
# ------------------------------------------------------------------------
Kerror() {
	echo ""
	echo "Toolbox: ${TOOLBOX:-UNKNOWN}"
	echo "Program: kgenmake"
}

# Check that Imakefile is present in current directory
# ------------------------------------------------------------------------
CheckImakefile() {
	if [ ! -f Imakefile ]; then
		Kerror
		echo "I need an Imakefile to work with."
		echo "Please use kgenimake to create an Imakefile"
		echo ""
		exit 1
	fi
}

# Display usage information and exit
# ------------------------------------------------------------------------
DisplayUsage() {
	echo ""
	echo "kgenmake: Update or Generate a Makefile from an Imakefile"
	echo ""
	echo "usage:"
	echo "    kgenmake [-V] [-U]"
	echo ""
	echo "where:"
	echo "    [-V]	gives the version for kgenmake"
	echo "    [-U]	gives the usage for kgenmake"
	echo ""
	exit 0
}

# Display version information and exit
# ------------------------------------------------------------------------
DisplayVersion() {
	echo ""
	echo "Toolbox Version:"
	echo "	Khoros 2.0"
	echo ""
	echo "Program Version:"
	echo "	kgenmake 2.0"
	echo ""
	exit 0
}

# ------------------------------------------------------------------------
# Main body of kgenmake
# ------------------------------------------------------------------------
for arg in $arg_list
do
	case $arg in
		-U)	DisplayUsage ;;
		-V)	DisplayVersion ;;
	esac
done

CheckImakefile

# Run kimake with appropriate arguments
# ------------------------------------------------------------------------
	# Mostly likely called from a `make Makefile'
	kimake $arg_list
	exec make depend
exit 0



