
#
#  Khoros: $Id$
#  $Log$
#

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.


# # ========================================================================
# #
# # define various unix utilities we're gonna use
# #
# # ========================================================================

# ------------------------------------------------------------------------
# set up some other standard commands.
# eventually we should do something like the above code for echo,
# check for each of them on the path.  Oh for perl!

  cp="cp"
  mv="mv -f"
  rm="rm -f"
 awk="awk"
 sed="sed"
grep="grep"
TMPDIR=${TMPDIR:-/tmp}

clr=""
for dir in `echo $PATH | $sed -e 's/:/ /g'`; do
    [ -x "$dir/clear" ] && clr="$dir/clear"
done

if [ $clr = "" ]; then
  clr="echo -c [H[J"
fi
 
# ------------------------------------------------------------------------
# let's see if we can use echo -n for prompting ...

# build a $echoN variable and $echoEnd combination that will give
# will allow the echon procedure to work well.
FindEchoN()
{
        # build a list of potential echos, starting with sh built-in
        echoEnd=""
        elist="echo"
        for dir in `echo $PATH | $sed -e 's/:/ /g'`; do
                [ -x "$dir/echo" ] && elist="$elist $dir/echo"
        done
 
        # work through list, see if one of them groks -n
        for echo in $elist; do
                result=`$echo -n hello`
                if [ "$result" != "-n hello" ]; then
                        echoN="$echo -n"
                        break
                fi
        done
        if [ "$echoN" = "" ]; then
                echoN=echo
                echoEnd="\c"
                result=`$echoN "testing"$echoEnd`
                if [ "$result" != "testing" ]; then
                        unset echoEnd
                fi
        fi
}

# prompt the user, to see if we should go on
YesNoPrompt()
{
        if [ "$#" -eq 0 ]; then
                echon "Do you wish to continue? (y/n) [y]:"
        else
		if [ "$#" -eq 2 ]; then
                	echon "$1 (y/n) [$2]:"
		else
                	echon "$1 (y/n) [y]:"
		fi
        fi
        read resp
	if [ "$#" -eq 2 -a "$resp" = "" ]; then
		resp=$2
	fi
        if [ "$resp" = "n" -o "$resp" = "N" ]; then
                return 1
        fi
        return 0
}

# clean up behind us, for example if this script gets interrupted
# ------------------------------------------------------------------------
cleanup() {
	echo ""
	echo "installit script exiting"
	echo "I'll just tidy up any temp files which might be lying around..."
	$rm $TMPDIR/installit.$$
	echo bye
	echo ""
	exit 0
}
# if user biffs ctrl-C, call our cleanup() function
trap cleanup 2

# echo without without return
echon()
{
        $echoN "$* $echoEnd"
}

# this is called every time we change `topic'
newtopic() {
	$clr
}

updatetbpath() {
	echo ""
	echo "replacing the TOPDIR path in the Toolbox file"
	echo "with the actual path to the Khoros 2.0 Toolbox file"
	echo ""
	cmd="s|TOPDIR|$TOPDIR|g"
	$sed -e $cmd < $TOPDIR/bootstrap/repos/Toolboxes > $TMPDIR/installit.$$
	$cp $TMPDIR/installit.$$ $TOPDIR/Toolboxes
	$rm $TMPDIR/installit.$$
}

# prompt the user, do they want to continue
# be polite if they don't
# ------------------------------------------------------------------------
ConfirmContinue() {
	YesNoPrompt "Do you wish to continue?"
        if [ "$?" -eq "1" ]; then
                echo ""
                echo "Ok, bye..."
                echo ""
                cleanup
        fi
}

if [ ! -d bootstrap -a ! -d bin ]; then
	echo ""
	echo "ERROR: "
	echo "You must not be in the Khoros 2.0 top level directory"
	echo "Change directory to the top level directory of Khoros 2.0,"
	echo "and re-run the installit program"
	exit 1
fi

FindEchoN
newtopic

cat <<"EndIntro"

			Khoros 2.0 Installation

	This script makes sure that your environment is set up correctly
	and helps you install Khoros 2.0.

	You will be prompted for the binary and library
	directories, and the BOOTSTRAP flags necessary to compile Khoros 2.0.

	The script will then compile the bootstrap programs, and
	if that stage is successful, will compile the Khoros toolbox.

	The compile status for Khoros will be logged to the file
	bootstrap/objects/make.World. You can use the command
		% tail -f make.World
	to watch the compile.

	(If you experience any problems with this script, please report
	them to khoros-bugs@khoros.unm.edu)

EndIntro

YesNoPrompt "Do you wish to continue the installation?"
if [ "$?" -eq 1 ]; then
	echo "Ok, bye..."
	echo ""
	exit 0
fi

echo ""
echo ""
echo "Checking your environment to make sure it is set up correctly...."

if [ -f Toolboxes ]; then
	TOPDIR=`$grep "^BOOTSTRAP" Toolboxes | $awk -F: '{ print $2 }' | \
		$sed 's|/bootstrap||'`
else
	TOPDIR=`pwd`
fi

ans="n"
while [ "$ans" = "n" ]; do
	echo ""
	echo "Please enter the full path to the toplevel of Khoros 2.0"
	echon "[$TOPDIR]: "
	read temp
	if [ "$temp" = "" ]; then
		temp=$TOPDIR
	fi

	if [ -d "$temp/bootstrap" ]; then
		TOPDIR=$temp
		ans="y"
	elif [ ! -d "$temp" ]; then
		echo ""
		echo not a valid directory $temp\!
		echo ""
	else
		echo ""
		echo bootstrap directory does not exist in $temp\!
		echo $temp can not be the toplevel of Khoros 2.0\!
		echo ""
	fi
done

if [ -f $TOPDIR/bootstrap/repos/db/imprint ]; then
   chmod 666 $TOPDIR/bootstrap/repos/db/imprint
fi
chmod 755 $TOPDIR/bootstrap/objects/script/kgenmake/src/kgenmake.sh

if [ "$KHOROS_TOOLBOX" = "" ]; then
	cat <<"	EndError"

		The environment variable KHOROS_TOOLBOX has not been set.
		I will call the 'kconfigure' program for you, which will
		help set up your environment to install and use Khoros.


	EndError
	ConfirmContinue
	bin/kconfigure $TOPDIR && cleanup
	KHOROS_TOOLBOX=$HOME/.Toolboxes
	export KHOROS_TOOLBOX
fi


KHOROS_TOOLBOX=$TOPDIR/Toolboxes
DIST_SITE_FILE=$TOPDIR/bootstrap/repos/config/imake_config/Site.def
   DIST_CONFIG=$TOPDIR/bootstrap/repos/config/imake_config/config
  LOCAL_CONFIG=$TOPDIR/bootstrap/config

export KHOROS_TOOLBOX

updatetbpath

echo ""
echo "Your environment looks like it is in good shape, you are ready to continue"
echo ""
ConfirmContinue

# # ========================================================================
# #
# # get details of the machine we're building on
# #
# # ========================================================================
newtopic
needmach=1
while [ $needmach = 1 ]; do
	needmach=0
	cat <<"	EndMachList"
	What sort of machine are you building Khoros on?

	1.  Sun 3, 4, Sparc (SunOS 4.1.X)
	2.  Sun Sparc (Solaris 2.x)
	3.  Dec Alpha (OSF/1)
	4.  Data General (DGUX)			(partially ported)
	5.  DEC 3100/5000 (Ultrix)		(partially ported)
	6.  NetBSD				(not ported)
	7.  HP 9000 (s300, s400, s700, s800)	(partially ported)
	8.  IBM RS/6000	(AIX 3.2)		(partially ported)
	9.  SGI (IRIX 4.0.4 or 5.2)		(partially ported)
	10. Sony (NewOS)			(not ported)
	11. Interactive 386/486			(not ported)
	12. Cray (Unicos 8)			(partially ported)
	13. Convex				(not ported)
	14. BSDI's BSD/386			(partially ported)
	15. Linux				(partially ported)
	16. FreeBSD				(partially ported)
	17. Paragon (OSF1)			(partially ported)
	18. CPP-DAP                             (not ported)
	19. Sequent                             (partially ported)
	20. Convex Exemplar                     (partially ported)

	`q' to QUIT the installation
	EndMachList
	echon  "Enter 1-20 or 'q' to quit: "
	read mach

	if [ "$mach" = "q" -o "$mach" = "Q" ]; then
		$mv Makefile.org Makefile
		echo ""
		echo "Exiting the Khoros installation script.  Bye..."
		echo ""
		exit 0
	fi

	if [ "$mach" = "" -o "$mach" -lt 1 -o "$mach" -gt 20 ]; then
		echo ""
		echo "You entered an invalid machine type, please re-enter"
		echo ""
		needmach=1
	fi
done

case $mach in
 
	1)	defarch="sunos"				# Sun (SunOS 4.1.X)
		CONFIG_FLAGS="" ;;

	2)	defarch="solaris"			# Sparc (Solaris 2.1)
		CONFIG_FLAGS="-D_POSIX_SOURCE -DSVR4" ;;

	3)	defarch="osf"				# DEC Alpha
		CONFIG_FLAGS="" ;;

	4)	defarch="dgux"				# Data General
		CONFIG_FLAGS="-DSYSV -DDGUX -D_POSIX_SOURCE -ansi" ;;

	5)	defarch="ultrix"			# DEC 3100/5000
		CONFIG_FLAGS="" ;;

	6)	defarch="netbsd"			# NetBSD
		CONFIG_FLAGS="" ;;

	7)	defarch="hpux"				# HP 9000
		CONFIG_FLAGS="-D_POSIX_SOURCE -Aa" ;;

	8)	defarch="aix"				# IBM RS/6000
		CONFIG_FLAGS="-D_IBMR2 -D_POSIX_SOURCE" ;;

	9)	defarch="irix"				# SGI 4.0.4 or 5.2
		CONFIG_FLAGS="-D_POSIX_SOURCE" ;;

	10)	defarch="newos"				# Sony
		CONFIG_FLAGS="" ;;

	11)	defarch="i386"				# 386/486
		CONFIG_FLAGS="-DSYSV -DISC -DSYSV386" ;;

	12)	defarch="unicos"			# Cray
		CONFIG_FLAGS="-DSYSV -DUSGISH -D_POSIX_SOURCE" ;;

	13)	defarch="convex"			# Convex
		CONFIG_FLAGS="-Dconvex" ;;

	14)	defarch="bsdi"				# BSD/386
		CONFIG_FLAGS="-D_POSIX_SOURCE -DNFS_STDOUT_BUG" ;;

	15)	defarch="linux"				# Linux
		CONFIG_FLAGS="-D_POSIX_SOURCE" ;;

	16)     defarch="freebsd"			# FreeBSd 1.1
		CONFIG_FLAGS="-D_POSIX_SOURCE -DNFS_STDOUT_BUG" ;;

	17)     defarch="osf1"				# Paragon
		CONFIG_FLAGS="-D__OSF1__" ;;

        18)     defarch="dap"				# CPP-DAP
		CONFIG_FLAGS="" ;;

        19)     defarch=dynix                            # Dynix
		CONFIG_FLAGS="-D_POSIX_SOURCE -DSYSV" ;;

	20)	defarch="exemplar"			# HP Convex Exemplar
		CONFIG_FLAGS="-D_POSIX_SOURCE -D__convex_spp" ;;

esac

# # ========================================================================
# #
# # to support multiple architectures using a single source tree or klndir
# # need to find out a few things
# #
# # ========================================================================
newtopic
cat <<"EndMULTI"

			Multiple Architecture Support	

If you want to compile the Khoros 2.0 system on multiple architectures
you may want to try using the multiple architecture support provided.

NOTE: It is not been tested robustly and requires several things to
      be done by hand.

EndMULTI

YesNoPrompt "Do you want multiple architecture support?" "n"

if [ "$?" -eq "0" ]; then
   newtopic
	cat <<"	EndStuff"

	Ok, here we go ...

	You will be ask to provide the following information:
		1) The architecture of the machine.  It is the only one that
		   must be specified.  It should indictate the cpu type of the
		   machine, sparc, mips, alpha, parisc, rs6000, etc.
		2) The operating system of the machine.  Will not be used if 1)
		   not specified.  It should be something like, sunos, sunos413,
		   osf, osf13, solaris, solaris23, aix, unicos, etc.
		3) The default widget set for the machine.  Will not be used
		   if 1) and 2) not specified.  It should be either: athena,
		   motif or olit.  Since, those are the only ones we support,
		   but you can refer to them any way you want.  You will need
		   to set the #define WidgetSet in the Architecture
		   Configuration File to actually use the widget set.  Yes,
		   this is one of the "stuff by hand" I was talking about ;^).

	EndStuff

	ConfirmContinue

	needkarch=1
	while [ $needkarch = 1 ]; do
		newtopic
		needkarch=0
		echon "What is the architecture of the machine? "
		read resp
		if [ "$resp" = "" ]; then
			echo ""
			echo "You need to specify this one at least."
			echo ""
			needkarch=1
			ConfirmContinue
		else
			KARCH="$resp"
			echo ""
			echo "        You will need to set the environmant variable"
			echo "        KARCH to $KARCH once installit is done."
			echo ""
			export KARCH
			newarch=$KARCH
		fi
	done

	echon "What is the operating system of the machine? "
	read resp
	if [ "$resp" != "" ]; then
		KOPSYS="$resp"
		echo ""
		echo "        You will need to set the environmant variable"
		echo "        KOPSYS to $KOPSYS once installit is done."
		echo ""
		export KOPSYS
		newarch=$KARCH-$KOPSYS

		echon "What is the default widget set for the machine? "
		read resp
		if [ "$resp" != "" ]; then
			KWIDSET="$resp"
			echo ""
			echo "        You will need to set the environmant variable"
			echo "        KWIDSET to $KWIDSET once installit is done."
			echo ""
			export KWIDSET
			newarch=$KARCH-$KOPSYS-$KWIDSET
		fi
	fi

	CONFIG_FILE=$LOCAL_CONFIG/$newarch.cf
	SITE_FILE=$LOCAL_CONFIG/Site.$newarch

	YesNoPrompt "Do you wish to continue the installation?"
	if [ "$?" -eq 1 ]; then
		echo "Ok, bye..."
		echo ""
		exit 0
	fi

else

   CONFIG_FILE=$LOCAL_CONFIG/$defarch.cf
     SITE_FILE=$LOCAL_CONFIG/Site.$defarch

fi

# # ========================================================================
# #
# # find out which C compiler they want to use
# #
# # ========================================================================
needcc=1
while [ $needcc = 1 ]; do
	newtopic
	needcc=0
	cat <<"	EndCC" | $sed -e 's/^	//'

					C Compiler

	Are you using a C-compiler other than 'cc'?  For example 'gcc' or 'acc'.
	If you are using a C-compiler other than 'cc', please enter the
	C-compiler you wish to use. Note, if you set HasGcc in the platform
	configuration file to YES, then specify 'gcc' below.

	NOTE: whatever C compiler you use should be ANSI C compliant.

	EndCC

	echon "Enter C-compiler [cc]: "
	read resp
	if [ "$resp" = "" ]; then
		ccomp=cc
	else
		ccomp="$resp"
	fi

	foundcc=""
	for ccdir in `echo $PATH | $sed -e 's/:/ /g'`; do
	    if [ -x "$ccdir/$ccomp" ]; then
	       foundcc="$ccdir/$ccomp"
	       break
	    fi
	done
	if [ "$foundcc" = "" ]; then
	     echo ""
	     echo "The C-compiler $ccomp is not in your path."
	     echo "Please edit your path in your .cshrc or .login file"
             echo "to include the path to you C-compiler, and re-run installit."
	     echo ""
	     ConfirmContinue
	     needcc=1
	else
	     echo ""
	     echo "Using the C-complier $ccdir/$ccomp"
	     YesNoPrompt "Is this correct?"
	     if [ "$?" -eq 1 ]; then
		needcc=1
	     fi
	fi
done

arg1=`echo $ccomp|$sed -e 's/[	 ].*//'`
if [ "$arg1" = "gcc" -o "$arg1" = "gcc2" ]; then
	CONFIG_FLAGS="$CONFIG_FLAGS -DGCC_DEF"
fi

# # ========================================================================
# #
# # determine where binaries should be installed
# #
# # ========================================================================
newtopic

if [ -f $SITE_FILE ]; then
	CP_SITE=0
	temp=`$awk '$1=="#define" && $2=="BinDir" { print $3 }' $SITE_FILE`
   	[ "$temp" = "TOPDIR/bin" ] && temp=$TOPDIR/bin
else
	CP_SITE=1
	[ ! -d $LOCAL_CONFIG ] && mkdir $LOCAL_CONFIG
	$cp $DIST_SITE_FILE $SITE_FILE
	temp=$TOPDIR/bin;
fi

echo ""
echo "			Directory for Khoros binaries"
echo ""
echo "Enter the directory where you would like Khoros binaries to be installed."
echo "Just press RETURN to use the default."
echo ""
echon "Bin directory [$temp]: "
read bindir

#
#  If empty then choose the default presented by $temp
#
if [ "$bindir" = "" ]; then
	bindir=$temp
fi

#
#  If the default is the first time installed then (which is defined in the
#  Site.def as TOPDIR/bin) then change it to our current $TOPDIR/bin. Or if
#  they user wants BOOTSTRAP/bin then change it to $TOPDIR/bootstrap/bin
#
if [ "$bindir" = "TOPDIR/bin" ]; then
	bindir=$TOPDIR/bin
elif [ "$bindir" = "BOOTSTRAP/bin" ]; then
	bindir=$TOPDIR/bin
fi

if [ ! -d $bindir ] ; then
        mkdir $bindir ;
        if [ $? -ne 0 ] ; then
                echo ""
                echo "installit: ?Can't create $bindir"
                cleanup ;
        fi
        echo ""
        echo "installit: Created $bindir"
        sleep 2;
fi

echo ""
echo "Changing the '#define BinDir to #define BinDir $bindir'"
echo ""
cmd='{ if( $1 == "#define" ) { if ($2 == "BinDir") { if ($3 != "") printf("%s %s '$bindir'\n", $1, $2) } else print $0 } else { print $0 } }'

$awk " $cmd " $SITE_FILE > $SITE_FILE.new
$mv $SITE_FILE.new $SITE_FILE

# # ========================================================================
# #
# # Get and Set the directory for the Khoros libraries
# #
# # ========================================================================

temp=`$awk '$1=="#define" && $2=="KLibDir" { print $3 }' $SITE_FILE`
echo ""
echo "			Directory for Khoros libraries"
echo ""
echo "Enter the directory where you want Khoros libraries to be installed."
echo "Press RETURN to use the default."
echo ""
if [ "$temp" = "TOPDIR/lib" ]; then
        echon  "Lib directory [$TOPDIR/lib]: "
else
        echon  "Lib directory [$temp]: "
fi
read libdir

#
#  If empty then choose the default presented by $temp
#
if [ "$libdir" = "" ]; then
	libdir=$temp
fi

#
#  If the default is the first time installed then (which is defined in the
#  Site.def as TOPDIR/lib) then change it to our current $TOPDIR/lib. Or if
#  they user wants BOOTSTRAP/lib then change it to $TOPDIR/bootstrap/lib
#
if [ "$libdir" = "TOPDIR/lib" ]; then
	libdir=$TOPDIR/lib
elif [ "$libdir" = "BOOTSTRAP/lib" ]; then
	libdir=$TOPDIR/lib
fi

if [ ! -d $libdir ] ; then
        mkdir $libdir ;
        if [ $? -ne 0 ] ; then
                echo ""
                echo "installit: ?Can't create directory $libdir"
                cleanup ;
        fi
        echo ""
        echo "installit: Created directory $libdir"
        sleep 2;
fi

echo ""
echo "Changing the '#define KLibDir' to '#define KLibDir $libdir'"
echo ""

cmd='{ if( $1 == "#define" ) { if ($2 == "KLibDir") { if ($3 != "") printf("%s %s '$libdir'\n", $1, $2) } else print $0 } else { print $0 } }'

$awk " $cmd " $SITE_FILE > $SITE_FILE.new
$mv $SITE_FILE.new $SITE_FILE

# # ========================================================================
# #
# # Edit the configuration files
# #
# # ========================================================================
newtopic
echo "                        Architecture Configuration File"
echo ""
if [ $CP_SITE ]; then
	echo ""
	echo "                $SITE_FILE"
	echo ""
	echo "      A template architecture configuration file has been installed"
	echo ""
	echo "      You will need to edit this architecture configuration file"
	echo "      and set the imake symbols to the correct setting for your"
	echo "      architecture"
else
	echo ""
	echo "                $SITE_FILE"
	echo ""
	echo "      A architecture configuration file already exists"
	echo "      If you have not already checked this file for"
	echo "      correctness, you might want to look it over"
fi

echo ""
echo ""
YesNoPrompt "Do you wish to edit the architecture configuration file?"
if [ "$?" -eq "0" ]; then
	EDITOR=${EDITOR:-vi}
	$EDITOR $SITE_FILE
fi


newtopic
echo "                        Compiler Configuration File"
echo ""
if [ ! -f $CONFIG_FILE ]; then
	$cp $DIST_CONFIG/$defarch.cf $CONFIG_FILE
	echo ""
	echo "      A template platform configuration file has been installed"
	echo ""
	echo "                $CONFIG_FILE"
	echo ""
	echo "      You will need to edit this platform configuration file and"
	echo "      set the imake symbols to the correct setting for your"
	echo "      architecture"
else
	echo ""
	echo "                $CONFIG_FILE"
	echo ""
	echo "      A platform configuration file already exists"
	echo "      If you have not already checked this file for"
	echo "      correctness, you might want to look it over"
fi

echo ""
echo ""
YesNoPrompt "Do you wish to edit the platform configuration file?"
if [ "$?" -eq "0" ]; then
	EDITOR=${EDITOR:-vi}
	$EDITOR $CONFIG_FILE
fi


newtopic

# # ========================================================================
# #
# # determine bootstrap flags
# #
# # ========================================================================
cd $TOPDIR/bootstrap/objects

echo ""
echo ""
echo ""
if [ "$CONFIG_FLAGS" = "" ]; then
	echo "There are no default BOOTSTRAP flags for the machine choosen"
else
	echo "The default BOOTSTRAP flags for the machine choosen are"
	echo ""
	echo "	$CONFIG_FLAGS"
fi

echo ""
echo "(Enter 'q' to QUIT the installation)"
echo ""
echon "Do you want to modify these flags? (y/n) [n]: "
read bot

if [ "$bot" = "q" -o "$bot" = "Q" ]; then
	$mv Makefile.org Makefile
	echo ""
	echo ""
	echo "Exiting the Khoros installation script.  Bye..."
	echo ""
	exit 0
fi

if [ "$bot" = "y" -o "$bot" = "Y" ]; then
	echo ""
	echo ""
	echo "Please enter the new BOOTSTRAP flags"
	echon "BOOTSTRAP flags: "
	read CONFIG_FLAGS
fi

PATH=:./bin:$bindir:$PATH:/usr/local/bin:/usr/lang:/usr/bsd:/usr/ucb:/usr/bin:/bin:/usr/etc:/etc:/usr/local/gnu/bin:/usr/bin/X11
export PATH



# Set the top level src directory for the Khoros includes
# ------------------------------------------------------------------------

newtopic
echo ""
echo "Ok, we're ready to roll."
echo "The first stage of compilation is the 'bootstrap' programs:"
echo "		kimake"
echo "		kgenmake"
echo ""
ConfirmContinue

bootstarp=1
if [ -x $bindir/kimake -a -x $bindir/kgenmake ]; then
	echo ""
	echo "It appears that the bootstrap programs are compiled and installed"
	echo ""
	YesNoPrompt "Do you wish to rebuild these programs?" "n"
	if [ "$?" -eq "0" ]; then
		bootstarp=1
		[ -f $bindir/kimake ] && $rm $bindir/kimake
		[ -f $bindir/kgenmake ] && $rm $bindir/kgenmake
	else
		bootstarp=0
	fi
fi

if [ "$bootstarp" = 1 ]; then
	echo ""
	echo "Ok, let's try and build the bootstrap programs."
	echo "If the bootstrap build fails, then you must determine what"
	echo "happened and run installit again:"
	echo ""
	make CC=$ccomp BOOTSTRAPCFLAGS="$CONFIG_FLAGS" bootstrap
	if [ -x $bindir/kimake -a -x $bindir/kgenmake ]; then
		echo ""
		echo "The bootstrap programs seemed to build and"
		echo "install correctly, so lets go try to build Khoros"
		echo ""
	else
		echo ""
		echo "The bootstrap programs did not build correctly,"
		echo "please check the platform configuration file, or"
		echo "consult the installation guide and re-run installit"
		echo ""
		exit 0
	fi
fi

echo ""
echo ""
echo "Last chance to chicken out before compiling Khoros..."
ConfirmContinue

# # ========================================================================
# #
# # compile Khoros!
# #
# # ========================================================================

echo " 	The compile will run in the backgroup and take anywhere from 1 hour"
echo "	to 2 hours to build."
echo ""
echo "  The compile status for Khoros will be logged to the file"
echo "  '$TOPDIR/bootstrap/objects/make.World'."
echo ""
echo "  You can use the commands"
echo "		% cd $TOPDIR/bootstrap/objects"
echo " 		% tail -f make.World"
echo " 	to watch the compile."

cd $TOPDIR/bootstrap/objects
nohup nice make -k World > make.World 2>&1 &
exit 0
