/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            File descriptor passing utilities...
   >>>>
   >>>>  Private:
   >>>>             none
   >>>>   Public:
   >>>>             ksend_fildes()
   >>>>             krecv_fildes()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include <machine/kmachine.h>
#if KOPSYS_LOCAL == KOPSYS_SOLARIS || KOPSYS_LOCAL == KOPSYS_UNICOS
#undef _POSIX_SOURCE
#endif

#include "internals.h"

#if KOPSYS_LOCAL != KOPSYS_UNICOS && KOPSYS_LOCAL != KOPSYS_LINUX && KOPSYS_LOCAL != KOPSYS_DECSTATION && KOPSYS_LOCAL != KOPSYS_HPUX &&  KOPSYS_LOCAL != KOPSYS_FREEBSD && KOPSYS_LOCAL != KOPSYS_BSDI && KOPSYS_LOCAL != KOPSYS_ULTRIX

#if KOPSYS_LOCAL == KOPSYS_SOLARIS && KSTDC_DEF
#define ushort unsigned short
#define ulong  unsigned long
#define uint   unsigned int
#define uchar  unsigned char

#define u_short ushort
#define u_int   uint
#define u_long  ulong
#define u_char  uchar
#endif

#include <sys/types.h>
#include <stropts.h>


/************************************************************
*
*  Routine Name: ksend_fildes - this routine sends a file descriptor
*
*       Purpose: This Routine is used for IPC type programs, usually
*		 client / server programs that wish to pass file
*		 descriptors.
*
*         Input: ifile - the input transport to which we make the request
*		 ofile - the output transport to which we make the request
*                message - message to send to the recieving process
*		 fildes - file descriptor to send
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*    Written By: Mark Young
*          Date: Jan 18, 1994
*   Declaration: int ksend_fildes(
*                !   kfile *ifile,
*                !   kfile *ofile,
*                !   char  *message,
*                !   int   fildes)
*************************************************************/
/*ARGSUSED*/
int ksend_fildes(
   kfile *ifile,
   kfile *ofile,
   char  *message,
   int   fildes)
{
	int ifid, ofid;

	kgetdescriptors(ofile, &ifid, &ofid);
	if (message)
	{
	   kprintf(message);
	   write(ofid, message, kstrlen(message));
	}

	if (ioctl(ofid, I_SENDFD, fildes) < 0)
	   return(FALSE);

	return(TRUE);
}

/************************************************************
*
*  Routine Name: krecv_fildes - this routine recieves a file descriptor
*       Purpose: This Routine is used for IPC type programs, usually
*		 client / server programs that wish to pass file
*		 descriptors.
*         Input: ifile - the input transport to which we make the request
*                ofile - the output transport to which we make the request
*        Output: message - message to recieves to the recieving process
*                fildes - get the UNIX file descriptor
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*    Written By: Mark Young
*          Date: Jan 18, 1994
*************************************************************/

int krecv_fildes(
   kfile *ifile,
   kfile *ofile,
   char  *message,
   int   *fildes)
{
	int ifid, ofid;
	struct strrecvfd recvfd;

	kflock(kfileno(ifile), KLOCK_EX);
	kgetdescriptors(ofile, &ifid, &ofid);
	if (message)
	{
	   kprintf(message);
	   write(ofid, message, kstrlen(message));
	}

	kgetdescriptors(ifile, &ifid, &ofid);
	if (ioctl(ifid, I_RECVFD, &recvfd) < 0)
	{
	   kflock(kfileno(ifile), KLOCK_UN);
	   kprintf("\nerror receiving file descriptor\n");
	   return(FALSE);
	}
	*fildes = recvfd.fd;
	kflock(kfileno(ifile), KLOCK_UN);
	return(TRUE);
}
#else

int ksend_fildes(
   kfile *ifile,
   kfile *ofile,
   char  *message,
   int   fildes)
{
	return(FALSE);
}

int krecv_fildes(
   kfile *ifile,
   kfile *ofile,
   char  *message,
   int   *fildes)
{
	return(FALSE);
}
#endif
