/*
 * Khoros: $Id$
 */
 
#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif
 
/*
 * $Log$
 */
 
/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */
 
 
/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>         General Errors for kutils
   >>>> 
   >>>>  Private: 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"

 
int KMEMORY_ALLOCATION,		/* Memory Allocation Error    		   */
    KNULL_PARAMETER,		/* Illegal NULL Paramete      		   */
    KFILE_LIST,			/* Illegal File List          		   */
    KMISSING_INPUT,		/* Missing Input	      		   */
    KINVALID_DIR,		/* Invalid Directory	      		   */
    KINVALID_FILE,		/* Invalid File		      		   */
    KINVALID_FILE_DIR,		/* Invalid File or Directory  		   */
    KINVALID_INPUT,		/* Invalid Input	      		   */
    KINVALID_ALIAS,		/* Invalid Alias	      		   */
    KINVALID_PARAMETER,		/* Invalid Parameter	      		   */
    KINVALID_UISFILE,		/* Invalid UIS File	      		   */
    KINVALID_USER,		/* Invalid User		      		   */
    KINVALID_DATATYPE,		/* Invalid Data Type	      		   */
    KCANT_OPEN_INFILE,		/* Unable to Open Input File  		   */
    KCANT_OPEN_OUTFILE,		/* Unable to Open Output File 		   */
    KCANT_EXPAND_PATH,		/* Unable to Expand Path      		   */
    KINTERNAL,			/* Internal Error	      		   */
    KCALL,			/* Invalid Call to Routine    		   */
    KPARAMETERS,		/* Invalid Number of Parameters to Routine */
    KWIDGET_CREATION,		/* Widget Creation Error		   */
    KWIDGET_QUERY,		/* Unsuccessful Query of Widget		   */
    KGUI_CREATION,		/* GUI Creation Error			   */
    KUIS_SYNTAX,		/* UIS Syntax Error			   */
    KUIS_LOGIC,			/* UIS Logic Error			   */
    KNOENVIRONMENT_VAR,		/* Environment Variable Not Defined	   */
    KTOOLBOX_NOEXIST,		/* Toolbox Entry is Non-Existent	   */
    KTOOLBOX_CANTINIT,		/* Cannot initialize toolbox list	   */
    KNUMERIC,			/* Numeric Error			   */
    KLIMITATION,		/* Limitation				   */
    KDBM_EMPTY_DATABASE,	/* Empty Database encountered		   */
    KDBM_BLOCK_SIZE_ERROR,	/* Block Size Error in Database 	   */
    KDBM_CANT_BE_READER,	/* Reading Database Not Allowed 	   */
    KDBM_CANT_BE_WRITER,	/* Writing Database Not Allowed 	   */
    KDBM_FILE_WRITE_ERROR,	/* Failed To Write to Database  	   */
    KDBM_FILE_READ_ERROR,	/* Failed To Read from Database  	   */
    KDBM_FILE_SEEK_ERROR,	/* Failed To Seek in Database   	   */
    KDBM_BAD_MAGIC_NUMBER,	/* Bad Magic Number Found in Database  	   */
    KDBM_ITEM_NOT_FOUND,	/* Item Not Found in Database		   */
    KDBM_READER_CANT_STORE,	/* Reader Not Allowed To Store in Database */
    KDBM_ILLEGAL_DATA,		/* Illegal Data Found in Database	   */
    KDBM_CANNOT_REPLACE,	/* Cannot Replace Entry in Database	   */
    KDBM_READER_CANT_DELETE,	/* Reader Not Allowed To Delete from Database */
    KNO_KEY,			/* Key not found			   */
    KNO_BEGIN_KEY,		/* Begin key not found			   */
    KNO_END_KEY,		/* End key not found			   */
    KDATA_ERROR,		/* Data error during parse		   */
    KPART_KEY,			/* Parser out of data matching the key	   */
    KPART_BEGIN_KEY,		/* Parser out of data matching the begin key*/
    KPART_END_KEY,		/* Parser out of data matching the end key */
    KNULL_KEY,			/* Key is NULL			   	   */
    KNULL_BEGIN_KEY,		/* Begin key is NULL			   */
    KNULL_END_KEY,		/* End key is NULL			   */
    KSYNTAX_KEY,		/* Key has a syntax error		   */
    KSYNTAX_BEGIN_KEY,		/* Begin key has a syntax error		   */
    KSYNTAX_END_KEY;		/* End key has a syntax error		   */


kerrlist kutils_errors[] =
{
  { &KMEMORY_ALLOCATION, "Memory Allocation Error" },
  { &KNULL_PARAMETER,    "Illegal NULL Parameter" },
  { &KFILE_LIST,         "Illegal File List" },
  { &KMISSING_INPUT,     "Missing Input" },
  { &KINVALID_DIR,       "Invalid Directory" },
  { &KINVALID_FILE,      "Invalid File" },
  { &KINVALID_FILE_DIR,  "Invalid File or Directory" },
  { &KINVALID_INPUT,     "Invalid Input" },
  { &KINVALID_ALIAS,     "Invalid Alias" },
  { &KINVALID_PARAMETER, "Invalid Parameter" },
  { &KINVALID_UISFILE,   "Invalid UIS File" },
  { &KINVALID_USER,      "Invalid User" },
  { &KINVALID_DATATYPE,  "Invalid Data Type" },
  { &KCANT_OPEN_INFILE,  "Unable to Open Input File" },
  { &KCANT_OPEN_OUTFILE, "Unable to Open Output File" },
  { &KCANT_EXPAND_PATH,  "Unable to Expand Path" },
  { &KINTERNAL,          "Internal Error" },
  { &KCALL,              "Invalid Call to Routine" },
  { &KPARAMETERS,        "Invalid Number of Parameters to Routine" },
  { &KWIDGET_CREATION,   "Widget Creation Error" },
  { &KWIDGET_QUERY,      "Unsuccessful Query of Widget" },
  { &KGUI_CREATION,      "GUI Creation Error" },
  { &KUIS_SYNTAX,        "UIS Syntax Error" },
  { &KUIS_LOGIC,         "UIS Logic Error" },
  { &KNOENVIRONMENT_VAR, "Environment Variable Not Defined" },
  { &KTOOLBOX_NOEXIST,   "Toolbox Entry is Non-Existent" },
  { &KTOOLBOX_CANTINIT,  "Cannot initialize toolbox list" },
  { &KNUMERIC,           "Numeric Error" },
  { &KLIMITATION,        "Limitation" },
  { &KDBM_EMPTY_DATABASE,    "Empty Database encountered" },
  { &KDBM_BLOCK_SIZE_ERROR,  "Block Size Error" },
  { &KDBM_BLOCK_SIZE_ERROR,  "Block Size Error in Database" },
  { &KDBM_CANT_BE_READER,    "Reading Database Not Allowed" },
  { &KDBM_CANT_BE_WRITER,    "Writing Database Not Allowed" },
  { &KDBM_FILE_WRITE_ERROR,  "Failed To Write to Database" },
  { &KDBM_FILE_READ_ERROR,   "Failed To Read from Database" },
  { &KDBM_FILE_READ_ERROR,   "Failed To Seek in Database" },
  { &KDBM_BAD_MAGIC_NUMBER,  "Bad Magic Number Found in Database" },
  { &KDBM_ITEM_NOT_FOUND,    "Item Not Found in Database" },
  { &KDBM_READER_CANT_STORE, "Reader Not Allowed To Store in Database" },
  { &KDBM_ILLEGAL_DATA,	     "Illegal Data Found in Database" },
  { &KDBM_CANNOT_REPLACE,    "Cannot Replace Entry in Database" },
  { &KDBM_READER_CANT_DELETE,"Reader Not Allowed To Delete from Database" },
  { &KNO_KEY,            "Key not found" },
  { &KNO_BEGIN_KEY,      "Begin key not found" },
  { &KNO_END_KEY,        "End key not found" },
  { &KDATA_ERROR,        "Data error during parse" },
  { &KPART_KEY,          "Parser ran out of data while matching the key" },
  { &KPART_BEGIN_KEY,    "Parser ran out of data while matching the begin key"},
  { &KPART_END_KEY,      "Parser ran out of data while matching the end key" },
  { &KNULL_KEY,          "Key is NULL" },
  { &KNULL_BEGIN_KEY,    "Begin key is NULL" },
  { &KNULL_END_KEY,      "End key is NULL" },
  { &KSYNTAX_KEY,        "Key has a syntax error" },
  { &KSYNTAX_BEGIN_KEY,  "Begin key has a syntax error" },
  { &KSYNTAX_END_KEY,    "End key has a syntax error" },
};

int kutils_numerrors = knumber(kutils_errors);


/*-----------------------------------------------------------
|
|  Routine Name: lvadd - library routine for vadd
|
|       Purpose: This should be a complete description that anyone
|                could understand;  it should have acceptable grammar
|                and correct spelling.
|
|         Input: argument1 - explanation
|                argument2 - explanation
|                argument3 - explanation
|
|        Output: argument4 - explanation
|                argument5 - explanation
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By:
|          Date: 
| Modifications:
|
------------------------------------------------------------*/

void kutils_init_errors()
{
	kerrno_init_errors(kutils_errors, kutils_numerrors);
}
