/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>         Remote Transport Routines
   >>>>
   >>>>  Static:
   >>>>			remote_connect
   >>>>  Private:
   >>>>			remote_tempnam
   >>>>			remote_open
   >>>>			remote_close
   >>>>			remote_read
   >>>>			remote_write
   >>>>			remote_access
   >>>>			remote_unlink
   >>>>			remote_lock
   >>>>			remote_descriptors
   >>>>
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"	


#if !defined(KREMOTE_DEF)
#define KREMOTE_DEF 1
#endif

#if !defined(KREMOTE_DEF)
TransportInformation remote_transport[] = {NULL};
#else

static int remote_tempnam     PROTO((char *, char *, char *));
static int remote_open	      PROTO((char *, int, int, kfile *));
static int remote_close	      PROTO((kfile *));
static int remote_read	      PROTO((kfile *, char *, int));
static int remote_write	      PROTO((kfile *, char *, int));
static int remote_access      PROTO((char *, char *, int));
static int remote_unlink      PROTO((char *, char *));
static int remote_lock	      PROTO((kfile *, int));
static int remote_descriptors PROTO((kfile *, int *, int *));

TransportInformation remote_transport[] =
{
    {
	"Remote Transport",
	"@",
	FALSE,
	remote_tempnam,
	remote_open,
	remote_close,
	remote_read,
	remote_write,
	NULL,
	remote_access,
	remote_unlink,
	remote_lock,
	remote_descriptors,
    }
};

/*
 *  Internal resource structures for "standard file" transport
 */
typedef struct
{
	char  *path;
	char  *machine;
	int   connection;
} ResourceStruct;

static kfile *ifile = NULL, *ofile = NULL;


/*-----------------------------------------------------------
|
|  Routine Name: remote_connect - gets the local transport in which
|				  to talk to the local phantomd process
|
|       Purpose: 
|         Input: 
|        Output:
|       Returns: return the local phantomd transport
|
|    Written By: Mark Young
|          Date: Oct 10, 1993
| Modifications:
|
------------------------------------------------------------*/

static int remote_connect(
   char *filename,
   char *machine,
   char *path,
   int  *connection)
{
	kdbm   *dbm;
	kdatum key, data;
	char   hostname[KLENGTH], itransport[KLENGTH], otransport[KLENGTH];


	if (ifile && ofile)
	{
	   if (path)    ktransport_token(filename, path);
	   if (machine) ktransport_location(filename, machine);
	   if (connection && !krecv_fildes(ifile, ofile, machine, connection))
	   return(FALSE);
	   return(TRUE);
	}
/*
	if ((dbm = kdbm_open("~/.phantomd", KOPEN_RDONLY, 0600)) != NULL)
	{
	   kgethostname(NULL, hostname, KLENGTH);
	   key.dptr  = hostname;
	   key.dsize = kstrlen(hostname) + 1;
	   data = kdbm_fetch(dbm, key);
	}
 */

	if (!dbm || !data.dptr)
	{
	   static int initialized = FALSE;
	   if (!initialized)
	   {
	      initialized = TRUE;
	      ksystem("phantomd -daemon 1");
	      return(remote_connect(filename, machine, path, connection));
	   }
	   errno = ESRCH;
	   return(FALSE);
	}

	ifile = ofile = NULL;
	if (ksscanf(data.dptr,"%s %s", itransport, otransport) == 2)
	{
	   ifile = kfopen(itransport, "r+");
	   ofile = kfopen(otransport, "r+");
	}
	if (path)    ktransport_token(filename, path);
	if (machine) ktransport_location(filename, machine);

	if (connection && !krecv_fildes(ifile, ofile, machine, connection))
	   return(FALSE);

	return(ifile && ofile);
}

/*-----------------------------------------------------------
|
|  Routine Name: remote_sendmsg - sends a command to the
|			          phantomd process
|
|       Purpose: 
|         Input: 
|        Output:
|       Returns: return whether we were able send the message or not
|
|    Written By: Mark Young
|          Date: Oct 10, 1993
| Modifications:
|
------------------------------------------------------------*/

static int remote_sendmsg(
   int  connection, 
   char *temp)
{
	write(connection, temp, kstrlen(temp));
	close(connection);
	kprintf(temp);
	return(TRUE);
}

/*-------------------------------------------------------------
|  
|  Routine Name: remote_tempnam
|  
|       Purpose: This function initializes a tempnam for a "remote"
|	         type transport.  Given a request with a filename of
|	         the following syntax:
|  
|		  	"filename"
|		  	"/path/filename"
|		  	"./path/filename"
|		  	"file=XXXXXXXXXX"
|		  	     ...etc....
|
|         Input:  identifier - the transport identifier
|		  template   - the filename template to be modeled
|        Output:  temp       - the newly created transport name
|		  returns -1 or 0 depending whether we
|		  sucessfully created the template
|   Called From:  internal routine called from ktempnam()
|    Written By:  Mark Young
|  
-------------------------------------------------------------*/
/*ARGSUSED*/
static int remote_tempnam(
   char *identifier,
   char *template,
   char *temp)
{
	int   status = 0, connection;
	char  result[KLENGTH], machine[KLENGTH], path[KLENGTH];


	if (!remote_connect(template, machine, path, &connection))
	   return(FALSE);

	/* tempnam: machine template */
	ksprintf(result, "tempnam: '%s' '%s'\n", machine, path);
	remote_sendmsg(connection, result);
	return(status);
}

/*-------------------------------------------------------------
|  
|  Routine Name: remote_open
|  
|       Purpose: This function opens a "remote" connection.  It is the
|	         internal driver to open a file, which is called by
|	         the user when they call kopen().  kopen() calls when
|	         it gets an open request with a filename of the following
|	         syntax:
|  
|		  	"filename"
|		  	"/path/filename"
|		  	"./path/filename"
|		  	"file=XXXXXXXXXX"
|		  	     ...etc....
|         Input: 
|        Output:  returns 0 or -1 if an error occurs
|   Called From:  internal routine called from kopen()
|    Written By:  Mark Young
|  
-------------------------------------------------------------*/
/*ARGSUSED*/
static int remote_open(
   char  *name,
   int   flags,
   int   mode,
   kfile *file)
{
	int   status = 0, connection;
	char  machine[KLENGTH], result[KLENGTH], path[KLENGTH];

	if (!remote_connect(file->path, machine, path, &connection))
	   return(FALSE);

	/* open: machine template */
	ksprintf(result, "open: '%s' '%s'\n", machine, path);
	remote_sendmsg(connection, result);
	return(status);
}

/*-------------------------------------------------------------
|  
|  Routine Name: remote_close
|  
|       Purpose: This function closes a "remote"  It is the internal driver
|	         to close a data file, which is called by the user
|	         when they call kclose().  kclose() calls the "remote" internal
|	         drivers by the nature of the transport, which is dictated
|	         by the initial kopen().
|  
|         Input:  file - the kfile structure.
|        Output:  returns whether we were able to close the file
|   Called From:  internal routine called from kclose()
|    Written By:  Mark Young
|  
-------------------------------------------------------------*/
/*ARGSUSED*/
static int remote_close(
   kfile *file)
{
	int   status = 0, connection;
	char  machine[KLENGTH], result[KLENGTH], path[KLENGTH];


	if (!remote_connect(file->path, machine, path, &connection))
	   return(FALSE);

	/* close: machine template */
	ksprintf(result, "close: '%s' '%s'\n", machine, path);
	remote_sendmsg(connection, result);
	return(status);
}

/*-------------------------------------------------------------
|  
|  Routine Name: remote_read
|  
|       Purpose: This function reads a "remote"  It is the internal driver
|	         to read data from a file, which is called by the user
|	         when they call kread().  kread() calls the "remote" internal
|	         drivers by the nature of the transport, which is dictated
|	         by the kopen().
|  
|         Input:  file   - the kfile structure.
|		  ptr  - the pointer to store the data into.
|		  nbytes - the number of bytes to read.
|        Output:  returns the number of bytes read from the file
|   Called From:  internal routine called from kread()
|    Written By:  Mark Young
|  
-------------------------------------------------------------*/
/*ARGSUSED*/
static int remote_read(
   kfile *file,
   char  *ptr,
   int   nbytes)
{
	int   status = 0, connection;
	char  machine[KLENGTH], result[KLENGTH], path[KLENGTH];


	if (!remote_connect(file->path, machine, path, &connection))
	   return(FALSE);

	/* read: machine template */
	ksprintf(result,"read: '%s' '%s' '%d'\n",machine, path, nbytes);
	remote_sendmsg(connection, result);
	return(status);
}

/*-------------------------------------------------------------
|  
|  Routine Name: remote_write
|  
|       Purpose: This function writes to a "remote".  It is the internal driver
|	         to write data from the supplied data array to a file, which
|	         is called by the user when they call kwrite().  kwrite() calls
|	         the "remote" internal drivers by the nature of the transport,
|	         which is dictated by the kopen().
|  
|         Input:  file   - the kfile structure.
|		  ptr    - the pointer to write the data from.
|		  nbytes - the number of bytes to write.
|        Output:  returns the number of bytes written to the kfile
|   Called From:  internal routine called from kwrite()
|    Written By:  Mark Young
|  
-------------------------------------------------------------*/
/*ARGSUSED*/
static int remote_write(
   kfile *file,
   char  *ptr,
   int   nbytes)
{
	int   status = 0, connection;
	char  machine[KLENGTH], result[KLENGTH], path[KLENGTH];


	if (!remote_connect(file->path, machine, path, &connection))
	   return(FALSE);

	/* write: machine template */
	ksprintf(result,"write: '%s' '%s' '%d'\n", machine, path, nbytes);
	remote_sendmsg(connection, result);
	return(status);
}

/*-------------------------------------------------------------
|  
|  Routine Name: remote_access
|  
|       Purpose: This function is used to do see if a file is accessable.
|	         This is called when the user calls kaccess().  kaccess()
|	         calls the "remote" internal drivers by the nature of the
|	         transport, which is dictated by the ktransport_identifier().
|  
|         Input:  name     - the initial path.
|		  filename - the filename that they wish to access
|		  mode     - the access mode information
|        Output:  returns the result
|   Called From:  internal routine called from kaccess()
|    Written By:  Mark Young
|  
-------------------------------------------------------------*/
/*ARGSUSED*/
static int remote_access(
   char *name,
   char *filename,
   int  mode)
{
	int   status = 0, connection;
	char  machine[KLENGTH], result[KLENGTH], path[KLENGTH];


	if (!remote_connect(name, machine, path, &connection))
	   return(FALSE);

	/* tempnam: machine template */
	ksprintf(result,"access: '%s' '%s' '%d'\n", machine, path, mode);
	remote_sendmsg(connection, result);
	return(status);
}


/*-------------------------------------------------------------
|  
|  Routine Name: remote_unlink
|  
|       Purpose: This function initializes a tempnam for a "remote"
|	         type transport.  Given a request with a filename of
|	         the following syntax:
|  
|		  	"filename"
|		  	"/path/filename"
|		  	"./path/filename"
|		  	"file=XXXXXXXXXX"
|		  	     ...etc....
|  
|         Input: 
|        Output:  returns 0 or -1 depending whether we
|		  sucessfully created the template
|   Called From:  internal routine called from kunlink()
|    Written By:  Mark Young
|  
-------------------------------------------------------------*/
/*ARGSUSED*/
static int remote_unlink(
   char *identifier,
   char *filename)
{
	int   status = 0, connection;
	char  machine[KLENGTH], result[KLENGTH], path[KLENGTH];


	if (!remote_connect(filename, machine, path, &connection))
	   return(FALSE);

	/* unlink: machine template */
	ksprintf(result,"unlink: '%s' '%s' '%d'\n", machine, path);
	remote_sendmsg(connection, result);
	return(status);
}


/*-------------------------------------------------------------
|  
|  Routine Name: remote_lock
|  
|       Purpose: This function locks a "remote" transport.  Given
|	         a request with a filename of the following syntax:
|  
|		  	"filename@machine"
|		  	"/path/filename@machine"
|		  	"./path/filename@machine"
|		  	"file=XXXXXXXXXX@machine"
|		  	     ...etc....
|         Input: 
|        Output:  returns 0 or -1 depending whether we
|		  sucessfully created the template
|   Called From:  internal routine called from kflock()
|    Written By:  Mark Young
|  
-------------------------------------------------------------*/
/*ARGSUSED*/
static int remote_lock(
   kfile *file,
   int   operation)
{
	int   status = 0, connection;
	char  machine[KLENGTH], result[KLENGTH], path[KLENGTH];


	if (!remote_connect(file->path, machine, path, &connection))
	   return(FALSE);

	/* tempnam: machine template */
	ksprintf(result,"lock: '%s' '%s' '%d'\n",machine, path, operation);
	remote_sendmsg(connection, result);
	return(status);
}


/*-------------------------------------------------------------
|  
|  Routine Name: remote_descriptors
|  
|       Purpose: This function shouldn't exist, but there is occasion
|	         when the user wants to know the actual file descriptor
|	         associated with the remote descriptor.
|  
|         Input: file structure
|        Output:  inum - the input file descriptor
|   Called From:  internal routine called from kdescriptor()
|    Written By:  Mark Young
|  
-------------------------------------------------------------*/
/*ARGSUSED*/
static int remote_descriptors(
   kfile *file,
   int   *inum,
   int   *onum)
{
	return(0);
}

#endif  /* KREMOTE_DEF */
/* don't add after the endif */
