/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>              Data Manipulation Utilities
   >>>>
   >>>>  Private:
   >>>>   Static:
   >>>>   Public:
   >>>>             kdata_fill()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"

/*************************************************************
*
*  Routine Name: kdata_fill - fill memory with value by data type
*
*       Purpose: This function is used to fill a region of 
*                memory with a specified value.  A datatype
*                is used to determine how to use interpret
*                the real and imaginary values specified.
*		 The data types are byte, unsigned byte, short,
*		 unsigned short, long, unsigned long, int, unsigned int,
*		 float, double, complex, and double complex.
*
*         Input: data      - point to the data to be filled
*		 num       - number of points to be filled
*		 datatype  - data type to fill with
*		 real      - real part of data to fill with
*		 imaginary - imaginary part of data to fill with
*
*        Output: 
*
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*    Written By: Jeremy Worley
*          Date: Jun 28, 1993 12:59
* Modifications:
*
*************************************************************/

int kdata_fill(
   kaddr  data,
   int    num,
   int    datatype,
   double real,
   double imaginary)
{
        int i;

        switch (datatype) {
           case KBIT:
                {
                  unsigned char *d = (unsigned char *)data, v;
                  unsigned long n = ((num + 7) >> 3);
                  v = (real <= 0.0) ? 0x0 : 0xff;
                  for (i = 0; i < n; i++)
                     *d++ = v;
                }
                return(TRUE);
           case KBYTE:
                {
                  signed char *d = (signed char *)data, v = (signed char)real;
                  for (i = 0; i < num; i++)
                     *d++ = v;
                }
                return(TRUE);
           case KUBYTE:
                {
                  unsigned char *d = (unsigned char *)data, 
                        v = (unsigned char)real;
                  for (i = 0; i < num; i++)
                     *d++ = v;
                }
                return(TRUE);
           case KSHORT:
                {
                  short *d = (short *)data, v = (short)real;
                  for (i = 0; i < num; i++)
                     *d++ = v;
                }
                return(TRUE);
           case KUSHORT:
                {
                  unsigned short *d = (unsigned short *)data, 
                        v = (unsigned short)real;
                  for (i = 0; i < num; i++)
                     *d++ = v;
                }
                return(TRUE);
           case KINT:
                {
                  int *d = (int *)data, v = (int)real;
                  for (i = 0; i < num; i++)
                     *d++ = v;
                }
                return(TRUE);
           case KUINT:
                {
                  unsigned int *d = (unsigned int *)data, 
                        v = (unsigned int)real;
                  for (i = 0; i < num; i++)
                     *d++ = v;
                }
                return(TRUE);
           case KLONG:
                {
                  long *d = (long *)data, v = (long)real;
                  for (i = 0; i < num; i++)
                     *d++ = v;
                }
                return(TRUE);
           case KULONG:
                {
                  unsigned long *d = (unsigned long *)data, 
                        v = (unsigned long)real;
                  for (i = 0; i < num; i++)
                     *d++ = v;
                }
                return(TRUE);
           case KFLOAT:
                {
                  float *d = (float *)data;
                  for (i = 0; i < num; i++)
                     *d++ = real;
                }
                return(TRUE);
           case KDOUBLE:
                {
                  double *d = (double *)data;
                  for (i = 0; i < num; i++)
                     *d++ = real;
                }
                return(TRUE);
           case KCOMPLEX:
                {
                  kcomplex *d = (kcomplex *)data, 
                        v = kccomp((float)real,(float)imaginary);
                  for (i = 0; i < num; i++)
                     *d++ = v;
                }
                return(TRUE);
           case KDCOMPLEX:
                {
                  kdcomplex *d = (kdcomplex *)data, 
                        v = kdccomp(real,imaginary);
                  for (i = 0; i < num; i++)
                     *d++ = v;
                }
                return(TRUE);
           default:
		errno = KINVALID_PARAMETER;
                kerror("kmath","kdata_fill",
                "An illegal datatype was suggested by ktype_cast_process.");
                return(FALSE);
        }
}
