
#define _do_cast(out, iptr, num_elem, i, datatype) \
      {                                            \
	 datatype *optr = (datatype *) out;        \
	 for (i = 0; i < num_elem; i++)            \
	    *optr++ = (datatype) *iptr++;          \
      }                                            

#define _do_complex_cast(out, iptr, num_elem, i, convert)         \
      {                                                           \
	 kcomplex *optr = (kcomplex *) out;                       \
	 switch (convert) {                                       \
	    case KREAL:                                           \
	    case KMAGNITUDE:                                      \
	       for (i = 0; i < num_elem; i++)                     \
	          *optr++ = kccomp((float) *iptr++, (float) 0.0); \
	       break;                                             \
	    case KIMAGINARY:                                      \
	       for (i = 0; i < num_elem; i++)                     \
	          *optr++ = kccomp((float) 0.0, (float)*iptr++);  \
	       break;                                             \
	    case KPHASE:                                          \
	       for (i = 0; i < num_elem; i++) {                   \
	          *optr++ = kccomp((float)kcos((double)*iptr),    \
			     (float)ksin((double)*iptr++));       \
	       }                                                  \
	       break;                                             \
	    default:                                              \
	       errno = KINVALID_PARAMETER;                        \
	       break;                                             \
         }                                                        \
      }

#define _do_dcomplex_cast(out, iptr, num_elem, i, convert)         \
      {                                                            \
	 kdcomplex *optr = (kdcomplex *) out;                      \
	 switch (convert) {                                        \
	    case KREAL:                                            \
	    case KMAGNITUDE:                                       \
	       for (i = 0; i < num_elem; i++)                      \
	          *optr++ = kdccomp((double)*iptr++, (double)0.0); \
	       break;                                              \
	    case KIMAGINARY:                                       \
	       for (i = 0; i < num_elem; i++)                      \
	          *optr++ = kdccomp((double)0.0, (double)*iptr++); \
	       break;                                              \
	    case KPHASE:                                           \
	       for (i = 0; i < num_elem; i++) {                    \
	          *optr++ = kdccomp(kcos((double)*iptr),           \
			            ksin((double)*iptr++));        \
	       }                                                   \
	       break;                                              \
	    default:                                               \
	       errno = KINVALID_PARAMETER;                         \
	       break;                                              \
         }                                                         \
      }

#define _do_bit_cast(out, iptr, num_elem, i)                           \
      {                                                                \
	 unsigned char *optr = (unsigned char *) out;                  \
	 for (i = 0; i < (num_elem >> 3) + ((num_elem % 8) != 0); i++) \
	    optr[i] = 0;                                               \
	 for (i = 0; i < num_elem; i++) {                              \
	    optr[(int) (i >> 3)] |=                                    \
	       (*iptr++ <= 0) ? 0x0 : (0x80 >> (i % 8));               \
	 }                                                             \
      }

#define _do_cast_from_complex(out, iptr, num_elem, i, convert, datatype) \
      {                                                                  \
	 datatype *optr = (datatype *) out;                              \
	 switch (convert) {                                              \
	    case KREAL:                                                  \
	       for (i = 0; i < num_elem; i++)                            \
	          *optr++ =                                              \
	              (datatype) kcreal(*iptr++);                        \
	       break;                                                    \
	    case KIMAGINARY:                                             \
	       for (i = 0; i < num_elem; i++)                            \
	          *optr++ =                                              \
	              (datatype) kcimag(*iptr++);                        \
	       break;                                                    \
	    case KMAGNITUDE:                                             \
	       for (i = 0; i < num_elem; i++)                            \
	          *optr++ =                                              \
	              (datatype) kcmag(*iptr++);                         \
	       break;                                                    \
	    case KMAGSQ:                                                 \
	       for (i = 0; i < num_elem; i++)                            \
	          *optr++ =                                              \
	              (datatype) kcmagsq(*iptr++);                       \
	       break;                                                    \
	    case KLOGMAGP1:                                              \
	       for (i = 0; i < num_elem; i++)                            \
	          *optr++ =                                              \
	              (datatype) kclogmagp1(*iptr++);                    \
	       break;                                                    \
	    case KLOGMAGSQP1:                                            \
	       for (i = 0; i < num_elem; i++)                            \
	          *optr++ =                                              \
	              (datatype) kclogmagsqp1(*iptr++);                  \
	       break;                                                    \
	    case KLOGMAGSQ:                                              \
	       for (i = 0; i < num_elem; i++)                            \
	          *optr++ =                                              \
	              (datatype) kclogmagsq(*iptr++);                    \
	       break;                                                    \
	    case KLOGMAG:                                                \
	       for (i = 0; i < num_elem; i++)                            \
	          *optr++ =                                              \
	              (datatype) kclogmag(*iptr++);                      \
	       break;                                                    \
	    case KPHASE:                                                 \
	       for (i = 0; i < num_elem; i++)                            \
	          *optr++ =                                              \
	              (datatype) kcang(*iptr++);                         \
	       break;                                                    \
	    default:                                                     \
	       errno = KINVALID_PARAMETER;                               \
	       return(FALSE);                                            \
	 }                                                               \
      }

#define _do_cast_from_dcomplex(out, iptr, num_elem, i, convert, datatype) \
      {                                                                   \
	 datatype *optr = (datatype *) out;                               \
	 switch (convert) {                                               \
	    case KREAL:                                                   \
	       for (i = 0; i < num_elem; i++)                             \
	          *optr++ =                                               \
	              (datatype) kdcreal(*iptr++);                        \
	       break;                                                     \
	    case KIMAGINARY:                                              \
	       for (i = 0; i < num_elem; i++)                             \
	          *optr++ =                                               \
	              (datatype) kdcimag(*iptr++);                        \
	       break;                                                     \
	    case KMAGNITUDE:                                              \
	       for (i = 0; i < num_elem; i++)                             \
	          *optr++ =                                               \
	              (datatype) kdcmag(*iptr++);                         \
	       break;                                                     \
	    case KMAGSQ:                                                  \
	       for (i = 0; i < num_elem; i++)                             \
	          *optr++ =                                               \
	              (datatype) kdcmagsq(*iptr++);                       \
	       break;                                                     \
	    case KLOGMAGP1:                                               \
	       for (i = 0; i < num_elem; i++)                             \
	          *optr++ =                                               \
	              (datatype) kdclogmagp1(*iptr++);                    \
	       break;                                                     \
	    case KLOGMAGSQP1:                                             \
	       for (i = 0; i < num_elem; i++)                             \
	          *optr++ =                                               \
	              (datatype) kdclogmagsqp1(*iptr++);                  \
	       break;                                                     \
	    case KLOGMAGSQ:                                               \
	       for (i = 0; i < num_elem; i++)                             \
	          *optr++ =                                               \
	              (datatype) kdclogmagsq(*iptr++);                    \
	       break;                                                     \
	    case KLOGMAG:                                                 \
	       for (i = 0; i < num_elem; i++)                             \
	          *optr++ =                                               \
	              (datatype) kdclogmag(*iptr++);                      \
	       break;                                                     \
	    case KPHASE:                                                  \
	       for (i = 0; i < num_elem; i++)                             \
	          *optr++ =                                               \
	              (datatype) kdcang(*iptr++);                         \
	       break;                                                     \
	    default:                                                      \
	       errno = KINVALID_PARAMETER;                                \
	       return(FALSE);                                             \
	 }                                                                \
      }

#define _do_type_cast(out, in, num_elem, i, odatatype, idatatype, convert) \
{                                                                          \
   register idatatype *iptr = (idatatype *) in;                            \
   switch (odatatype) {                                                    \
   case KBIT:                                                              \
      _do_bit_cast(out, iptr, num_elem, i)                                 \
      break;                                                               \
   case KBYTE:                                                             \
      _do_cast(out, iptr, num_elem, i, char)                               \
      break;                                                               \
   case KUBYTE:                                                            \
      _do_cast(out, iptr, num_elem, i, unsigned char)                      \
      break;                                                               \
   case KSHORT:                                                            \
      _do_cast(out, iptr, num_elem, i, short)                              \
      break;                                                               \
   case KUSHORT:                                                           \
      _do_cast(out, iptr, num_elem, i, unsigned short)                     \
      break;                                                               \
   case KLONG:                                                             \
      _do_cast(out, iptr, num_elem, i, long)                               \
      break;                                                               \
   case KULONG:                                                            \
      _do_cast(out, iptr, num_elem, i, unsigned long)                      \
      break;                                                               \
   case KINT:                                                              \
      _do_cast(out, iptr, num_elem, i, int)                                \
      break;                                                               \
   case KUINT:                                                             \
      _do_cast(out, iptr, num_elem, i, unsigned int)                       \
      break;                                                               \
   case KFLOAT:                                                            \
      _do_cast(out, iptr, num_elem, i, float)                              \
      break;                                                               \
   case KDOUBLE:                                                           \
      _do_cast(out, iptr, num_elem, i, double)                             \
      break;                                                               \
   case KCOMPLEX:                                                          \
      _do_complex_cast(out, iptr, num_elem, i, convert)                    \
      break;                                                               \
   case KDCOMPLEX:                                                         \
      _do_dcomplex_cast(out, iptr, num_elem, i, convert)                   \
      break;                                                               \
   default:                                                                \
      errno = KINVALID_DATATYPE;                                           \
      kerror("kmath", "kdata_cast()",                                      \
	 "The output data type is not recognized (%d).", odatatype);       \
      return (FALSE);                                                      \
   }                                                                       \
   return (TRUE);                                                          \
}
