/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>		       Deparsing  Routines                    <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>		kvf_deparse_startform_line()		      <<<<   
   >>>>		kvf_deparse_startmaster_line()		      <<<<   
   >>>>		kvf_deparse_startsubmenu_line()		      <<<<   
   >>>>		kvf_deparse_startsubform_line()		      <<<<   
   >>>>		kvf_deparse_subformbutton_line()	      <<<<   
   >>>>		kvf_deparse_master_action_line()	      <<<<   
   >>>>		kvf_deparse_startguide_line()		      <<<<   
   >>>>		kvf_deparse_startpane_line()		      <<<<   
   >>>>		kvf_deparse_guide_line()		      <<<<   
   >>>>		kvf_deparse_quit_line()			      <<<<   
   >>>>		kvf_deparse_subform_action_line()	      <<<<   
   >>>>		kvf_deparse_help_line()		      	      <<<<   
   >>>>		kvf_deparse_input_line()		      <<<<   
   >>>>		kvf_deparse_output_line()		      <<<<   
   >>>>		kvf_deparse_stdin_line()		      <<<<   
   >>>>		kvf_deparse_stdout_line()		      <<<<   
   >>>>		kvf_deparse_int_line()		      	      <<<<   
   >>>>		kvf_deparse_float_line()		      <<<<   
   >>>>		kvf_deparse_logic_line()		      <<<<   
   >>>>		kvf_deparse_flag_line()		              <<<<   
   >>>>		kvf_deparse_cycle_line()		      <<<<   
   >>>>		kvf_deparse_list_line()		              <<<<   
   >>>>		kvf_deparse_displaylist_line()	              <<<<   
   >>>>		kvf_deparse_string_line()		      <<<<   
   >>>>		kvf_deparse_stringlist_line()		      <<<<   
   >>>>		kvf_deparse_routine_line()	      	      <<<<   
   >>>>		kvf_deparse_toggle_line()		      <<<<   
   >>>>		kvf_deparse_blank_line()		      <<<<   
   >>>>		kvf_deparse_pane_action_line()		      <<<<   
   >>>>		kvf_deparse_includepane_line()		      <<<<   
   >>>>		kvf_deparse_includesubform_line()             <<<<   
   >>>>		kvf_deparse_mutexcl_line()		      <<<<   
   >>>>		kvf_deparse_mutincl_line()		      <<<<   
   >>>>		kvf_deparse_workspace_line()		      <<<<   
   >>>>		kvf_deparse_end_line()		      	      <<<<   
   >>>>		kvf_gen_deparse()		      	      <<<<   
   >>>>                                                       <<<<
   >>>>   Static:                                             <<<<
   >>>>		escape_ticmark()		      	      <<<<   
   >>>>   Public:                                             <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */


#include "internals.h"
#include "deparser.h"

static void escape_ticmark PROTO((char *));

/*-----------------------------------------------------------
|
|       Routine: kvf_deparse_startform_line
|       Purpose: Updates a StartForm line  (-F:  typeflag = KUIS_STARTFORM)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_startform_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH], tmp_title[KLENGTH], tmp_variable[KLENGTH];
	float  version = 4.3; 

	if (line_info->title == NULL) ksprintf(tmp_title, " ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	if (line_info->variable == NULL) ksprintf(tmp_variable, " ");
	else ksprintf(tmp_variable, "%s", line_info->variable);

	(void) ksprintf(new_line, startform_print,  version, 
		       line_info->activate, line_info->selected,
		       line_info->width, line_info->height, 
		       line_info->x,line_info->y, 
		       line_info->xpos, line_info->ypos, 
		       tmp_title, tmp_variable);

	kfree(*line); 
	*line = kstrdup(new_line);
}


/*-----------------------------------------------------------
|
|       Routine: kvf_deparse_startmaster_line
|       Purpose: Updates a StartMaster line  (-S:  typeflag = KUIS_STARTMASTER)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_startmaster_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH];

	(void) ksprintf(new_line, startmaster_print, 
		       line_info->activate, line_info->logical_val);

	kfree(*line); 
	*line = kstrdup(new_line);
}


/*-----------------------------------------------------------
|
|       Routine: kvf_deparse_startsubmenu_line
|       Purpose: Updates a StartSubmenu line  (-D:  typeflag = KUIS_STARTSUBMENU)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_startsubmenu_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH], tmp_title[KLENGTH], tmp_variable[KLENGTH];

	if (line_info->title == NULL) ksprintf(tmp_title, " ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	if (line_info->variable == NULL) ksprintf(tmp_variable, " ");
	else ksprintf(tmp_variable, "%s", line_info->variable);


	(void) ksprintf(new_line, startsubmenu_print, 
		       line_info->activate, line_info->selected,
		       line_info->width, line_info->height, 
		       line_info->x,line_info->y, 
		       tmp_title, tmp_variable);

	kfree(*line); 
	*line = kstrdup(new_line);
}


/*-----------------------------------------------------------
|
|       Routine: kvf_deparse_startsubform_line
|       Purpose: Updates a StartSubform line  (-M:  typeflag = KUIS_STARTSUBFORM)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_startsubform_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH], tmp_title[KLENGTH], tmp_variable[KLENGTH];

	if (line_info->title == NULL) ksprintf(tmp_title, " ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	if (line_info->variable == NULL) ksprintf(tmp_variable, " ");
	else ksprintf(tmp_variable, "%s", line_info->variable);

	(void) ksprintf(new_line, startsubform_print, 
		       line_info->activate, line_info->selected,
		       line_info->width, line_info->height, 
		       line_info->x,line_info->y, 
		       line_info->xpos, line_info->ypos, 
		       tmp_title, tmp_variable);

	kfree(*line); 
	*line = kstrdup(new_line);
}

/*-----------------------------------------------------------
|
|       Routine: kvf_deparse_startguide_line
|       Purpose: Updates a StartGuide line  (-G:  typeflag = KUIS_STARTGUIDE)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_startguide_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH], tmp_title[KLENGTH];

	if (line_info->title == NULL) ksprintf(tmp_title, " ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	(void) ksprintf(new_line, startguide_print, line_info->activate,
		       line_info->width, line_info->height, 
		       line_info->x,line_info->y, 
		       line_info->xpos, line_info->ypos, 
		       tmp_title);

	kfree(*line); 
	*line = kstrdup(new_line);
}


/*-----------------------------------------------------------
|
|       Routine: kvf_deparse_startpane_line
|       Purpose: Updates a StartPane line  (-P:  typeflag = KUIS_STARTPANE)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_startpane_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH], tmp_title[KLENGTH], tmp_variable[KLENGTH];

	if (line_info->title == NULL) ksprintf(tmp_title, " ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	if (line_info->variable == NULL) ksprintf(tmp_variable, " ");
	else ksprintf(tmp_variable, "%s", line_info->variable);

	(void) ksprintf(new_line, startpane_print, line_info->activate,
		       line_info->selected, line_info->width, 
		       line_info->height, line_info->x,line_info->y, 
		       line_info->xpos, line_info->ypos, 
		       tmp_title, tmp_variable);

	kfree(*line); 
	*line = kstrdup(new_line);
}


/*-----------------------------------------------------------
|
|       Routine: kvf_deparse_subformbutton_line
|       Purpose: Updates a SubformButton line  
|		 (-d:  typeflag = KUIS_SUBFORMBUTTON)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_subformbutton_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH]; 
	char tmp_title[KLENGTH], tmp_var[KLENGTH];

	if (line_info->title == NULL) ksprintf(tmp_title, " ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	if (line_info->variable == NULL) ksprintf(tmp_var, " ");
	else ksprintf(tmp_var, "%s", line_info->variable);

	(void) ksprintf(new_line, subformbutton_print, 
		       line_info->activate, line_info->selected, 
		       line_info->width, line_info->height, 
		       line_info->x,line_info->y, 
		       tmp_title, tmp_var);

	kfree(*line); 
	*line = kstrdup(new_line);
}

/*------------------------------------------------------------
|
|       Routine: kvf_deparse_master_action_line
|       Purpose: Updates MasterAction line (-n: typeflag = KUIS_MASTERACTION)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_master_action_line(
   Line_Info *line_info,
   char      **line)
{

	char new_line[KLENGTH], 
	     tmp_title[KLENGTH], tmp_desc[KLENGTH], tmp_var[KLENGTH];

	if (line_info->title == NULL) ksprintf(tmp_title, " ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	if (line_info->description == NULL) ksprintf(tmp_desc, " ");
        else ksprintf(tmp_desc, "%s", line_info->description);
	escape_ticmark(tmp_desc);

	if (line_info->variable == NULL) ksprintf(tmp_var, " ");
        else ksprintf(tmp_var, "%s", line_info->variable);

	(void) ksprintf(new_line, master_action_print, line_info->activate,
		       line_info->selected, line_info->width, 
		       line_info->height, line_info->x,line_info->y, 
		       tmp_title, tmp_desc, tmp_var);

	kfree(*line); 
	*line = kstrdup(new_line);
}

/*------------------------------------------------------------
|
|       Routine: kvf_deparse_guide_line
|       Purpose: Updates a GuideButton line  (-g:  typeflag = KUIS_GUIDEBUTTON)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_guide_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH], tmp_title[KLENGTH], tmp_variable[KLENGTH];

	if (line_info->title == NULL) ksprintf(tmp_title, " ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	if (line_info->variable == NULL) ksprintf(tmp_variable, " ");
	else ksprintf(tmp_variable, "%s", line_info->variable);

	(void) ksprintf(new_line, guidebutton_print, line_info->activate,
		       line_info->selected, line_info->width, 
		       line_info->height, line_info->x,line_info->y, 
		       tmp_title, tmp_variable);

	kfree(*line); 
	*line = kstrdup(new_line);
}


/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_quit_line
|       Purpose: Updates a Quit line  (-Q:  typeflag = KUIS_QUIT)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_quit_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH], tmp_title[KLENGTH];

	if (line_info->title == NULL) ksprintf(tmp_title, " ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

        (void) ksprintf(new_line, quitform_print, 
		       line_info->activate, line_info->selected,
		       line_info->width, line_info->height, 
		       line_info->x,line_info->y, tmp_title);

	kfree(*line); 
	*line = kstrdup(new_line);
}


/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_subform_action_line
|       Purpose: Updates SubformAction line (-m: typeflag = KUIS_SUBFORMACTION)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_subform_action_line(
   Line_Info *line_info,
   char      **line)
{

	char new_line[KLENGTH], tmp_title[KLENGTH], 
	     tmp_desc[KLENGTH], tmp_var[KLENGTH];

	if (line_info->title == NULL) ksprintf(tmp_title, " ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	if (line_info->description == NULL) ksprintf(tmp_desc, " ");
        else ksprintf(tmp_desc, "%s", line_info->description);
	escape_ticmark(tmp_desc);

	if (line_info->variable == NULL) ksprintf(tmp_var, " ");
        else ksprintf(tmp_var, "%s", line_info->variable);

	(void) ksprintf(new_line, subform_action_print, line_info->activate,
		       line_info->selected, line_info->width, 
		       line_info->height, line_info->x,line_info->y, 
		       tmp_title, tmp_desc, tmp_var);

	kfree(*line); 
	*line = kstrdup(new_line);
}


/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_help_line
|       Purpose: Updates a Help line (-H:  typeflag = KUIS_HELP)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_help_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH], tmp_title[KLENGTH],
	     tmp_desc[KLENGTH], tmp_file[KLENGTH], tmp_var[KLENGTH];

	if (line_info->title == NULL) ksprintf(tmp_title, " ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	if (line_info->description == NULL) ksprintf(tmp_desc, " ");
	else ksprintf(tmp_desc, "%s", line_info->description);
	escape_ticmark(tmp_desc);

	if (line_info->help_file == NULL) ksprintf(tmp_file, " ");
	else ksprintf(tmp_file, "%s", line_info->help_file);

	if (line_info->variable == NULL) ksprintf(tmp_var, " ");
	else ksprintf(tmp_var, "%s", line_info->variable);


        (void) ksprintf(new_line, help_print, line_info->activate,
                       line_info->width, line_info->height, 
		       line_info->x,line_info->y,
		       tmp_title, tmp_desc, tmp_file, tmp_var);

	kfree(*line); 
	*line = kstrdup(new_line);
}


/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_input_line
|       Purpose: Updates an Input line (-I:  typeflag = KUIS_INPUTFILE)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_input_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH], tmp_title[KLENGTH],
	     tmp_desc[KLENGTH], tmp_var[KLENGTH], tmp_def[KLENGTH],
	     tmp_file[KLENGTH], tmp_literal[KLENGTH];

	if (line_info->title == NULL) ksprintf(tmp_title, " ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	if (line_info->description == NULL) ksprintf(tmp_desc," ");
	else ksprintf(tmp_desc, "%s", line_info->description);
	escape_ticmark(tmp_desc);

	if (line_info->variable == NULL)  ksprintf(tmp_var," ");
	else ksprintf(tmp_var, "%s", line_info->variable);

	if (line_info->file_def == NULL)  ksprintf(tmp_def," ");
	else ksprintf(tmp_def, "%s", line_info->file_def);

	if (line_info->filename == NULL)  ksprintf(tmp_file," ");
	else ksprintf(tmp_file, "%s", line_info->filename);

	if (line_info->literal == NULL)  ksprintf(tmp_literal," ");
	else ksprintf(tmp_literal, "%s", line_info->literal);

	if (line_info->write == FALSE)
        {
	(void) ksprintf (new_line, input_print, 
			line_info->activate, line_info->selected,
		       	line_info->optional, line_info->opt_sel,
			line_info->live, line_info->file_check,
                       	line_info->width, line_info->height,
                       	line_info->x,line_info->y,
		       	tmp_def, tmp_title, tmp_desc, 
                       	tmp_var, tmp_file, tmp_literal);
	 }
        else
        {
        (void) ksprintf (new_line, input_write,
                        line_info->activate, line_info->selected,
                        line_info->optional, line_info->opt_sel,
                        line_info->live, line_info->file_check,
                        line_info->width, line_info->height,
                        line_info->x,line_info->y,
                        tmp_def, tmp_title, tmp_desc, tmp_var);
        }

	kfree(*line); 
	*line = kstrdup(new_line);
}


/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_output_line
|       Purpose: Updates an Output line (-O:  typeflag = KUIS_OUTPUTFILE)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_output_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH], tmp_title[KLENGTH],
	     tmp_desc[KLENGTH], tmp_var[KLENGTH], 
	     tmp_def[KLENGTH], tmp_file[KLENGTH],
	     tmp_literal[KLENGTH];

	if (line_info->title == NULL)  ksprintf(tmp_title," ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	if (line_info->description == NULL)  ksprintf(tmp_desc," ");
	else ksprintf(tmp_desc, "%s", line_info->description);
	escape_ticmark(tmp_desc);

	if (line_info->variable == NULL)  ksprintf(tmp_var," ");
	else ksprintf(tmp_var, "%s", line_info->variable);

	if (line_info->file_def == NULL)  ksprintf(tmp_def," ");
	else ksprintf(tmp_def, "%s", line_info->file_def);

	if (line_info->filename == NULL)  ksprintf(tmp_file," ");
	else ksprintf(tmp_file, "%s", line_info->filename);

	if (line_info->literal == NULL)  ksprintf(tmp_literal," ");
	else ksprintf(tmp_literal, "%s", line_info->literal);

	if (line_info->write == FALSE)
        {
	(void) ksprintf	(new_line, output_print, 
			 line_info->activate, line_info->selected,
		       	 line_info->optional, line_info->opt_sel,
			 line_info->live, line_info->file_check,
                       	 line_info->width, line_info->height,
                       	 line_info->x,line_info->y,
		       	 tmp_def, tmp_title, tmp_desc, 
                       	 tmp_var, tmp_file, tmp_literal);
        }
        else
        {
        (void) ksprintf  (new_line, output_write,
                         line_info->activate, line_info->selected,
                         line_info->optional, line_info->opt_sel,
                         line_info->live, line_info->file_check,
                         line_info->width, line_info->height,
                         line_info->x,line_info->y,
                         tmp_def, tmp_title, tmp_desc, tmp_var);
        }

	kfree(*line); 
	*line = kstrdup(new_line);
}

/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_stdin_line
|       Purpose: Updates an Stdin line (-e:  typeflag = KUIS_STDIN)
|         Input: line_info - the Line_Info structure holding values
|                line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line
|       Returns: nothing
|          Date: April 26, 1994
|    Written by: Danielle Argiro
| Modifications: 
|
-------------------------------------------------------------*/

void kvf_deparse_stdin_line(
   Line_Info *line_info,
   char      **line)
{
        char new_line[KLENGTH], tmp_title[KLENGTH]; 
	char tmp_var[KLENGTH],  tmp_filename[KLENGTH];

        if (line_info->title == NULL) ksprintf(tmp_title, " ");
        else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

        if (line_info->variable == NULL)  ksprintf(tmp_var," ");
        else ksprintf(tmp_var, "%s", line_info->variable);

	if (line_info->filename == NULL)  ksprintf(tmp_filename," ");
        else ksprintf(tmp_filename, "%s", line_info->filename);

	if (line_info->write == FALSE)
	{
        (void) ksprintf (new_line, stdin_print, line_info->activate,
                        line_info->optional, line_info->opt_sel,
                        line_info->x,line_info->y, tmp_title, tmp_var,
		        tmp_filename);
	}
	else
	{
        (void) ksprintf (new_line, stdin_write, line_info->activate,
                        line_info->optional, line_info->opt_sel,
                        line_info->x,line_info->y, tmp_title, tmp_var);
	}

        kfree(*line);
        *line = kstrdup(new_line);
}

/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_stdout_line
|       Purpose: Updates an Stdout line (-o:  typeflag = KUIS_STDOUT)
|         Input: line_info - the Line_Info structure holding values
|                line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line
|       Returns: nothing
|          Date: April 26, 1994
|    Written by: Danielle Argiro
| Modifications: 
|
-------------------------------------------------------------*/

void kvf_deparse_stdout_line(
   Line_Info *line_info,
   char      **line)
{
        char new_line[KLENGTH], tmp_title[KLENGTH]; 
        char tmp_var[KLENGTH],  tmp_filename[KLENGTH];

        if (line_info->title == NULL) ksprintf(tmp_title, " ");
        else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

        if (line_info->variable == NULL)  ksprintf(tmp_var," ");
        else ksprintf(tmp_var, "%s", line_info->variable);

        if (line_info->filename == NULL)  ksprintf(tmp_filename," ");
        else ksprintf(tmp_filename, "%s", line_info->filename);

        if (line_info->write == FALSE)
        {
        (void) ksprintf (new_line, stdout_print, line_info->activate,
                        line_info->optional, line_info->opt_sel,
                        line_info->x,line_info->y, tmp_title, tmp_var,
		        tmp_filename);
         
	}
	else 
        {
        (void) ksprintf (new_line, stdout_write, line_info->activate,
                        line_info->optional, line_info->opt_sel,
                        line_info->x,line_info->y, tmp_title, tmp_var);
        }
        kfree(*line);
        *line = kstrdup(new_line);
}


/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_int_line
|       Purpose: Updates an Integer line (-i:  typeflag = KUIS_INTEGER)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_int_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH], tmp_title[KLENGTH],
	     tmp_desc[KLENGTH], tmp_var[KLENGTH],
	     tmp_literal[KLENGTH];

	if (line_info->title == NULL)  ksprintf(tmp_title," ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	if (line_info->description == NULL)  ksprintf(tmp_desc," ");
	else ksprintf(tmp_desc, "%s", line_info->description);
	escape_ticmark(tmp_desc);

	if (line_info->variable == NULL)  ksprintf(tmp_var," ");
	else ksprintf(tmp_var, "%s", line_info->variable);

	if (line_info->literal == NULL)  ksprintf(tmp_literal," ");
	else ksprintf(tmp_literal, "%s", line_info->literal);

        if (line_info->write == FALSE)
        {
	(void) ksprintf	(new_line, int_print, 
			 line_info->activate, line_info->selected,
		       	 line_info->optional, line_info->opt_sel,
			 line_info->live,
                       	 line_info->width, line_info->height,
                       	 line_info->x,line_info->y,
		       	 line_info->lower_int, line_info->upper_int,
		       	 line_info->int_def, line_info->special,
			 line_info->int_incr, tmp_title, tmp_desc, tmp_var, 
			 line_info->int_val, tmp_literal);
	}
        else
        {
        (void) ksprintf  (new_line, int_write,
                         line_info->activate, line_info->selected,
                         line_info->optional, line_info->opt_sel,
                         line_info->live,
                         line_info->width, line_info->height,
                         line_info->x,line_info->y,
                         line_info->lower_int, line_info->upper_int,
                         line_info->int_def, line_info->special,
			 line_info->int_incr,
			 tmp_title, tmp_desc, tmp_var);
        }

	kfree(*line); 
	*line = kstrdup(new_line);
}


/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_float_line
|       Purpose: Updates a Float line (-f:  typeflag = KUIS_FLOAT)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_float_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH], tmp_title[KLENGTH],
	     tmp_desc[KLENGTH], tmp_var[KLENGTH],
	     tmp_literal[KLENGTH];

	if (line_info->title == NULL)  ksprintf(tmp_title," ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	if (line_info->description == NULL)  ksprintf(tmp_desc," ");
	else ksprintf(tmp_desc, "%s", line_info->description);
	escape_ticmark(tmp_desc);

	if (line_info->variable == NULL)  ksprintf(tmp_var," ");
	else ksprintf(tmp_var, "%s", line_info->variable);

	if (line_info->literal == NULL)  ksprintf(tmp_literal," ");
	else ksprintf(tmp_literal, "%s", line_info->literal);

	if (line_info->write == FALSE)
        {
	(void) ksprintf	(new_line, float_print, 
			 line_info->activate, line_info->selected,
		       	 line_info->optional, line_info->opt_sel,
			 line_info->live,
                       	 line_info->width, line_info->height,
                       	 line_info->x,line_info->y,
		       	 line_info->lower_float, line_info->upper_float,
		       	 line_info->float_def, line_info->precision,
			 line_info->special, line_info->flt_incr,
			 tmp_title, tmp_desc, 
		       	 tmp_var, line_info->float_val, tmp_literal);
        }
        else
        {
        (void) ksprintf  (new_line, float_write,
                         line_info->activate, line_info->selected,
                         line_info->optional, line_info->opt_sel,
                         line_info->live,
                         line_info->width, line_info->height,
                         line_info->x,line_info->y,
                         line_info->lower_float, line_info->upper_float,
                         line_info->float_def, line_info->precision,
			 line_info->special, line_info->flt_incr,
			 tmp_title, tmp_desc, tmp_var);
        }

	kfree(*line); 
	*line = kstrdup(new_line);
}

/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_double_line
|       Purpose: Updates a Double line (-h:  typeflag = KUIS_DOUBLE)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_double_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH], tmp_title[KLENGTH],
	     tmp_desc[KLENGTH], tmp_var[KLENGTH],
	     tmp_literal[KLENGTH];

	if (line_info->title == NULL)  ksprintf(tmp_title," ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	if (line_info->description == NULL)  ksprintf(tmp_desc," ");
	else ksprintf(tmp_desc, "%s", line_info->description);
	escape_ticmark(tmp_desc);

	if (line_info->variable == NULL)  ksprintf(tmp_var," ");
	else ksprintf(tmp_var, "%s", line_info->variable);

	if (line_info->literal == NULL)  ksprintf(tmp_literal," ");
	else ksprintf(tmp_literal, "%s", line_info->literal);

	if (line_info->write == FALSE)
        {
	(void) ksprintf	(new_line, double_print, 
			 line_info->activate, line_info->selected,
		       	 line_info->optional, line_info->opt_sel,
			 line_info->live,
                       	 line_info->width, line_info->height,
                       	 line_info->x,line_info->y,
		       	 line_info->lower_double, line_info->upper_double,
		       	 line_info->double_def, line_info->precision,
			 line_info->special, line_info->dbl_incr,
			 tmp_title, tmp_desc, 
		       	 tmp_var, line_info->double_val, tmp_literal);
        }
        else
        {
        (void) ksprintf  (new_line, double_write,
                         line_info->activate, line_info->selected,
                         line_info->optional, line_info->opt_sel,
                         line_info->live,
                         line_info->width, line_info->height,
                         line_info->x,line_info->y,
                         line_info->lower_double, line_info->upper_double,
                         line_info->double_def, line_info->precision,
			 line_info->special, line_info->dbl_incr,
			 tmp_title, tmp_desc, tmp_var);
        }

	kfree(*line); 
	*line = kstrdup(new_line);
}

/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_logic_line
|       Purpose: Updates a Logic line (-l:  typeflag = KUIS_LOGICAL)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_logic_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH], tmp_title[KLENGTH],
	     tmp_desc[KLENGTH], tmp_var[KLENGTH],
	     tmp_label0[KLENGTH], tmp_label1[KLENGTH];

	if (line_info->title == NULL) ksprintf(tmp_title," ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	if (line_info->description == NULL)  ksprintf(tmp_desc," ");
	else ksprintf(tmp_desc, "%s", line_info->description);
	escape_ticmark(tmp_desc);

	if (line_info->val_labels[0] == NULL)  ksprintf(tmp_label0," ");
	else ksprintf(tmp_label0, "%s", line_info->val_labels[0]);
	escape_ticmark(tmp_label0);

	if (line_info->val_labels[1] == NULL)  ksprintf(tmp_label1," ");
	else ksprintf(tmp_label1, "%s", line_info->val_labels[1]);
	escape_ticmark(tmp_label1);

	if (line_info->variable == NULL)  ksprintf(tmp_var," ");
	else ksprintf(tmp_var, "%s", line_info->variable);

        if (line_info->write == FALSE)
        {
	(void) ksprintf(new_line, logic_print, 
		       line_info->activate, line_info->selected, 
		       line_info->optional, line_info->opt_sel,
		       line_info->live,
                       line_info->width, line_info->height,
                       line_info->x,line_info->y,
		       line_info->logical_def, tmp_title, 
		       tmp_label0, tmp_label1, tmp_desc, 
		       tmp_var, line_info->logical_val);
        }
        else
        {
        (void) ksprintf(new_line, logic_write,
                       line_info->activate, line_info->selected,
                       line_info->optional, line_info->opt_sel,
                       line_info->live,
                       line_info->width, line_info->height,
                       line_info->x,line_info->y,
                       line_info->logical_def, tmp_title,
                       tmp_label0, tmp_label1, tmp_desc, tmp_var);
        }

	kfree(*line); 
	*line = kstrdup(new_line);
}

/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_flag_line
|       Purpose: Updates a Flag line (-t)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jun 26, 1992
|    Written by: Danielle Argiro
| Modifications:
|
-------------------------------------------------------------*/

void kvf_deparse_flag_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH], tmp_title[KLENGTH],
	     tmp_desc[KLENGTH], tmp_var[KLENGTH];

	if (line_info->title == NULL) ksprintf(tmp_title," ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	if (line_info->description == NULL)  ksprintf(tmp_desc," ");
	else ksprintf(tmp_desc, "%s", line_info->description);
	escape_ticmark(tmp_desc);

	if (line_info->variable == NULL)  ksprintf(tmp_var," ");
	else ksprintf(tmp_var, "%s", line_info->variable);

        if (line_info->write == FALSE)
        {
	(void) ksprintf(new_line, flag_print, 
		       line_info->activate, line_info->selected, 
		       line_info->optional, line_info->opt_sel,
		       line_info->live,
                       line_info->width, line_info->height,
                       line_info->x, line_info->y,
		       tmp_title, tmp_desc, tmp_var);
        }
        else
        {
        (void) ksprintf(new_line, flag_write,
                       line_info->activate, line_info->selected,
                       line_info->optional, line_info->opt_sel,
                       line_info->live,
                       line_info->width, line_info->height,
                       line_info->x, line_info->y,
                       tmp_title, tmp_desc, tmp_var);
        }

	kfree(*line); 
	*line = kstrdup(new_line);
}


/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_cycle_line
|       Purpose: Updates a Cycle line (-c:  typeflag = KUIS_CYCLE)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_cycle_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[35*KLENGTH], tmpline[35*KLENGTH],
	     tmp_title[KLENGTH],  buffer[KLENGTH],
	     tmp_desc[KLENGTH], tmp_var[KLENGTH];
	int  i;

	if (line_info->title == NULL) ksprintf(tmp_title," ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	if (line_info->description == NULL)  ksprintf(tmp_desc," ");
	else ksprintf(tmp_desc, "%s", line_info->description);
	escape_ticmark(tmp_desc);

	if (line_info->variable == NULL)  ksprintf(tmp_var," ");
	else ksprintf(tmp_var, "%s", line_info->variable);

	(void) ksprintf(tmpline, cycle_print, 
		       line_info->activate, line_info->selected, 
		       line_info->optional, line_info->opt_sel,
		       line_info->live,
                       line_info->width, line_info->height,
                       line_info->x,line_info->y,
		       line_info->list_num, 
		       line_info->int_val, line_info->list_val,
		       tmp_title, tmp_desc, tmp_var);

	for (i = 0; i < line_info->list_num; i++)
	{
              ksprintf(buffer, line_info->val_labels[i]);
              escape_ticmark(buffer);
              if (kstrlen(buffer) == 0)
                  ksprintf(tmpline, "%s ' '", tmpline);
              else ksprintf(tmpline, "%s '%s'", tmpline, buffer);
	}
	ksprintf(new_line, "%s", tmpline);

	kfree(*line); 
	*line = kstrdup(new_line);
}


/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_list_line
|       Purpose: Updates a List line (-x:  typeflag = KUIS_LIST)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_list_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[35*KLENGTH], tmpline[35*KLENGTH],
	     tmp_title[KLENGTH], buffer[KLENGTH],
	     tmp_desc[KLENGTH], tmp_var[KLENGTH];
	int  i;

	if (line_info->title == NULL) ksprintf(tmp_title," ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	if (line_info->description == NULL)  ksprintf(tmp_desc," ");
	else ksprintf(tmp_desc, "%s", line_info->description);
	escape_ticmark(tmp_desc);

	if (line_info->variable == NULL)  ksprintf(tmp_var," ");
	else ksprintf(tmp_var, "%s", line_info->variable);

	(void) ksprintf(tmpline, list_print, 
		       line_info->activate, line_info->selected, 
		       line_info->optional, line_info->opt_sel,
		       line_info->live,
                       line_info->width, line_info->height,
                       line_info->x,line_info->y,
		       line_info->list_num, line_info->int_val,
		       line_info->list_val,
		       tmp_title, tmp_desc, tmp_var);

	for (i = 0; i < line_info->list_num; i++)
	{
	      ksprintf(buffer, line_info->val_labels[i]);
	      escape_ticmark(buffer);
              if (kstrlen(buffer) == 0)
                  ksprintf(tmpline, "%s ' '", tmpline);
              else ksprintf(tmpline, "%s '%s'", tmpline, buffer);
	}
	ksprintf(new_line, "%s", tmpline);

	kfree(*line); 
	*line = kstrdup(new_line);
}


/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_displaylist_line
|       Purpose: Updates a DisplayList line (-z:  typeflag = KUIS_DISPLAYLIST)
|         Input: line_info - the Line_Info structure holding values
|                line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line
|       Returns: nothing
|          Date: Jan 18, 1994
|    Written by: Danielle Argiro
| Modifications: 
|
-------------------------------------------------------------*/

void kvf_deparse_displaylist_line(
   Line_Info *line_info,
   char      **line)
{
        char new_line[35*KLENGTH], tmpline[35*KLENGTH],
             tmp_title[KLENGTH], buffer[KLENGTH],
             tmp_desc[KLENGTH], tmp_var[KLENGTH];
        int  i;

        if (line_info->title == NULL) ksprintf(tmp_title," ");
        else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

        if (line_info->description == NULL)  ksprintf(tmp_desc," ");
        else ksprintf(tmp_desc, "%s", line_info->description);
	escape_ticmark(tmp_desc);

        if (line_info->variable == NULL)  ksprintf(tmp_var," ");
        else ksprintf(tmp_var, "%s", line_info->variable);

        (void) ksprintf(tmpline, displaylist_print,
                       line_info->activate, line_info->selected,
                       line_info->optional, line_info->opt_sel,
                       line_info->live,
                       line_info->width, line_info->height,
                       line_info->x,line_info->y,
                       line_info->list_num, line_info->int_val,
                       line_info->list_val,
                       line_info->special,
                       tmp_title, tmp_desc, tmp_var);

        for (i = 0; i < line_info->list_num; i++)
        {
	      ksprintf(buffer, line_info->val_labels[i]);
	      escape_ticmark(buffer);
              if (kstrlen(buffer) == 0)
                  ksprintf(tmpline, "%s ' '", tmpline);
              else ksprintf(tmpline, "%s '%s'", tmpline, buffer);
        }
        ksprintf(new_line, "%s", tmpline);

        kfree(*line);
        *line = kstrdup(new_line);
}


/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_string_line
|       Purpose: Updates a String line (-s:  typeflag = KUIS_STRING)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_string_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[75*KLENGTH], tmp_title[KLENGTH],
	     tmp_desc[KLENGTH], tmp_var[KLENGTH], tmp_def[10*KLENGTH],
	     tmp_val[25*KLENGTH], tmp_literal[25*KLENGTH];

	if (line_info->title == NULL)  ksprintf(tmp_title," ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	if (line_info->description == NULL)  ksprintf(tmp_desc," ");
	else ksprintf(tmp_desc, "%s", line_info->description);
	escape_ticmark(tmp_desc);

	if (line_info->variable == NULL)  ksprintf(tmp_var," ");
	else ksprintf(tmp_var, "%s", line_info->variable);

	if (line_info->string_def == NULL)  ksprintf(tmp_def," ");
	else ksprintf(tmp_def, "%s", line_info->string_def);
	escape_ticmark(tmp_def);

	if (line_info->string_val == NULL)  ksprintf(tmp_val," ");
	else ksprintf(tmp_val, "%s", line_info->string_val);
	escape_ticmark(tmp_val);

	if (line_info->literal == NULL)  ksprintf(tmp_literal," ");
	else ksprintf(tmp_literal, "%s", line_info->literal);
	escape_ticmark(tmp_literal);

        if (line_info->write == FALSE)
        {
	(void) ksprintf	(new_line, string_print, 
			 line_info->activate, line_info->selected,
			 line_info->optional, line_info->opt_sel,
			 line_info->live,
			 line_info->width, line_info->height,
			 line_info->x,line_info->y,
		       	 tmp_def, tmp_title, tmp_desc, 
                       	 tmp_var, tmp_val, tmp_literal);
	}
        else
        {
        (void) ksprintf  (new_line, string_write,
                         line_info->activate, line_info->selected,
                         line_info->optional, line_info->opt_sel,
                         line_info->live,
                         line_info->width, line_info->height,
                         line_info->x,line_info->y,
                         tmp_def, tmp_title, tmp_desc, tmp_var);
        }

	kfree(*line); 
	*line = kstrdup(new_line);
}


/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_stringlist_line
|       Purpose: Updates a StringList line (-y:  typeflag = KUIS_STRINGLIST)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Sep 17, 1992
|    Written by: Danielle Argiro 
| Modifications: 
|
-------------------------------------------------------------*/

void kvf_deparse_stringlist_line(
   Line_Info *line_info,
   char      **line)
{
	int  i;
	char new_line[75*KLENGTH], tmpline[75*KLENGTH], buffer[KLENGTH],
	     tmp_title[KLENGTH], tmp_desc[KLENGTH], tmp_var[KLENGTH], 
	     tmp_def[25*KLENGTH], tmp_val[25*KLENGTH], tmp_literal[25*KLENGTH];

	if (line_info->title == NULL)  ksprintf(tmp_title," ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	if (line_info->description == NULL)  ksprintf(tmp_desc," ");
	else ksprintf(tmp_desc, "%s", line_info->description);
	escape_ticmark(tmp_desc);

	if (line_info->variable == NULL)  ksprintf(tmp_var," ");
	else ksprintf(tmp_var, "%s", line_info->variable);

	if (line_info->string_def == NULL)  ksprintf(tmp_def," ");
	else ksprintf(tmp_def, "%s", line_info->string_def);
	escape_ticmark(tmp_def);

	if (line_info->string_val == NULL)  ksprintf(tmp_val," ");
	else ksprintf(tmp_val, "%s", line_info->string_val);
	escape_ticmark(tmp_val);

	if (line_info->literal == NULL)  ksprintf(tmp_literal," ");
	else ksprintf(tmp_literal, "%s", line_info->literal);
	escape_ticmark(tmp_literal);

	(void) ksprintf  (tmpline, stringlist_print,
                         line_info->activate, line_info->selected,
                         line_info->optional, line_info->opt_sel,
                         line_info->live,
                         line_info->width, line_info->height,
                         line_info->x, line_info->y,
                         line_info->list_num, line_info->list_val,
		         tmp_title, tmp_desc, tmp_var);

	for (i = 0; i < line_info->list_num; i++)
	{
	      ksprintf(buffer, line_info->val_labels[i]);
	      escape_ticmark(buffer);
	      if (kstrlen(buffer) == 0)
	          ksprintf(tmpline, "%s ' '", tmpline);
	      else ksprintf(tmpline, "%s '%s'", tmpline, buffer);
	}
	ksprintf(new_line, "%s", tmpline);

        if (line_info->write == FALSE)
	      ksprintf(tmpline, "%s '%s' '%s'", tmpline, tmp_val, tmp_literal);

	ksprintf(new_line, "%s", tmpline);

	kfree(*line); 
	*line = kstrdup(new_line);
}
/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_routine_line
|       Purpose: Updates a Routine line (-r:  typeflag = Routine)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_routine_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH], tmp_title[KLENGTH],
	     tmp_desc[KLENGTH], tmp_comm[KLENGTH];

	if (line_info->title == NULL)  ksprintf(tmp_title," ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	if (line_info->description == NULL)  ksprintf(tmp_desc," ");
	else ksprintf(tmp_desc, "%s", line_info->description);
	escape_ticmark(tmp_desc);

	if (line_info->routine == NULL)  ksprintf(tmp_comm," ");
	else ksprintf(tmp_comm, "%s", line_info->routine);

	(void) ksprintf(new_line, routine_print, line_info->activate,
		       line_info->selected, line_info->exec_type,
                       line_info->width, line_info->height,
                       line_info->x,line_info->y,
		       tmp_title, tmp_desc, tmp_comm, 
		       line_info->exec_bg);

	kfree(*line); 
	*line = kstrdup(new_line);
}


/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_toggle_line
|       Purpose: Updates a Toggle line (-T:  typeflag = KUIS_TOGGLE)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_toggle_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH], tmp_title[KLENGTH]; 
	char tmp_desc[KLENGTH], tmp_var[KLENGTH]; 

	if (line_info->title == NULL)  ksprintf(tmp_title," ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	if (line_info->description == NULL)  ksprintf(tmp_desc," ");
	else ksprintf(tmp_desc, "%s", line_info->description);
	escape_ticmark(tmp_desc);

	if (line_info->variable == NULL)  ksprintf(tmp_var," ");
	else ksprintf(tmp_var, "%s", line_info->variable);

        if (line_info->write == FALSE)
        {
	(void) ksprintf  (new_line, toggle_print, 
			 line_info->activate, line_info->selected,
		       	 line_info->optional, line_info->opt_sel,
			 line_info->live,
                       	 line_info->width, line_info->height,
                       	 line_info->x,line_info->y,
                         line_info->xpos, line_info->ypos,
		       	 line_info->toggle_def, tmp_title, tmp_desc, 
			 tmp_var, line_info->toggle_val);
	}
        else
        {
        (void) ksprintf  (new_line, toggle_write,
                         line_info->activate, line_info->selected,
                         line_info->optional, line_info->opt_sel,
                         line_info->live,
                         line_info->width, line_info->height,
                         line_info->x,line_info->y,
                         line_info->xpos, line_info->ypos,
                         line_info->toggle_def, tmp_title, tmp_desc, tmp_var);
        }

	kfree(*line); 
	*line = kstrdup(new_line);
}


/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_blank_line
|       Purpose: Updates a Blank line (-b:  typeflag = KUIS_BLANK)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_blank_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH], tmp_title[KLENGTH], tmp_var[KLENGTH];

	if (line_info->title == NULL)  ksprintf(tmp_title," ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	if (line_info->variable == NULL)  ksprintf(tmp_var," ");
	else ksprintf(tmp_var, "%s", line_info->variable);

	(void) ksprintf(new_line, blank_print, line_info->xpos,
		       line_info->ypos, tmp_title, tmp_var);

	kfree(*line); 
	*line = kstrdup(new_line);
}


/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_pane_action_line
|       Purpose: Updates a PaneAction line (-a:  typeflag = KUIS_PANEACTION)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_pane_action_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH], tmp_title[KLENGTH],
	     tmp_desc[KLENGTH], tmp_var[KLENGTH];

	if (line_info->title == NULL)  ksprintf(tmp_title," ");
	else ksprintf(tmp_title, "%s", line_info->title);
	escape_ticmark(tmp_title);

	if (line_info->description == NULL) ksprintf(tmp_desc," ");
	else ksprintf(tmp_desc, "%s", line_info->description);
	escape_ticmark(tmp_desc);

	if (line_info->variable == NULL)  ksprintf(tmp_var," ");
	else ksprintf(tmp_var, "%s", line_info->variable);

	(void) ksprintf(new_line, pane_action_print, line_info->activate,
		       line_info->selected,
                       line_info->width, line_info->height,
                       line_info->x,line_info->y,
                       tmp_title, tmp_desc, tmp_var);

	kfree(*line); 
	*line = kstrdup(new_line);
}


/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_includepane_line
|       Purpose: Updates an IncludePane line 
|                         (-p:  typeflag = KUIS_INCLUDEPANE)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_includepane_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH], tmp_file[KLENGTH];

	if (line_info->filename == NULL)  
	{
	     errno = KCALL;
	     kerror("kforms", "kvf_deparse_includepane_line",
		    "The 'filename' field on the -p line not set correctly");
	     return;
	}

	(void) ksprintf(new_line, includepane_print, tmp_file);

	kfree(*line); 
	*line = kstrdup(new_line);
}


/*-----------------------------------------------------------
|
|       Routine: kvf_deparse_includesubform_line
|       Purpose: Updates an IncludeSubform line 
|  		 	(-k:  typeflag = KUIS_INCLUDESUBFORM)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_includesubform_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH], tmp_file[KLENGTH];

	if (line_info->filename == NULL)  
	{
	     errno = KCALL;
	     kerror("kforms", "kvf_deparse_includesubform_line",
		    "The 'filename' field on the -k line not set correctly");
	     return;
	}

	(void) ksprintf(new_line, includesubform_print, tmp_file);

	kfree(*line); 
	*line = kstrdup(new_line);
}

/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_mutexcl_line
|       Purpose: Updates a Mutually Exclusive line (-C:  typeflag = KUIS_MUTEXCL)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jun 06, 1992
|    Written by: Danielle Argiro 
| Modifications: 
|
-------------------------------------------------------------*/

void kvf_deparse_mutexcl_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH];

	(void) ksprintf(new_line, "-C %d", line_info->logical_val);

	kfree(*line); 
	*line = kstrdup(new_line);
}


/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_mutincl_line
|       Purpose: Updates a Mutually Inclusive line (-B:  typeflag = KUIS_MUTINCL)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jun 06, 1992
|    Written by: Danielle Argiro 
| Modifications:
|
-------------------------------------------------------------*/

void kvf_deparse_mutincl_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH];

	(void) ksprintf(new_line, "-B %d", line_info->logical_val);

	kfree(*line); 
	*line = kstrdup(new_line);
}

/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_group_line
|       Purpose: Updates a Group line (-K:  typeflag = KUIS_GROUP)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Oct 6, 1993
|    Written by: Danielle Argiro 
| Modifications: 
|
-------------------------------------------------------------*/

void kvf_deparse_group_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH];

	(void) ksprintf(new_line, "-K %d", line_info->logical_val);

	kfree(*line); 
	*line = kstrdup(new_line);
}


/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_workspace_line
|       Purpose: Updates a Workspace line  (-w:  typeflag = KUIS_WORKSPACE)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void kvf_deparse_workspace_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH]; 
	char tmp_desc[KLENGTH], tmp_var[KLENGTH];
        long tmp_wksp_address = 0;

	if (line_info->description == NULL)  ksprintf(tmp_desc," ");
	else ksprintf(tmp_desc, "%s", line_info->description);
	escape_ticmark(tmp_desc);

	if (line_info->variable == NULL)  ksprintf(tmp_var," ");
	else ksprintf(tmp_var, "%s", line_info->variable);

        if (line_info->workspace != NULL) 
	    tmp_wksp_address = (long) line_info->workspace;

	if (line_info->write == FALSE)
        {
	(void) ksprintf(new_line, workspace_print, 
		       line_info->width, line_info->height,
                       line_info->x, line_info->y,
		       tmp_desc, tmp_var, tmp_wksp_address);
        }
        else
        {
        (void) ksprintf(new_line, workspace_write,
                       line_info->width, line_info->height,
                       line_info->x, line_info->y,
                       tmp_desc, tmp_var);
        }

	kfree(*line); 
	*line = kstrdup(new_line);
}

/*-------------------------------------------------------------
|
|       Routine: kvf_deparse_end_line
|       Purpose: Updates an End line (-E:  typeflag = KUIS_END)
|         Input: line_info - the Line_Info structure holding values
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

/* ARGSUSED */
void kvf_deparse_end_line(
   Line_Info *line_info,
   char      **line)
{
	char new_line[KLENGTH];

	(void) ksprintf(new_line, "-E");

	kfree(*line); 
	*line = kstrdup(new_line);
}


/*-----------------------------------------------------------
|
|  Routine Name: kvf_gen_deparse
|
|       Purpose: Updates an undetermined type of UIS line
|         Input: line_info - Line_Info structure (with CORRECT type flag)
|		 line      - pointer to the old UIS line
|        Output: line      - pointer to the new UIS line 
|       Returns: nothing
|          Date: Jul 14, 1992
|    Written by: Danielle Argiro 
| Modifications: Converted from Khoros 1.0 (DA)
|
------------------------------------------------------------*/

void kvf_gen_deparse(
   Line_Info *line_info,
   char      **line)
{
	switch (line_info->typeflag)
	{

		case KUIS_STARTFORM:
		     kvf_deparse_startform_line(line_info, line);
		     break;

		case KUIS_STARTMASTER:
		     kvf_deparse_startmaster_line(line_info, line);
		     break;

		case KUIS_STARTSUBMENU:
		     kvf_deparse_startsubmenu_line(line_info, line);
		     break;

		case KUIS_STARTSUBFORM:
		     kvf_deparse_startsubform_line(line_info, line);
		     break;

		case KUIS_STARTPANE:
		     kvf_deparse_startpane_line(line_info, line);
		     break;

		case KUIS_STARTGUIDE:
		     kvf_deparse_startguide_line(line_info, line);
		     break;

		case KUIS_GUIDEBUTTON:
		     kvf_deparse_guide_line(line_info, line);
		     break;
	
		case KUIS_MASTERACTION:
		     kvf_deparse_master_action_line(line_info, line);
		     break;
	 
		case KUIS_SUBFORMBUTTON:
		     kvf_deparse_subformbutton_line(line_info, line);
		     break;
	
		case KUIS_SUBFORMACTION:
		     kvf_deparse_subform_action_line(line_info, line);
		     break;
	
		case KUIS_QUIT:
		     kvf_deparse_quit_line(line_info, line);
		     break;
	 
		case KUIS_INPUTFILE:
		     kvf_deparse_input_line(line_info, line);
		     break;

		case KUIS_OUTPUTFILE:
		     kvf_deparse_output_line(line_info, line);
		     break;

		case KUIS_STDIN:
		     kvf_deparse_stdin_line(line_info, line);
		     break;

		case KUIS_STDOUT:
		     kvf_deparse_stdout_line(line_info, line);
		     break;

		case KUIS_INTEGER:
		     kvf_deparse_int_line(line_info, line);
		     break;

		case KUIS_FLOAT:
		     kvf_deparse_float_line(line_info, line);
		     break;

		case KUIS_DOUBLE:
		     kvf_deparse_double_line(line_info, line);
		     break;

		case KUIS_STRING:
		     kvf_deparse_string_line(line_info, line);
		     break;

		case KUIS_STRINGLIST:
		     kvf_deparse_stringlist_line(line_info, line);
		     break;

		case KUIS_LOGICAL:
		     kvf_deparse_logic_line(line_info, line);
	     	     break;

		case KUIS_TOGGLE:
		     kvf_deparse_toggle_line(line_info, line);
		     break;

		case KUIS_ROUTINE:
		     kvf_deparse_routine_line(line_info, line);
		     break;

		case KUIS_HELP:
		     kvf_deparse_help_line(line_info, line);
		     break;

		case KUIS_BLANK:
		     kvf_deparse_blank_line(line_info, line);
		     break;

		case KUIS_PANEACTION:
		     kvf_deparse_pane_action_line(line_info, line);
		     break;

		case KUIS_INCLUDEPANE:
		     kvf_deparse_includepane_line(line_info, line);
		     break;

		case KUIS_INCLUDESUBFORM:
		     kvf_deparse_includesubform_line(line_info, line);
		     break;

		case KUIS_MUTEXCL:
		     kvf_deparse_mutexcl_line(line_info, line);
		     break;

		case KUIS_MUTINCL:
		     kvf_deparse_mutincl_line(line_info, line);
		     break;

		case KUIS_GROUP:
		     kvf_deparse_group_line(line_info, line);
		     break;

		case KUIS_WORKSPACE:
		     kvf_deparse_workspace_line(line_info, line);
		     break;

		case KUIS_CYCLE:
		     kvf_deparse_cycle_line(line_info, line);
		     break;

		case KUIS_LIST:
		     kvf_deparse_list_line(line_info, line);
		     break;

		case KUIS_DISPLAYLIST:
		     kvf_deparse_displaylist_line(line_info, line);
		     break;

		case KUIS_FLAG:
		     kvf_deparse_flag_line(line_info, line);
		     break;

		case KUIS_END:
		     kvf_deparse_end_line(line_info, line);
		
                default:
	  	     break;

	} /* end switch */
}

/*-------------------------------------------------------------
|
|       Routine: escape_ticmark
|       Purpose: In strings, if there are any tic marks ('), these
|		 need to be escaped (changed to \') before they are
|		 written out in the UIS line, or the next time that
|		 UIS line is parsed, it will produce an error.
|         Input: string - Already-allocated string buffer 
|        Output: string - string with ' changed to \' (if applicable)
|       Returns: 
|          Date: Feb 24, 1994
|    Written by: Danielle Argiro
| Modifications: 
|
-------------------------------------------------------------*/

/* ARGSUSED */
static void escape_ticmark(
   char *string)
{
	/*
	 *  if there is a ' in the string, replace it with \'
	 */
	if (kstrchr(string, '\'') != NULL)
	    (void) kstring_replace(string, "\'", "\\\'", string);
}
