/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>             Generalized utility routines              <<<<
   >>>>             used by both code generators              <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>                kgen_ascii_datatype()                  <<<<
   >>>>                kgen_ascii_def_val()                   <<<<
   >>>>   Static:                                             <<<<
   >>>>   Public:                                             <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"


/*-----------------------------------------------------------
|
|  Routine Name: kgen_ascii_datatype
|
|       Purpose: Returns the ascii name of the type of argument
|
|         Input: typeflag - typeflag of the UIS line
|
|        Output: 
|       Returns: The string name of that type; note, 
|                do NOT modify or free this string!
|    Written By: Danielle Argiro
|          Date: Jul 23, 1992 
| Modifications: 
|
------------------------------------------------------------*/

char *kgen_ascii_datatype(
   int typeflag)
{
	char *name = NULL;

	switch (typeflag) {
		
	    case KUIS_INPUTFILE: 	name = "infile"; 	break;
	    case KUIS_STDIN:        	name = "kstdin"; 	break;
	    case KUIS_OUTPUTFILE: 	name = "outfile"; 	break;
	    case KUIS_STDOUT: 	        name = "kstdout"; 	break;
	    case KUIS_INTEGER: 		name = "integer"; 	break;
	    case KUIS_FLOAT: 		name = "float"; 	break;
	    case KUIS_DOUBLE: 		name = "double"; 	break;
	    case KUIS_STRINGLIST:
	    case KUIS_STRING: 		name = "string"; 	break;
	    case KUIS_LOGICAL: 		name = "boolean"; 	break;
	    case KUIS_FLAG: 		name = "flag"; 		break;
	    case KUIS_CYCLE: 		name = "cycle"; 	break;
	    case KUIS_LIST: 		name = "list"; 		break;
	    case KUIS_DISPLAYLIST: 	name = "displaylist"; 	break;
	}
	return(name);
}



/*-----------------------------------------------------------
|
|  Routine Name: kgen_ascii_def_val
|
|       Purpose: Returns the ascii rep of the default value of 
|                the argument, depending on type of argument
|
|         Input: selection - selection for which default is needed
|        Output: Returns the string rep of the default for that selection
|
|    Written By: Danielle Argiro
|          Date: April 2, 1994 
| Modifications: 
|
------------------------------------------------------------*/

char *kgen_ascii_def_val(
   kselection *selection)
{
        char   temp[KLENGTH];
        char   *def_str;
	char   *file_def;
	char   *string_def;
	int    int_def;
	float  flt_def;
	double dbl_def;
    
        switch (selection->type) {
    		
    	    case KUIS_INPUTFILE:
    	    case KUIS_OUTPUTFILE:
		 kvf_get_attribute(selection->back_kformstruct, 
				   KVF_FILE_DEF, &file_def);
    	         if (file_def == NULL)
    	             def_str = kstrdup("{none}");
    	         else def_str = kstrdup(file_def);
    	         break;
    
    	    case KUIS_INTEGER:
		 kvf_get_attribute(selection->back_kformstruct, 
				   KVF_INT_DEF, &int_def);
    	         ksprintf(temp, "%d", int_def);
    	         def_str = kstrdup(temp);
    	         break;
    
    	    case KUIS_FLOAT:
		 kvf_get_attribute(selection->back_kformstruct, 
				   KVF_FLOAT_DEF, &flt_def);
    	         ksprintf(temp, "%g", flt_def);
    	         def_str = kstrdup(temp);
    	         break;
    
    	    case KUIS_DOUBLE:
		 kvf_get_attribute(selection->back_kformstruct, 
				   KVF_DOUBLE_DEF, &dbl_def);
    	         ksprintf(temp, "%g", dbl_def);
    	         def_str = kstrdup(temp);
    	         break;
    
    	    case KUIS_STRING:
    	    case KUIS_STRINGLIST:
		 kvf_get_attribute(selection->back_kformstruct, 
				   KVF_STRING_DEF, &string_def);
    	         if (string_def == NULL)
    	             def_str = kstrdup("{none}");
    	         else def_str = kstrdup(string_def);
    	         break;
    
    	    case KUIS_LOGICAL:
		 kvf_get_attribute(selection->back_kformstruct, 
				   KVF_LOGIC_DEF, &int_def);
    	         if (int_def == TRUE)
    	             def_str = kstrdup("true");
    	         else def_str = kstrdup("false");
    	         break;
    
    	    case KUIS_FLAG:
		 def_str = NULL;
    	         break;

	    case KUIS_TOGGLE:
		 kvf_get_attribute(selection->back_kformstruct, 
				   KVF_TOGGLE_VAL, &string_def);
	         ksprintf(temp, "%s", string_def);
		 def_str = kstrdup(temp);
		 break;
    
	    case KUIS_LIST:
	    case KUIS_CYCLE:
	    case KUIS_DISPLAYLIST:
		 kvf_get_attributes(selection->back_kformstruct, 
				    KVF_LIST_ITEM, &string_def,
				    KVF_LIST_VAL, &int_def,
				    NULL);
	         ksprintf(temp, "%d \"%s\"", int_def, string_def);
		 def_str = kstrdup(temp);
		 break;
    	default:
		 kerror(KCODEGEN, "kgen_ascii_def_val", "Unknown type sent in");
    	         def_str = NULL;
		 break;
        }
        return(def_str);
}

/************************************************************
*
*  Routine Name: function_name - short function description
*
*       Purpose: Detailed description of the function
*
*         Input: input_1  - input argument 1 description
*                input_2  - input argument 2 description
*        Output: output_1 - output argument 1 description
*                output_2 - output argument 2 description
*       Returns: return value
*  Restrictions: restrictions of the function (if any)
*    Written By: author
*          Date: date of creation
*      Verified:
*  Side Effects: side effects of the function (if any)
* Modifications:
*   Declaration: return_type function_name(
*			data_type input_1, ...
*			data_type input_n,
*			data_type output_1, ...
*			data_type output_n)
*
*************************************************************/
