/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>           Driving routine for code generation         <<<<
   >>>>                   for xvroutines                      <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>   Static:                                             <<<<
   >>>>              add_form_file_object()                   <<<<
   >>>>   Public:                                             <<<<
   >>>>              kgen_generate_gui()                      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"

/************************************************************
*  Routine Name: kgen_generate_gui -  generate code for GUI
*       Purpose: Generates the code for a GUI, including GUI Information
*                structure, code to initialize the GUI Information structure,
*                and code to extract user input from the GUI and store it
*                in the GUI Information structure.
*
*         Input: object	- software object (xvroutine) for which to 
*                         generate code 
*
*       Returns: TRUE on success, FALSE otherwise
*    Written By: Danielle Argiro and Neil Bowers
*          Date: 31-jan-1995
*************************************************************/
int
kgen_generate_gui(
   kobject object)
{
	kstring  routine       = "kgen_generate_gui()";
	int      result        = FALSE;
        kform   *form;
        char    *uis_filename;
	kobject  file_object;         /* file object for UIS form file */
	kstring  topsrc;
	char    *tbname;
	char    *oname;
	int      levels;
	kstring  datestamp;


	/*
	 * make sure that program is an xvroutine before going on
	 */
	if (!kcms_get_attributes(object,
				 KCMS_NAME,            &oname,
				 KCMS_CMOBJ_LEVELS,    &levels,
				 KCMS_CMOBJ_UIS_FORM,  &file_object,
				 KCMS_CMOBJ_TOPSRC,    &topsrc,
				 KCMS_END)
	    || !kcms_get_indirect_attribute(object, KCMS_PARENT,
					    KCMS_NAME, &tbname))
	   return(FALSE);

	if (file_object == NULL)
	{
            kwarn(KCODEGEN, routine,
                   "object %s::%s has no form UIS file,\n"
		   "so cannot generate GUI code for the object!",
		   tbname, oname);
	    /*-- return TRUE, so no further messages are generated --*/
	    return(TRUE);
	}
	if (!kcms_get_attribute(file_object, KCMS_PATH, &uis_filename)
	    || uis_filename == NULL)
            return(FALSE);

	/*
	 *  create a temporary directory in TMPDIR in which we will keep
         *  the several temp files from which we create form_drv.c & do_*.c
	 */
	kgen_tmpdirname = ktempnam(NULL, "conductor");
	kunlink(kgen_tmpdirname);

	/*
	 *  figure out which directory generated files will be going to
	 */
	if (kfullpath(topsrc, NULL, kgen_fulltopsrc) == NULL)
	    return(FALSE);

	form = kvf_create_form(uis_filename, NONE, NULL, NULL);
        if (form == NULL)
        {
           kremove_dir(kgen_tmpdirname);
           return(FALSE);
        }

        /*
         *  generate the form information structure in file "form_info.h"
         */
        result = (/*-- form_info.h --*/
	          kgen_gui_include_file(form, object, oname, levels)

		  /*-- form_init.c --*/
		  && kgen_gui_init_forminfo(form, object, oname)

		  /*-- form_info.c --*/
		  && kgen_gui_get_forminfo(form, object, oname, levels)

		  /*-- form_drv.c --*/
		  && kgen_gui_driver(form, object, oname, levels));

	kvf_destroy_form(form);
	kremove_dir(kgen_tmpdirname);
	kfree(kgen_tmpdirname);

	datestamp = kcms_get_date();
	kcms_set_attribute(object, KCMS_DATE, NULL, NULL, datestamp);
	kfree(datestamp);

	return result;
}
