/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>     Routines to generate GUI code for xvroutines      <<<<
   >>>>                 in form_drv.c                         <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>              kgen_gui_driver()                        <<<<
   >>>>              kgen_gui_selection_debug()               <<<<
   >>>>   Static:                                             <<<<
   >>>>              gen_subform_driver()                     <<<<
   >>>>              gen_pane_driver()                        <<<<
   >>>>              gen_selection_code()                     <<<<
   >>>>   Public:                                             <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"  

static int 
gen_subform_driver  PROTO((kobject, char *, ksubform *,
			   int, char ***, int *));
static int 
gen_pane_driver     PROTO((kobject, kcontrol *, char *, 
			   int, char ***, int *));
static int 
gen_selection_code  PROTO((kfile *, kfile *, kfile *, int, kselection *, char *,
			   char *, int, int *, char *, int, char ***, int *));


/*------------------------------------------------------------
|
|  Routine Name: kgen_gui_driver
|
|       Purpose: This routine modifies the library file of the
|		 program (created by ghostwriter) to contain the 
|                main GUI driver for an xvroutine.
|
|         Input: form         - pointer to the form tree
|                program      - program object being generated
|                program_name - name of program being generated
|		 levels       - level of extraction (1, 2, or 3)
|
|        Output: Returns TRUE on success, FALSE on failure
|          Date: May 11, 1992
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/

int kgen_gui_driver(
   kform    *form,
   kobject  object,
   char     *program_name,
   int      levels)
{
        kstring routine    = "kgen_gui_driver()";
	int     force_flag = FALSE;
	int     priv_num   = 0;
	int     func_num   = 0;
	int  mut_excl_subforms, first, prev_do_file, mastercode_warranted;
	char temp[KLENGTH], do_filename[KLENGTH]; 
	char subpath[KLENGTH];
	char func_name[KLENGTH], purpose[KLENGTH], hdr_filename[KLENGTH];
	char *form_var, *subform_var;
	char **priv_routines = NULL, **func_routines = NULL;
	unsigned long  update_flag;
	kfile      *file = NULL, *do_file = NULL; 
	kfile      *func_file = NULL; 
	ksubform   *subform;
	kselection *selection;
	kstring     topsrc    = NULL;
	kobject    file_object;
	int         gen_debug = FALSE;

	/* 
	 * create & open the temporary file which will have the 
         * first part of the main driver
	 */
	ksprintf(temp, "%s/drv_master", kgen_tmpdirname);
	if ((file = kfopen(temp, "w"))== NULL)
	{
	    kerror(KCODEGEN, "kgen_gui_driver", 
		   "Could not create tmp file '%s'", temp);
	    return(FALSE);
	}

	if (!kcms_get_attributes(object,
				 KCMS_CMOBJ_TOPSRC,    &topsrc,
				 KCMS_CMOBJ_UPDATE_DB, &update_flag,
				 KCMS_END)
	    || !kcms_query_bit(object, KCMS_CMOBJ_FLAGS, KCMS_BIT_CMOBJ_FORCE,
			       &force_flag)
	    || !kcms_query_bit(object, KCMS_CMOBJ_FLAGS,
			       KCMS_BIT_CMOBJ_GENDEBUG, &gen_debug))
	   return FALSE;

	if (!kcms_get_attribute(object, KCMS_CMOBJ_UPDATE_DB, &update_flag))
	    update_flag = KCMS_UPDATE_NONE;

	/* read the StartForm def'n & get FormInfo variable program_name */
       	form_var = ktoken_to_string(form->var_token);

	/*
	 * start list of routines for file header
	 */
	ksprintf(func_name, "run_%s", form_var);
	priv_routines = (char **) kcalloc(1, sizeof(char *));
        priv_routines[0] = kstrdup(func_name);
        priv_num = 1;

	/* 
	 * print private routine header
         */
	ksprintf(purpose, "Main GUI Driver for %s", program_name);
	ksprintf(temp, "conductor -oname %s -l %d", program_name, levels);
	kgen_privsrc_hdr(file, func_name, purpose, "None", 
			 "Returns TRUE on success, FALSE on failure",
			 temp, NULL);

	kfprintf(file, "/* ARGSUSED */\n");
	kfprintf(file, "void run_%s(\n", form_var);
	kfprintf(file, "     kform    *form,\n");
	kfprintf(file, "     ksubform *subform,\n");
	kfprintf(file, "     kaddr    client_data)\n");
	
       	/* write out beginning bracket & declarations */
       	kfprintf(file, "{\n"); 
	kfprintf(file, "\t/*\n\t * GUI info structure passed in as client_data \n\t */\n");
	kfprintf(file, "\tgui_info_struct *master_info = (gui_info_struct *) client_data;\n\n");
	kfprintf(file, "\t/*\n\t * Get information from the forms\n\t */\n");
	kfprintf(file, "\t_xvf_get_%s(master_info);\n\n", form_var);

        kfprintf(file, "\tif (form->quit)\n\t{\n");
	kfprintf(file, "\t    xvf_destroy_allforms();\n");
	kfprintf(file, "\t    _xvf_free_%s(master_info);\n", form_var);
	kfprintf(file, "\t    return;\n\t}\n\n");

	first = TRUE;

	if (form->master != NULL)
	{
	    kvf_get_attribute(form->master->back_kformstruct,
			      KVF_ME_SUBFORMS, &mut_excl_subforms);
	}

	/*
	 *  generate code for master action buttons
	 */
	if (form->master != NULL)
	{
	    subform = form->master->subform_list;
	    selection = form->master->sel_list;
	    if (!(kvf_gui_item_exists(form->master->sel_list,KUIS_QUIT)))
	    {
		errno = KUIS_LOGIC;
		kerror(KCODEGEN, "kgen_gui_driver",
		       "Please add a quit button to the Master Form definition of your %s.form file; unable to generate driver properly without one. Aborting creation of GUI driver(s).", program_name);
		kfclose(file);
		return(FALSE);
	    }
	
	}
	else 
	{
	    subform = form->subform;
	    if (subform->guidepane != NULL)
	    {
		if (subform->guidepane->sel_list != NULL)
		{
	           if (!(kvf_gui_item_exists(subform->guidepane->sel_list,KUIS_QUIT)))
	            {
		        errno = KUIS_LOGIC;
			kerror(KCODEGEN, "kgen_gui_driver",
			       "Please add a quit button to the GuidePane definition of your %s.form file; unable to generate driver properly without one. Aborting creation of GUI driver(s).", program_name);
                        kfclose(file);
		        return(FALSE);
	            }
		}
	    }
	    else 
	    {
	        if (!(kvf_gui_item_exists(subform->guide->pane->sel_list,KUIS_QUIT)))
	        {
		    errno = KUIS_LOGIC;
		    kerror(KCODEGEN, "kgen_gui_driver", 
		           "Please add a quit button to the Pane definition of your %s.form file; unable to generate driver properly without one. Aborting creation of GUI driver(s).", program_name);
                    kfclose(file);
		    return(FALSE);
	        }
	    }
	    selection = NULL;
	}

	first = TRUE;
	mastercode_warranted = kgen_selection_codegen_warranted(selection);
	if (mastercode_warranted)
	{
	    /* 
	     * create & open the "func_tmp" file which will have 
             * the pane functionality routines 
	     */
	    ksprintf(do_filename, "%s/do_%s.c", kgen_fulltopsrc, form_var);
    
	    do_file = kfopen(do_filename, "r");
	    if (do_file == NULL)
		prev_do_file = FALSE;
	    else prev_do_file = TRUE;

	    ksprintf(temp, "%s/func_tmp", kgen_tmpdirname);
	    if ((func_file = kfopen(temp, "w"))== NULL)
	    {
	            kerror(KCODEGEN, "kgen_gui_driver", 
		           "Could not create tmp file '%s'", temp);
		    kfclose(file);
	            return(FALSE);
	    }

	    func_routines = (char **) kcalloc(1, sizeof(char *));
	    ksprintf(temp, "gui_info_struct");
	    if (!(gen_selection_code(file, func_file, do_file, KMASTER, 
				     selection, temp, form_var, TRUE, &first, 
				     "\t    ", gen_debug,
				     &func_routines, &func_num)))
	    {
		kfclose(file);
		kfclose(func_file);
		return(FALSE);
	    }

            if (!(gen_selection_code(file, func_file, do_file, KMASTER, 
				     selection, temp, form_var, FALSE, &first, 
				     "\t    ", gen_debug,
				     &func_routines, &func_num)))
	    {
		kfclose(file);
		kfclose(func_file);
		return(FALSE);
	    }
	    kfclose(func_file);

	    if (prev_do_file)
	    {
		ksprintf(temp, "cat %s/func_tmp >> %s/do_%s.c", 
			 kgen_tmpdirname, kgen_fulltopsrc, form_var);
	        ksystem(temp);
	    }
	    else 
	    {
	        ksprintf(temp, "Functionality routines for master %s", form_var);
		ksprintf(hdr_filename, "%s/func_hdr", kgen_tmpdirname);
	        kgen_gui_file_hdr(hdr_filename, object,
				 temp,  func_routines, func_num);

		ksprintf(temp, "%s/do_%s.c", topsrc, form_var);
                file_object = kcms_create_fileobj(object, temp, NULL,
						  KCMS_FOBJ_TYPE_SRC,
						  KCMS_FOBJ_SUBTYPE_C,
                                                  KCMS_FOBJ_GEN_DOFILE,
                                                  KCMS_FOBJ_ACCESS_RDWR);
                if (file_object == NULL) return(FALSE);
		ksprintf(temp, "cat %s/func_hdr %s/func_tmp > %s/do_%s.c", 
		         kgen_tmpdirname, kgen_tmpdirname, kgen_fulltopsrc, 
			 form_var);
	        ksystem(temp);
		kannounce(KCODEGEN, routine, "done generating 'do_%s.c'",
			  form_var);
	    }
	    ksprintf(temp,  "%s/func_tmp", kgen_tmpdirname);
	    kunlink(temp);
	}

	/*
	 *  generate code for subforms
	 */
	while (subform != NULL)
	{
            if (!(kgen_subform_codegen_warranted(subform)))
	    {
	        subform = subform->next;
                continue;
	    }

	    if (subform->type == KUIS_SUBFORMBUTTON) 
	    {
                if (!(gen_subform_driver(object, 
		   	                 program_name, subform, levels, 
				         &priv_routines, &priv_num)))
		{
		     kfclose(file);
		     kfclose(func_file);
                     return(FALSE); 
		}
	    }
	    subform = subform->next;
	}

	/*
	 *  generate main GUI driver
	 */
	if (form->master != NULL) 
	    subform = form->master->subform_list;
	else subform = form->subform;
	
	while (subform != NULL)
	{
	    if (!(kgen_subform_codegen_warranted(subform)))
	    {
		subform = subform->next;
		continue;
	    }

            subform_var = ktoken_to_string(subform->var_token);

            kfprintf(file, "\t/*\n");
            kfprintf(file, "\t * action came from the ");
            kfprintf(file, "'%s' subform\n", subform_var);
            kfprintf(file, "\t */\n");

            if (mut_excl_subforms)
		kfprintf(file, "\telse if (master_info->%s_selected)\n",
                          subform_var);
            else kfprintf(file, "\tif (master_info->%s_selected)\n",
                         subform_var);
            kfprintf(file, "\t    run_%s(master_info->%s);\n",
                     subform_var, subform_var);
	    subform = subform->next;
	}
	kfprintf(file, "\n\txvf_clear_selections(form);\n"); 
       	kfprintf(file, "\n}\n\n");
        kfclose(file);

	ksprintf(temp, "GUI Drivers for '%s'", program_name);
	ksprintf(hdr_filename, "%s/drv_hdr", kgen_tmpdirname);
	kgen_gui_file_hdr(hdr_filename, object,
			 temp, priv_routines, priv_num);
	ksprintf(temp, "%s/form_drv.c", topsrc);
	if (kaccess(temp, F_OK) != 0)
        {
            file_object = kcms_create_fileobj(object, temp, NULL,
						KCMS_FOBJ_TYPE_SRC,
						KCMS_FOBJ_SUBTYPE_C,
						KCMS_FOBJ_GEN_COND,
						KCMS_FOBJ_ACCESS_RDWR);
            if (file_object == NULL) return(FALSE);
        }

	ksprintf(subpath, "%s/drv_subform", kgen_tmpdirname);
	if (kaccess(subpath, R_OK) == 0)
	    ksprintf(temp, 
		"cat %s/drv_hdr %s/drv_master %s/drv_subform > %s/form_drv.c", 
		kgen_tmpdirname, kgen_tmpdirname, kgen_tmpdirname,
		kgen_fulltopsrc);
	else
	    ksprintf(temp, 
		"cat %s/drv_hdr %s/drv_master > %s/form_drv.c", 
		kgen_tmpdirname, kgen_tmpdirname, kgen_fulltopsrc);

	if (force_flag
	    || (update_flag & KCMS_UPDATE_NEW) == KCMS_UPDATE_NEW
	    || koverwrite(kget_notify(), "form_drv.c"))
	{
	    ksystem(temp);
	    kannounce(KCODEGEN, routine, "done generating 'form_drv.c'");
	}

	karray_free(func_routines, func_num, NULL); 
	karray_free(priv_routines, priv_num, NULL);

        return(TRUE);

}  /* end  kgen_gui_driver */
        


/*------------------------------------------------------------
|
|  Routine Name: gen_subform_driver
|
|       Purpose: Generates subform drivers for each subform of the GUI.
|
|         Input: object      - program object
|		 program_name - name of program being generated
|                subform      - pointer to the subform
|                levels       - level of extraction [-l {1,2,3}]
|
|        Output: Returns TRUE on success, FALSE on failure
|          Date: May 11, 1992
|    Written By:  Danielle Argiro
| Modifications:
|
------------------------------------------------------------*/
static int
gen_subform_driver(
   kobject  object,
   char     *program_name,
   ksubform *subform,
   int      levels,
   char     ***priv_routines,
   int      *priv_num)
{
        kstring    routine   = "gen_subform_driver()";
	kstring    topsrc    = NULL;
        kstring    pane_var;
	char       **func_routines = NULL; 
	kguide     *guide;
	kselection *selection;
	kobject    file_object;
	int        first, func_num = 0, prev_do_file; 
	int        gpcode_warranted, panecode_warranted;
	kfile      *file = NULL, *func_file = NULL, *do_file = NULL;
	char       temp[KLENGTH],    input[KLENGTH],   do_filename[KLENGTH]; 
	char       purpose[KLENGTH], func_name[KLENGTH], hdr_filename[KLENGTH];
        char       *form_var, *subform_var;
	int         gen_debug;


	if (!kcms_get_attribute(object, KCMS_CMOBJ_TOPSRC, &topsrc)
	    || !kcms_query_bit(object, KCMS_CMOBJ_FLAGS,
			       KCMS_BIT_CMOBJ_GENDEBUG, &gen_debug))
	   return FALSE;

	/* 
	 * create & open the "subform_info" file which will have the 
	 * "form_info" structure definition 
	 */
	ksprintf(temp, "%s/drv_subform", kgen_tmpdirname);
	if ((file = kfopen(temp, "a"))== NULL)
	{
	        kerror(KCODEGEN, "gen_subform_driver", 
		       "Could not create tmp file '%s'", temp);
		return(FALSE);
	}

	/* 
	 * print private source header
         */
	form_var = ktoken_to_string(subform->back_form->var_token);
	subform_var = ktoken_to_string(subform->var_token);
	ksprintf(func_name, "run_%s", subform_var);
	ksprintf(purpose, "GUI Driver for subform '%s'", subform_var);
	ksprintf(temp, "conductor -program_name %s -l %d", program_name, levels);
	ksprintf(input, "form      - pointer to the form tree\n|                %s_info - pointer to %s_%s struct", subform_var, form_var, subform_var);
	kgen_privsrc_hdr(file, func_name, purpose, input, 
			 "None", temp, NULL);

	*priv_routines = (char **) krealloc(*priv_routines,(*priv_num+1)
                                                      *sizeof(char *));
        (*priv_routines)[*priv_num] = kstrdup(func_name);
        (*priv_num)++;

       	/* write out program program_name & argument list */
       	kfprintf(file, "void run_%s(\n", subform_var);
	kfprintf(file, "     %s_%s *%s_info)\n", form_var, 
		 subform_var, subform_var);
       
       	/* write out beginning bracket & declarations */
       	kfprintf(file, "{\n\n"); 

	first = TRUE;

	if (levels != 1)  
	    kfprintf(file, "\t_xvf_get_%s(%s_info);\n\n", 
			 subform_var, subform_var);

	/*
	 * generate code for subform action buttons
	 */
	if (subform->guidepane != NULL)
	{
	    guide = subform->guidepane->guide_list;
	    selection = subform->guidepane->sel_list;
	}
	else 
	{
	    guide = subform->guide;
	    selection = NULL;
	}

	gpcode_warranted = kgen_selection_codegen_warranted(selection);
        if (gpcode_warranted)
	{
	    /* 
	     * create & open the "func_tmp" file which will have 
             * the pane functionality routines 
	     */
	    ksprintf(do_filename, "%s/do_%s.c", kgen_fulltopsrc, subform_var);

	    do_file = kfopen(do_filename, "r");
	    if (do_file == NULL)
		prev_do_file = FALSE;
	    else prev_do_file = TRUE;

	    ksprintf(temp, "%s/func_tmp", kgen_tmpdirname);
	    if ((func_file = kfopen(temp, "w"))== NULL)
	    {
	        kerror(KCODEGEN, "kgen_gui_driver", 
		       "Could not create tmp file '%s'", temp);
	        return(FALSE);
	    }

	    ksprintf(temp, "%s_%s", form_var, subform_var);
            if (!(gen_selection_code(file, func_file, do_file, KSUBFORM, 
				selection, temp, subform_var, TRUE, 
				&first, "\t", gen_debug,
				&func_routines, &func_num)))
		return(FALSE);

            if (!(gen_selection_code(file, func_file, do_file, KSUBFORM, 
				selection, temp, subform_var, FALSE, 
				&first, "\t", gen_debug,
				&func_routines, &func_num)))
		return(FALSE);
	    kfclose(func_file);

	    if (prev_do_file)
	    {
	        ksprintf(temp, "cat %s/func_tmp >> %s/do_%s.c", 
		 	 kgen_tmpdirname, kgen_fulltopsrc, subform_var);
	        ksystem(temp);
	    }
	    else 
	    {
	        ksprintf(temp, "Functionality routines for guidepane %s", 
			    subform_var);
		ksprintf(hdr_filename, "%s/func_hdr", kgen_tmpdirname);
	        kgen_gui_file_hdr(hdr_filename, object,
				 temp, func_routines, func_num);
		ksprintf(temp, "%s/do_%s.c", topsrc, subform_var);
                file_object = kcms_create_fileobj(object, temp, NULL,
						  KCMS_FOBJ_TYPE_SRC,
						  KCMS_FOBJ_SUBTYPE_C,
                                                  KCMS_FOBJ_GEN_DOFILE,
                                                  KCMS_FOBJ_ACCESS_RDWR);
                if (file_object == NULL) return(FALSE);
		ksprintf(temp, "cat %s/func_hdr %s/func_tmp > %s/do_%s.c", 
			 kgen_tmpdirname, kgen_tmpdirname, 
			 kgen_fulltopsrc, subform_var);
	        ksystem(temp);
		kannounce(KCODEGEN, routine, "done generating 'do_%s.c'", 
		          subform_var);
	    }
	    ksprintf(temp,  "%s/func_tmp", kgen_tmpdirname);
	    kunlink(temp);
	}

	/*
         * generate code for guide buttons
	 */
        while (guide != NULL)
        {
	    panecode_warranted = kgen_selection_codegen_warranted(guide->pane->sel_list);
	    if (panecode_warranted)
	    {
            pane_var = ktoken_to_string(guide->pane->var_token);
	    kfprintf(file, "\t/*\n");
	    kfprintf(file, "\t * action came from the ");
	    kfprintf(file, "'%s' pane\n", pane_var);
	    kfprintf(file, "\t */\n");

	    if (first == TRUE)
		kfprintf(file, "\tif (%s_info->%s_selected)\n",
			            subform_var, pane_var);
	    else
		kfprintf(file, "\telse if (%s_info->%s_selected)\n",
			            subform_var, pane_var);

	    first = FALSE;
	    kfprintf(file, "\t    run_%s(%s_info->%s);\n\n",
				pane_var, subform_var, pane_var, levels);
	    if (!(gen_pane_driver(object, guide->pane,
				  program_name, levels, priv_routines, priv_num)))
                    return(FALSE);

	    }
	    guide = guide->next;
	} 

        kfprintf(file, "\n}   /* end run_%s */\n\n\n\n", subform_var);
	kfclose(file);

	ksprintf(temp, "%s/drv_pane", kgen_tmpdirname);
	if (kaccess(temp, R_OK) == 0)
	{
	    ksprintf(temp, "cat %s/drv_pane >> %s/drv_subform",
	             kgen_tmpdirname, kgen_tmpdirname);
	    ksystem(temp);
	}

	ksprintf(temp, "%s/drv_pane", kgen_tmpdirname);
	kunlink(temp);

	karray_free(func_routines, func_num, NULL); 
	return(TRUE);

} /* end gen_subform_driver */
        		
/*------------------------------------------------------------
|
|  Routine Name: gen_pane_driver
|
|       Purpose: Generates pane drivers for each pane of the GUI.
|
|         Input: pane         - pointer to the pane
|                program_name - program_name of program being generated
|                levels       - level number input by user
|                priv_routines - keeps track of all routine program_names
|                priv_num     - number of private routines
|
|        Output: Returns TRUE on success, FALSE on failure
|          Date: May 11, 1992
|    Written By:  Danielle Argiro
| Modifications:
|
------------------------------------------------------------*/

static int gen_pane_driver(
   kobject  object,
   kcontrol *pane,
   char     *program_name,
   int      levels,
   char     ***priv_routines,
   int      *priv_num)
{
        kstring    routine   = "gen_pane_driver()";
	kstring    topsrc    = NULL;
	kfile	  *file      = NULL;
	kfile     *func_file = NULL;
	kfile     *do_file = NULL;
	int        prev_do_file, first, func_num = 0;
	char       temp[KLENGTH],    input[KLENGTH],  do_filename[KLENGTH]; 
	char       purpose[KLENGTH], func_name[KLENGTH], hdr_filename[KLENGTH];
	char      **func_routines = NULL;
	kobject    file_object;
	char      *subform_var, *pane_var;
	int         gen_debug     = FALSE;


	if (!kcms_get_attribute(object, KCMS_CMOBJ_TOPSRC, &topsrc)
	    || !kcms_query_bit(object, KCMS_CMOBJ_FLAGS,
			       KCMS_BIT_CMOBJ_GENDEBUG, &gen_debug))
	   return FALSE;

	/* 
	 * create & open the "drv_pane" file which will have the pane drivers
	 */
	ksprintf(temp, "%s/drv_pane", kgen_tmpdirname);
	if ((file = kfopen(temp, "a"))== NULL)
	{
	    kerror(KCODEGEN, "gen_pane_driver", 
		   "Could not create tmp file 'pane_info'");
	    return(FALSE);
	}

	/* 
	 * print private file header
         */
	pane_var = ktoken_to_string(pane->var_token);
	subform_var = ktoken_to_string(pane->back_subform->var_token);
	ksprintf(func_name, "run_%s", pane_var);
	ksprintf(purpose, "GUI Driver for pane '%s'", pane_var);
	ksprintf(temp, "conductor -program_name %s -l %d", program_name, levels);
	ksprintf(input, "form - pointer to the form tree\n|                %s_info - pointer to %s_%s struct", pane_var, subform_var, pane_var);
	kgen_privsrc_hdr(file, func_name, purpose, input, 
			 "None", temp, NULL);

	*priv_routines = (char **) krealloc(*priv_routines, (*priv_num+1)
                                            * sizeof(char *));
        (*priv_routines)[*priv_num] = kstrdup(func_name);
        (*priv_num)++;

       	/* write out program program_name & argument list */
       	kfprintf(file, "void run_%s(\n", pane_var);
	kfprintf(file, "     %s_%s *%s_info)\n\n", 
		 subform_var, pane_var, pane_var);

       	/* write out beginning bracket & declarations */
       	kfprintf(file, "{\n\n"); 

	if (levels == 3)
	    kfprintf(file, "\t_xvf_get_%s(%s_info);\n\n", 
			pane_var, pane_var);
	

	/* 
	 * create & open the "func_tmp" file which will have 
         * the pane functionality routines 
	 */
	ksprintf(do_filename, "%s/do_%s.c", kgen_fulltopsrc, pane_var);
#if 0
	if (kaccess(do_filename, R_OK) != 0)
	   isnewfile = TRUE;
#endif
	do_file = kfopen(do_filename, "r");
	if (do_file == NULL)
	    prev_do_file = FALSE;
	else prev_do_file = TRUE;

	ksprintf(temp, "%s/func_tmp", kgen_tmpdirname);
	if ((func_file = kfopen(temp, "w"))== NULL)
	{
	    kerror(KCODEGEN, "gen_pane_driver", 
		   "Could not create tmp file '%s'", temp);
	    return(FALSE);
	}

	first = TRUE;
	ksprintf(temp, "%s_%s", subform_var, pane_var);
        if (!(gen_selection_code(file, func_file, do_file, KPANE, 
				 pane->sel_list, temp, pane_var, TRUE, &first,
				 "\t", gen_debug, &func_routines, &func_num)))
	{
	    return(FALSE);
	}

        if (!(gen_selection_code(file, func_file, do_file, KPANE, 
				 pane->sel_list, temp, pane_var, 
				 FALSE, &first, "\t", gen_debug,
				 &func_routines, &func_num)))
	{
	    return(FALSE);
	}

	kfclose(func_file);

	
	if (prev_do_file)
	{
	    ksprintf(temp, "cat %s/func_tmp >> %s/do_%s.c",
	  	     kgen_tmpdirname, kgen_fulltopsrc, pane_var);
	    ksystem(temp);
	}
	else 
	{
	    ksprintf(temp, "Functionality routines for pane %s", pane_var);
	    ksprintf(hdr_filename, "%s/func_hdr", kgen_tmpdirname);
	    kgen_gui_file_hdr(hdr_filename, object,
			     temp, func_routines, func_num);
	    ksprintf(temp, "%s/do_%s.c", topsrc, pane_var);
            file_object = kcms_create_fileobj(object, temp, NULL,
					      KCMS_FOBJ_TYPE_SRC,
					      KCMS_FOBJ_SUBTYPE_C,
                                              KCMS_FOBJ_GEN_DOFILE,
                                              KCMS_FOBJ_ACCESS_RDWR);
            if (file_object == NULL) return(FALSE);
	    ksprintf(temp, "cat %s/func_hdr %s/func_tmp > %s/do_%s.c", 
		     kgen_tmpdirname, kgen_tmpdirname, kgen_fulltopsrc, 
		     pane_var);
	    ksystem(temp);
	    kannounce(KCODEGEN, routine, "done generating 'do_%s.c'",
		      pane_var);
	}
	ksprintf(temp,  "%s/func_tmp", kgen_tmpdirname);
	kunlink(temp);
	kfprintf(file, "\n\n}\n\n\n");
	kfclose(file);
	return(TRUE);
	
}  /* gen_pane_driver */
        
        	
        
/*------------------------------------------------------------
|
|  Routine Name: gen_selection_code
|
|       Purpose: Generates segments of code for using each
|                "live" selection and/or button in the GUI.
|
|         Input: file         - open stream to temp file w/ GUI drivers in 
|                               which we are generating references to functions
|                func_file    - open stream to temp file in which we are 
|                               generating the functions themselves
|                do_file      - open stream to previously created "do_xxx.c" 
|                               file or NULL if there wasn't one
|                location     - KMASTER, KSUBFORM, or KPANE
|                selection    - pointer to list of selections
|                info_type    - declared type of Information structure
|                control_var  - program_name of the variable on the 
|                               -F, -M, or -P controlling UIS line
|                opt_flag     - doing optional (TRUE) or required (FALSE) sels
|                first        - TRUE if this is the first time called
|                               for the control pane
|                indent       - string with whitespace for indenting
|                               warranted (as it would not be on a pane with
|                               no action buttons & no live selections)
|		 gen_debug    - TRUE if debugging statements should be
|				generated.
|
|        Output: Returns TRUE on success, FALSE on failure
|                func_routines- array of program_names for functionality routines
|                func_num     - size of func_routines[] array
|
|          Date: May 11, 1992
|    Written By: Danielle Argiro
| Modifications:
|
------------------------------------------------------------*/

static int gen_selection_code(
   kfile      *file,
   kfile      *func_file,
   kfile      *do_file,
   int        location,
   kselection *selection,
   char       *info_type,
   char       *control_var,
   int        opt_flag,
   int        *first,
   char       *indent,
   int         gen_debug,
   char       ***func_routines,
   int        *func_num)
{
	char      search_key[KLENGTH];
        char      inform_var[KLENGTH];
	int       live, optional, doubleclick, already_gend;
	char      *info_var, *variable, *tmp = NULL;

	if (location == KMASTER)
	{
	    ksprintf(inform_var, "master");
            info_var = inform_var;
	}
	else info_var = control_var;

	while (selection != NULL)
       	{
	      already_gend = -1;
       	      switch(selection->type) {
        
	        case KUIS_MASTERACTION:
		     if (opt_flag == FALSE)
		     {
			 variable = ktoken_to_string(selection->var_token);
                         kgen_gui_selection_comment(file, "master action button", 
					   KGEN_GUI_BUTTON, variable, indent);
		         if (*first)
		             kfprintf(file, "%sif (%s_info->%s)\n", indent,
			              info_var, variable);
		         else kfprintf(file, "%selse if (%s_info->%s)\n", 
				       indent, info_var, variable);
	                 *first = FALSE;

	  	         kfprintf(file, "%s    %s_%s(%s_info);\n", indent,
				  control_var, variable, info_var);

			 if (do_file != NULL)
			 {
			     ksprintf(search_key, 
				     "[|*]\\s*Routine Name:\\s*%s_%s", 
				     control_var, variable);
			     krewind(do_file);
			     already_gend = kparse_file_search(do_file, 
					 	search_key, KIGNORE_CASE, &tmp);
			     kfree(tmp);
			 }
			 if ((do_file == NULL) || (already_gend != KPARSE_OK))
		             kgen_gui_selection_function(func_file, selection, 
				 location, info_type, control_var, 
				 variable, func_routines, func_num, 
				 FALSE, gen_debug);
		     }
		     break;

	        case KUIS_SUBFORMACTION:
		     if (opt_flag == FALSE)
		     {
			 variable = ktoken_to_string(selection->var_token);
                         kgen_gui_selection_comment(file, "subform action button", 
					   KGEN_GUI_BUTTON, variable, indent);
		         if (*first == TRUE)
		             kfprintf(file, "%sif (%s_info->%s)\n", indent,
			              info_var, variable);
		         else kfprintf(file, "%selse if (%s_info->%s)\n", 
					indent, info_var, variable);
		         *first = FALSE;

	  	         kfprintf(file, "%s    %s_%s(%s_info);\n", indent,
				  control_var, variable, info_var);

			 if (do_file != NULL)
			 {
			     ksprintf(search_key, 
				     "[|*]\\s*Routine Name:\\s*%s_%s", 
				     control_var, variable);
			     krewind(do_file);
			     already_gend = kparse_file_search(do_file, search_key, 
						 	KIGNORE_CASE, &tmp);
			     kfree(tmp);
			 }
			 if ((do_file == NULL) || (already_gend != KPARSE_OK))
		             kgen_gui_selection_function(func_file, selection, 
				  location, info_type, control_var, variable, 
				  func_routines, func_num, FALSE, gen_debug);
		     }
		     break;

	      case KUIS_INPUTFILE:
		   kvf_get_attributes(selection->back_kformstruct,
				      KVF_LIVE,     &live,
				      KVF_OPTIONAL, &optional,
				      NULL); 
		   if ((optional == opt_flag) && (live))
		   {
		       variable = ktoken_to_string(selection->var_token);
                       kgen_gui_selection_comment(file, "input file", 
					          live, variable, indent);
		       if (*first) 
		       {
			   kfprintf(file, "%s", indent);
			   *first = FALSE;
		       }
		       else kfprintf(file, "%selse ", indent);

		       if ((optional) && (opt_flag))
		       {
		           kfprintf(file, "if ((%s_info->%s_selected) ", 
				    info_var, variable);
		           kfprintf(file, " && (%s_info->%s_optsel))\n", 
				    info_var, variable);
		       }
		       else kfprintf(file, "if (%s_info->%s_selected)\n",
				     info_var, variable);

		       kfprintf(file, "%s{\n", indent);
	  	       kfprintf(file, "%s    %s_%s(%s_info);\n", indent,
				control_var, variable, info_var);
		       kfprintf(file, "%s    %s_info->%s_selected = FALSE;\n",
			        indent, info_var, variable);
		       kfprintf(file, "%s}\n", indent);

		       if (do_file != NULL)
		       {
			     ksprintf(search_key, 
				     "[|*]\\s*Routine Name:\\s*%s_%s", 
				     control_var, variable);
			     krewind(do_file);
			     already_gend = kparse_file_search(do_file, 
					search_key, KIGNORE_CASE, &tmp);
			     kfree(tmp);
		        }
		        if ((do_file == NULL) || (already_gend != KPARSE_OK))
		           kgen_gui_selection_function(func_file, selection, 
				location, info_type, control_var, variable, 
				func_routines, func_num, FALSE, gen_debug);
		   }
       		   break;

       	      case KUIS_OUTPUTFILE:
		   kvf_get_attributes(selection->back_kformstruct,
				      KVF_LIVE,     &live,
				      KVF_OPTIONAL, &optional,
				      NULL);
		   if ((optional == opt_flag) && (live))
	 	   {
		       variable = ktoken_to_string(selection->var_token);
                       kgen_gui_selection_comment(file, "output file", 
					          live, variable, indent);
		       if (*first) 
		       {
			   kfprintf(file, "%s", indent);
			   *first = FALSE;
		       }
		       else kfprintf(file, "%selse ", indent);

		       if ((optional) && (opt_flag))
		       {
		           kfprintf(file, "if ((%s_info->%s_selected) ", 
				    info_var, variable);
		           kfprintf(file, " && (%s_info->%s_optsel))\n", 
				    info_var, variable);
		       }
		       else kfprintf(file, "if (%s_info->%s_selected)\n",
				     info_var, variable);

		       kfprintf(file, "%s{\n", indent);
	  	       kfprintf(file, "%s    %s_%s(%s_info);\n", indent,
				control_var, variable, info_var);
		       kfprintf(file, "%s    %s_info->%s_selected = FALSE;\n",
			        indent, info_var, variable);
		       kfprintf(file, "%s}\n", indent);

		       if (do_file != NULL)
		       {
			     ksprintf(search_key, 
				     "[|*]\\s*Routine Name:\\s*%s_%s", 
				     control_var, variable);
			     krewind(do_file);
			     already_gend = kparse_file_search(do_file, search_key, 
						 	KIGNORE_CASE, &tmp);
			     kfree(tmp);
		       }
		       if ((do_file == NULL) || (already_gend != KPARSE_OK))
		           kgen_gui_selection_function(func_file, selection, 
				location, info_type, control_var, variable, 
				func_routines, func_num, FALSE, gen_debug);
		   }
       		   break;

      	      case KUIS_INTEGER:
		   kvf_get_attributes(selection->back_kformstruct,
				      KVF_LIVE,     &live,
				      KVF_OPTIONAL, &optional,
				      NULL); 
		   if ((optional == opt_flag) && (live))
	 	   {
		       variable = ktoken_to_string(selection->var_token);
                       kgen_gui_selection_comment(file, "integer", 
					          live, variable, indent);
		       if (*first) 
		       {
			   kfprintf(file, "%s", indent);
			   *first = FALSE;
		       }
		       else kfprintf(file, "%selse ", indent);

		       if ((optional) && (opt_flag))
		       {
		           kfprintf(file, "if ((%s_info->%s_selected) ", 
				    info_var, variable);
		           kfprintf(file, " && (%s_info->%s_optsel))\n", 
				    info_var, variable);
		       }
		       else kfprintf(file, "if (%s_info->%s_selected)\n",
				     info_var, variable);

		       kfprintf(file, "%s{\n", indent);
	  	       kfprintf(file, "%s    %s_%s(%s_info);\n", indent,
				control_var, variable, info_var);
		       kfprintf(file, "%s    %s_info->%s_selected = FALSE;\n",
			        indent, info_var, variable);
		       kfprintf(file, "%s}\n", indent);

		       if (do_file != NULL)
		       {
			     ksprintf(search_key, 
				     "[|*]\\s*Routine Name:\\s*%s_%s", 
				     control_var, variable);
			     krewind(do_file);
			     already_gend = kparse_file_search(do_file, 
						search_key, KIGNORE_CASE, &tmp);
			     kfree(tmp);
		       }
		       if ((do_file == NULL) || (already_gend != KPARSE_OK))
		           kgen_gui_selection_function(func_file, selection, 
				location, info_type, control_var, variable, 
				func_routines, func_num, FALSE, gen_debug);
		   }
       		   break;

       	      case KUIS_FLOAT:
       	      case KUIS_DOUBLE:
		   kvf_get_attributes(selection->back_kformstruct,
				      KVF_LIVE,     &live,
				      KVF_OPTIONAL, &optional,
				      NULL); 
		   if ((optional == opt_flag) && (live))
	 	   {
		       variable = ktoken_to_string(selection->var_token);
		       if (selection->type == KUIS_FLOAT)
                           kgen_gui_selection_comment(file, "float", live, 
					              variable, indent);
		       else kgen_gui_selection_comment(file, "double", live, 
					               variable, indent);
		       if (*first) 
		       {
			   kfprintf(file, "%s", indent);
			   *first = FALSE;
		       }
		       else kfprintf(file, "%selse ", indent);

		       if ((optional) && (opt_flag))
		       {
		           kfprintf(file, "if ((%s_info->%s_selected) ", 
				    info_var, variable);
		           kfprintf(file, " && (%s_info->%s_optsel))\n", 
				    info_var, variable);
		       }
		       else kfprintf(file, "if (%s_info->%s_selected)\n",
				     info_var, variable);

		       kfprintf(file, "%s{\n", indent);
	  	       kfprintf(file, "%s    %s_%s(%s_info);\n", indent,
				control_var, variable, info_var);
		       kfprintf(file, "%s    %s_info->%s_selected = FALSE;\n",
			        indent, info_var, variable);
		       kfprintf(file, "%s}\n", indent);

		       if (do_file != NULL)
		       {
			     ksprintf(search_key, 
				     "[|*]\\s*Routine Name:\\s*%s_%s", 
				     control_var, variable);
			     krewind(do_file);
			     already_gend = kparse_file_search(do_file, 
						search_key, KIGNORE_CASE, &tmp);
			     kfree(tmp);
		       }
		       if ((do_file == NULL) || (already_gend != KPARSE_OK))
		           kgen_gui_selection_function(func_file, selection, 
				location, info_type, control_var, variable, 
				func_routines, func_num, FALSE, gen_debug);
		   }
       		   break;

       	      case KUIS_STRING:
       	      case KUIS_STRINGLIST:
		   kvf_get_attributes(selection->back_kformstruct,
				      KVF_LIVE,     &live,
				      KVF_OPTIONAL, &optional,
				      NULL); 
		   if ((optional == opt_flag) && (live))
	 	   {
		       variable = ktoken_to_string(selection->var_token);
                       kgen_gui_selection_comment(file, "string", 
					          live, variable, indent);
		       if (*first) 
		       {
			   kfprintf(file, "%s", indent);
			   *first = FALSE;
		       }
		       else kfprintf(file, "%selse ", indent);

		       if ((optional) && (opt_flag))
		       {
		           kfprintf(file, "if ((%s_info->%s_selected) ", 
				    info_var, variable);
		           kfprintf(file, " && (%s_info->%s_optsel))\n", 
				    info_var, variable);
		       }
		       else kfprintf(file, "if (%s_info->%s_selected)\n",
				     info_var, variable);

		       kfprintf(file, "%s{\n", indent);
	  	       kfprintf(file, "%s    %s_%s(%s_info);\n", indent,
				control_var, variable, info_var);
		       kfprintf(file, "%s    %s_info->%s_selected = FALSE;\n",
			        indent, info_var, variable);
		       kfprintf(file, "%s}\n", indent);

		       if (do_file != NULL)
		       {
			     ksprintf(search_key, 
				     "[|*]\\s*Routine Name:\\s*%s_%s", 
				     control_var, variable);
			     krewind(do_file);
			     already_gend = kparse_file_search(do_file, search_key, 
						 	KIGNORE_CASE, &tmp);
			     kfree(tmp);
		       }
		       if ((do_file == NULL) || (already_gend != KPARSE_OK))
		           kgen_gui_selection_function(func_file, selection, 
				location, info_type, control_var, variable, 
				func_routines, func_num, FALSE, gen_debug);
		   }
       		   break;

       	      case KUIS_LOGICAL:
		   kvf_get_attributes(selection->back_kformstruct,
				      KVF_LIVE,     &live,
				      KVF_OPTIONAL, &optional,
				      NULL); 
		   if ((optional == opt_flag) && (live))
	 	   {
		       variable = ktoken_to_string(selection->var_token);
                       kgen_gui_selection_comment(file, "logical", 
					          live, variable, indent);

		       if (*first) 
		       {
			   kfprintf(file, "%s", indent);
			   *first = FALSE;
		       }
		       else kfprintf(file, "%selse ", indent);

		       if ((optional) && (opt_flag))
		       {
		           kfprintf(file, "if ((%s_info->%s_selected) ", 
				    info_var, variable);
		           kfprintf(file, " && (%s_info->%s_optsel))\n", 
				    info_var, variable);
		       }
		       else kfprintf(file, "if (%s_info->%s_selected)\n",
				     info_var, variable);

		       kfprintf(file, "%s{\n", indent);
	  	       kfprintf(file, "%s    %s_%s(%s_info);\n", indent,
				control_var, variable, info_var);
		       kfprintf(file, "%s    %s_info->%s_selected = FALSE;\n",
			        indent, info_var, variable);
		       kfprintf(file, "%s}\n", indent);

		       if (do_file != NULL)
		       {
			     ksprintf(search_key, 
				     "[|*]\\s*Routine Name:\\s*%s_%s", 
				     control_var, variable);
			     krewind(do_file);
			     already_gend = kparse_file_search(do_file, search_key, 
						 	KIGNORE_CASE, &tmp);
			     kfree(tmp);
		       }
		       if ((do_file == NULL) || (already_gend != KPARSE_OK))
		           kgen_gui_selection_function(func_file, selection, 
				location, info_type, control_var, variable, 
				func_routines, func_num, FALSE, gen_debug);
                   }
        	   break;

       	      case KUIS_FLAG:
		   kvf_get_attributes(selection->back_kformstruct,
				      KVF_LIVE,     &live,
				      KVF_OPTIONAL, &optional,
				      NULL); 
		   if ((optional == opt_flag) && (live))
	 	   {
		       variable = ktoken_to_string(selection->var_token);
                       kgen_gui_selection_comment(file, "flag", 
					          live, variable, indent);
		       if (*first) 
		       {
			   kfprintf(file, "%s", indent);
			   *first = FALSE;
		       }
		       else kfprintf(file, "%selse ", indent);

		       if ((optional) && (opt_flag))
		           kfprintf(file, "if (%s_info->%s_selected)\n",
			            info_var, variable);

		       kfprintf(file, "%s{\n", indent);
	  	       kfprintf(file, "%s    %s_%s(%s_info);\n", indent,
				control_var, variable, info_var);
		       kfprintf(file, "%s    %s_info->%s_selected = FALSE;\n",
			        indent, info_var, variable);
		       kfprintf(file, "%s}\n", indent);

		       if (do_file != NULL)
		       {
			     ksprintf(search_key, 
				     "[|*]\\s*Routine Name:\\s*%s_%s", 
				     control_var, variable);
			     krewind(do_file);
			     already_gend = kparse_file_search(do_file, 
						search_key, KIGNORE_CASE, &tmp);
			     kfree(tmp);
		       }
		       if ((do_file == NULL) || (already_gend != KPARSE_OK))
		           kgen_gui_selection_function(func_file, selection, 
				location, info_type, control_var, variable, 
				func_routines, func_num, FALSE, gen_debug);
                   }
        	   break;

       	      case KUIS_CYCLE:
		   kvf_get_attributes(selection->back_kformstruct,
				      KVF_LIVE,     &live,
				      KVF_OPTIONAL, &optional,
				      NULL); 
		   if ((optional == opt_flag) && (live))
	 	   {
		       variable = ktoken_to_string(selection->var_token);
                       kgen_gui_selection_comment(file, "cycle", 
					          live, variable, indent);
		       if (*first) 
		       {
			   kfprintf(file, "%s", indent);
			   *first = FALSE;
		       }
		       else kfprintf(file, "%selse ", indent);

		       if ((optional) && (opt_flag))
		       {
		           kfprintf(file, "if ((%s_info->%s_selected) ", 
				    info_var, variable);
		           kfprintf(file, " && (%s_info->%s_optsel))\n", 
				    info_var, variable);
		       }
		       else kfprintf(file, "if (%s_info->%s_selected)\n",
				     info_var, variable);

		       kfprintf(file, "%s{\n", indent);
	  	       kfprintf(file, "%s    %s_%s(%s_info);\n", indent,
				control_var, variable, info_var);
		       kfprintf(file, "%s    %s_info->%s_selected = FALSE;\n",
			        indent, info_var, variable);
		       kfprintf(file, "%s}\n", indent);

		       if (do_file != NULL)
		       {
			     ksprintf(search_key, 
				     "[|*]\\s*Routine Name:\\s*%s_%s", 
				     control_var, variable);
			     krewind(do_file);
			     already_gend = kparse_file_search(do_file, 
						search_key, KIGNORE_CASE, &tmp);
			     kfree(tmp);
		       }
		       if ((do_file == NULL) || (already_gend != KPARSE_OK))
		           kgen_gui_selection_function(func_file, selection, 
				location, info_type, control_var, variable, 
				func_routines, func_num, FALSE, gen_debug);
                   }
        	   break;

       	      case KUIS_DISPLAYLIST:
       	      case KUIS_LIST:
		   kvf_get_attributes(selection->back_kformstruct,
				      KVF_LIVE,             &live,
				      KVF_OPTIONAL,         &optional,
				      NULL); 
		   if (selection->type == KUIS_DISPLAYLIST)
			kvf_get_attribute(selection->back_kformstruct,
					 KVF_LIST_DOUBLECLICK, &doubleclick);
		   else doubleclick = FALSE;
		   if ((optional == opt_flag) && (live))
	 	   {
		       /*
	                * for displaylist selections, need to print 
                        * code to support doubleclick callback.
	                */
		       variable = ktoken_to_string(selection->var_token);
		       if (doubleclick)
		       {

		       kfprintf(file, "%s/*\n", indent);
                       kfprintf(file, "%s * user double-clicked on list %s", 
			        indent, variable);
                       kfprintf(file, "%s */\n", indent);
		       if (*first)
                       {
                           kfprintf(file, "%s", indent);
                           *first = FALSE;
                       }
                       else kfprintf(file, "%selse ", indent);

                       if ((optional) && (opt_flag))
                       {
                           kfprintf(file, "if ((%s_info->%s_selected) ",
                                    info_var, variable);
                           kfprintf(file, " && (%s_info->%s_dblclick) ",
                                    info_var, variable);
                           kfprintf(file, " && (%s_info->%s_optsel))\n",
                                    info_var, variable);
                       }
                       else 
		       {
			   kfprintf(file, "if ((%s_info->%s_selected)\n",
                                     info_var, variable);
                           kfprintf(file, "%s          && (%s_info->%s_dblclick))\n",
                                    indent, info_var, variable);
		       }

		       kfprintf(file, "%s{\n", indent);
                       kfprintf(file, "%s    %s_%s_dblclick(%s_info);\n", 
			     indent, control_var, variable, info_var);
		       kfprintf(file, "%s    %s_info->%s_selected = FALSE;\n",
			        indent, info_var, variable);
		       kfprintf(file, "%s}\n", indent);

                       if (do_file != NULL)
                       {
                             ksprintf(search_key,
                                     "[|*]\\s*Routine Name:\\s*%s_%s_dblclick",
                                     control_var, variable);
                             krewind(do_file);
                             already_gend = kparse_file_search(do_file, 
						search_key, KIGNORE_CASE, &tmp);
                             kfree(tmp);
                       }
                       if ((do_file == NULL) || (already_gend != KPARSE_OK))
                           kgen_gui_selection_function(func_file, selection, 
				location, info_type, control_var, variable,
                                func_routines, func_num, TRUE, gen_debug);
		       }
                       kgen_gui_selection_comment(file, "list", 
					          live, variable, indent);
		       if (*first) 
		       {
			   kfprintf(file, "%s", indent);
			   *first = FALSE;
		       }
		       else kfprintf(file, "%selse ", indent);

		       if ((optional) && (opt_flag))
		       {
		           kfprintf(file, "if ((%s_info->%s_selected) ", 
				    info_var, variable);
		           kfprintf(file, " && (%s_info->%s_optsel))\n", 
				    info_var, variable);
		       }
		       else kfprintf(file, "if (%s_info->%s_selected)\n",
				     info_var, variable);

		       kfprintf(file, "%s{\n", indent);
	  	       kfprintf(file, "%s    %s_%s(%s_info);\n", indent,
				control_var, variable, info_var);
		       kfprintf(file, "%s    %s_info->%s_selected = FALSE;\n",
			        indent, info_var, variable);
		       kfprintf(file, "%s}\n", indent);

		       if (do_file != NULL)
		       {
			     ksprintf(search_key, 
				     "[|*]\\s*Routine Name:\\s*%s_%s", 
				     control_var, variable);
			     krewind(do_file);
			     already_gend = kparse_file_search(do_file, 
						search_key, KIGNORE_CASE, &tmp);
			     kfree(tmp);
		       }
		       if ((do_file == NULL) || (already_gend != KPARSE_OK))
		           kgen_gui_selection_function(func_file, selection, 
				location, info_type, control_var, variable, 
				func_routines, func_num, FALSE, gen_debug);

                   }
        	   break;


       	      case KUIS_ROUTINE:
       	      case KUIS_BLANK:
       	      case KUIS_STDIN:
       	      case KUIS_STDOUT:
	      case KUIS_HELP:
	      case KUIS_WORKSPACE:
	      case KUIS_QUIT:
                   break;

	      case KUIS_TOGGLE:
		   kvf_get_attributes(selection->back_kformstruct,
				      KVF_LIVE,     &live,
				      KVF_OPTIONAL, &optional,
				      NULL); 
		   if ((optional == opt_flag) && (live))
	 	   {
		       variable = ktoken_to_string(selection->var_token);
                       kgen_gui_selection_comment(file, "toggle", 
					          live, variable, indent);
		       if (*first) 
		       {
			   kfprintf(file, "%s", indent);
			   *first = FALSE;
		       }
		       else kfprintf(file, "%selse ", indent);

		       if ((optional) && (opt_flag))
		       {
		           kfprintf(file, "if ((%s_info->%s_selected) ", 
				    info_var, variable);
		           kfprintf(file, " && (%s_info->%s_optsel))\n", 
				    info_var, variable);
		       }
		       else kfprintf(file, "if (%s_info->%s_selected)\n",
				     info_var, variable);

		       kfprintf(file, "%s{\n", indent);
	  	       kfprintf(file, "%s    %s_%s(%s_info);\n", indent,
				control_var, variable, info_var);
		       kfprintf(file, "%s    %s_info->%s_selected = FALSE;\n",
			        indent, info_var, variable);
		       kfprintf(file, "%s}\n", indent);

		       if (do_file != NULL)
		       {
			     ksprintf(search_key, 
				     "[|*]\\s*Routine Name:\\s*%s_%s", 
				     control_var, variable);
			     krewind(do_file);
			     already_gend = kparse_file_search(do_file, 
						search_key, KIGNORE_CASE, &tmp);
			     kfree(tmp);
		       }
		       if ((do_file == NULL) || (already_gend != KPARSE_OK))
		           kgen_gui_selection_function(func_file, selection, 
				location, info_type, control_var, variable, 
				 func_routines, func_num, FALSE, gen_debug);
		   }
        	   break;
       
       	      case KUIS_PANEACTION:
		   if (opt_flag == FALSE)
		   {
		       variable = ktoken_to_string(selection->var_token);
                       kgen_gui_selection_comment(file, "pane action button", 
					     KGEN_GUI_BUTTON, variable, indent);
		       if (*first == TRUE)
		          kfprintf(file, "%sif (%s_info->%s)\n",
		                indent, info_var, variable);
		       else
		          kfprintf(file, "%selse if (%s_info->%s)\n",
		               indent, info_var, variable);
		       *first = FALSE;

		       kfprintf(file, "%s{\n", indent);
	  	       kfprintf(file, "%s    %s_%s(%s_info);\n", indent,
			       control_var, variable, info_var);
		       kfprintf(file, "%s    %s_info->%s = FALSE;\n",
			        indent, info_var, variable);
		       kfprintf(file, "%s}\n", indent);

		       if (do_file != NULL)
		       {
			     ksprintf(search_key, 
				     "[|*]\\s*Routine Name:\\s*%s_%s", 
				     control_var, variable);
			     krewind(do_file);
			     already_gend = kparse_file_search(do_file, search_key, 
						 	KIGNORE_CASE, &tmp);
			     kfree(tmp);
		       }
		       if ((do_file == NULL) || (already_gend != KPARSE_OK))
		           kgen_gui_selection_function(func_file, selection, 
				location, info_type, control_var, variable, 
				func_routines, func_num, FALSE, gen_debug);
		   }
       		   break;


	     case KUIS_MUTINCL:
	     case KUIS_MUTEXCL:
	 	  if (!(gen_selection_code(file, func_file, do_file, location, 
				selection->group_next, info_type, control_var,
				opt_flag, first, indent, gen_debug,
				func_routines, func_num)))
		       return(FALSE);
		  break;

      	      default:
       		   break;
       
       	    }  /* end switch */
	    selection = selection->next;
	} 
	return(TRUE);
}
       
/*------------------------------------------------------------
|
|  Routine Name: kgen_gui_selection_debug
|
|       Purpose: When the [-debug] option is used, generates segments 
|                of code for each selection in the GUI which will
|                print out its value after a "live" selection is
|                changed or an action button is used.
|
|         Input: file         - open stream to "l*.c"
|                selection    - selection for which to print debug stmts
|                control_var  - program_name of the variable on
|				the -F, -M, or -P line
|                indent       - string with whitespace for indenting
|
|        Output: Returns TRUE on success, FALSE on failure
|          Date: May 11, 1992
|    Written By: Danielle Argiro
| Modifications:
|
------------------------------------------------------------*/

int kgen_gui_selection_debug(
   kfile      *file,
   kselection *selection,
   char       *control_var,
   char       *indent)
{
	char *title, *variable;
	int  optional, doubleclick = FALSE;

	kfprintf(file, "\n%s/*** Print Out GUI Values ***/\n\n", indent);
	kvf_get_attribute(selection->back_control->back_kformstruct, 
			  KVF_TITLE, &title);
	kfprintf(file,"%skfprintf(kstderr, \"Values on %s:\\n\");\n", 
		 indent, title);

       	switch(selection->type) {
        
	    case KUIS_MASTERACTION:
	    case KUIS_SUBFORMACTION:
       	    case KUIS_PANEACTION:
		 variable = ktoken_to_string(selection->var_token);
		 kvf_get_attribute(selection->back_kformstruct,
				   KVF_TITLE, &title);
	         kfprintf(file, "%sif (%s_info->%s)\n%s{\n", indent, 
				control_var, variable, indent);
	         kfprintf(file,"%s    kfprintf(kstderr, \"user clicked on '%s'\\n\\n\");\n", indent, title);
		 kfprintf(file, "%s}\n", indent);
		 break;

	    case KUIS_INPUTFILE:
		 variable = ktoken_to_string(selection->var_token);
                 kvf_get_attribute(selection->back_kformstruct,
                                   KVF_OPTIONAL, &optional);
		 if (optional)
		 {
		     kfprintf(file,"%sif (%s_info->%s_optsel)\n", 
			       indent, control_var, variable, indent);
                     kfprintf(file, "%s    kfprintf(kstderr, \"Just used \");\n",
			      indent);
		 }
		 kfprintf(file,"%skfprintf(kstderr, \"'%s'\");\n", 
			  indent, title);
		 kfprintf(file,"%skfprintf(kstderr, \" has a value of '%%s'\\n\\n\", \n\t\t\t%s_info->%s);\n", indent, control_var, variable);
       		 break;

       	    case KUIS_OUTPUTFILE:
                 variable = ktoken_to_string(selection->var_token);
                 kvf_get_attributes(selection->back_kformstruct,
                                    KVF_OPTIONAL, &optional,
				    KVF_TITLE,    &title,
				    NULL);
		 if (optional)
		 {
		     kfprintf(file,"%sif (%s_info->%s_optsel)\n", 
			       indent, control_var, variable, indent);
                     kfprintf(file, "%s    kfprintf(kstderr, \"Just used \");\n",
			      indent);
		 }
		 kfprintf(file,"%skfprintf(kstderr, \"'%s'\");\n", 
			  indent, title);
		 kfprintf(file,"%skfprintf(kstderr, \" has a value of '%%s'\\n\\n\", \n\t\t\t%s_info->%s);\n", indent, control_var, variable);
       		 break;

      	    case KUIS_INTEGER:
                 variable = ktoken_to_string(selection->var_token);
                 kvf_get_attributes(selection->back_kformstruct,
                                    KVF_OPTIONAL, &optional,
				    KVF_TITLE,    &title,
				    NULL);
		 if (optional)
		 {
		     kfprintf(file,"%sif (%s_info->%s_optsel)\n", 
			       indent, control_var, variable, indent);
                     kfprintf(file, "%s    kfprintf(kstderr, \"Just used \");\n",
			      indent);
		 }
	 	 kfprintf(file,"%skfprintf(kstderr, \"'%s'\");\n", 
			  indent, title);
		 kfprintf(file,"%skfprintf(kstderr, \" has a value of %%d\\n\\n\", \n\t\t\t%s_info->%s);\n", indent, control_var, variable);
       		 break;

	    case KUIS_FLOAT:
	    case KUIS_DOUBLE:
                 variable = ktoken_to_string(selection->var_token);
                 kvf_get_attributes(selection->back_kformstruct,
                                    KVF_OPTIONAL, &optional,
				    KVF_TITLE,    &title,
				    NULL);
		 if (optional)
		 {
		     kfprintf(file,"%sif (%s_info->%s_optsel)\n", 
			       indent, control_var, variable, indent);
                     kfprintf(file, "%s    kfprintf(kstderr, \"Just used \");\n",
			      indent);
		 }
	 	 kfprintf(file,"%skfprintf(kstderr, \"'%s'\");\n", 
			  indent, title);
	 	 kfprintf(file,"%skfprintf(kstderr, \" has a value of %%g\\n\\n\", \n\t\t\t%s_info->%s);\n", indent, control_var, variable);
       		 break;

       	    case KUIS_STRING:
       	    case KUIS_STRINGLIST:
                 variable = ktoken_to_string(selection->var_token);
                 kvf_get_attributes(selection->back_kformstruct,
                                    KVF_OPTIONAL, &optional,
				    KVF_TITLE,    &title,
				    NULL);
		 if (optional)
		 {
		     kfprintf(file,"%sif (%s_info->%s_optsel)\n", 
			       indent, control_var, variable, indent);
                     kfprintf(file, "%s    kfprintf(kstderr, \"Just used \");\n",
			      indent);
		 }
	  	 kfprintf(file,"%skfprintf(kstderr, \"'%s'\");\n", 
			  indent, title);
		 kfprintf(file,"%skfprintf(kstderr, \" has a value of '%%s'\\n\\n\", \n\t\t\t%s_info->%s);\n", indent, control_var, variable);
       		 break;

       	    case KUIS_LOGICAL:
                 variable = ktoken_to_string(selection->var_token);
                 kvf_get_attributes(selection->back_kformstruct,
                                    KVF_OPTIONAL, &optional,
				    KVF_TITLE,    &title,
				    NULL);
		 if (optional)
		 {
		     kfprintf(file,"%sif (%s_info->%s_optsel)\n", 
			       indent, control_var, variable, indent);
                     kfprintf(file, "%s    kfprintf(kstderr, \"Just used \");\n",
			      indent);
		 }
	 	 kfprintf(file,"%skfprintf(kstderr, \"'%s'\");\n", 
			  indent, title);
		 kfprintf(file,"%skfprintf(kstderr, \" has a value of %%d\\n\\n\", \n\t\t\t%s_info->%s);\n", indent, control_var, variable);
        	 break;

       	    case KUIS_FLAG:
                 variable = ktoken_to_string(selection->var_token);
                 kvf_get_attribute(selection->back_kformstruct,
				   KVF_TITLE, &title);
                 kfprintf(file, "%s    kfprintf(kstderr, \"Just used \");\n", 
			  indent);
	 	 kfprintf(file,"%skfprintf(kstderr, \"'%s'\");\n", 
			  indent, title);
		 kfprintf(file,"%skfprintf(kstderr, \" has a value of %%d\\n\\n\", \n\t\t\t%s_info->%s);\n", indent, control_var, variable);
        	 break;

       	    case KUIS_CYCLE:
                 variable = ktoken_to_string(selection->var_token);
                 kvf_get_attributes(selection->back_kformstruct,
                                    KVF_OPTIONAL, &optional,
				    KVF_TITLE,    &title,
				    NULL);
		 if (optional)
		 {
		     kfprintf(file,"%sif (%s_info->%s_optsel)\n", 
			       indent, control_var, variable, indent);
                     kfprintf(file, "%s    kfprintf(kstderr, \"Just used \");\n", indent);
		 }
	 	 kfprintf(file,"%skfprintf(kstderr, \"'%s'\");\n", 
			  indent, title);
		 kfprintf(file,"%skfprintf(kstderr, \" has a value of %%d\\n\\n\", \n\t\t\t%s_info->%s);\n", indent, control_var, variable);
	 	 kfprintf(file,"%skfprintf(kstderr, \"%s's label\");\n", 
			  indent, title);
		 kfprintf(file,"%skfprintf(kstderr, \" has a value of %%s\\n\\n\", \n\t\t\t%s_info->%s_label);\n", indent, control_var, variable);
        	 break;

       	    case KUIS_LIST:
       	    case KUIS_DISPLAYLIST:
                 variable = ktoken_to_string(selection->var_token);
                 kvf_get_attributes(selection->back_kformstruct,
                                    KVF_OPTIONAL,         &optional,
				    KVF_TITLE,            &title,
				    NULL);

		 if (selection->type == KUIS_DISPLAYLIST)
			kvf_get_attribute(selection->back_kformstruct,
					 KVF_LIST_DOUBLECLICK, &doubleclick);
		 if (optional)
		 {
		     kfprintf(file,"%sif (%s_info->%s_optsel)\n", 
			       indent, control_var, variable, indent);
                     kfprintf(file, "%s    kfprintf(kstderr, \"Just used \");\n",
			      indent);
		 }
	  	 kfprintf(file,"%skfprintf(kstderr, \"'%s'\");\n",
			  indent, title);
		 kfprintf(file,"%skfprintf(kstderr, \" has a value of '%%d'\\n\\n\", \n\t\t\t%s_info->%s);\n", indent, control_var, variable);
	  	 kfprintf(file,"%skfprintf(kstderr, \"%s's label\");\n", 
			  indent, title);
		 kfprintf(file,"%skfprintf(kstderr, \" has a value of '%%s'\\n\\n\", \n\t\t\t%s_info->%s_label);\n", indent, control_var, variable);

		 if (doubleclick)
                 {
                     kfprintf(file,"%sif (%s_info->%s_dblclick)\n",
                               indent, control_var, variable, indent);
                     kfprintf(file, "%s    kfprintf(kstderr, \"Double Clicked\");\n", indent);
                 }

        	 break;


	    
       	    case KUIS_ROUTINE:
       	    case KUIS_BLANK:
       	    case KUIS_STDIN:
       	    case KUIS_STDOUT:
	    case KUIS_WORKSPACE:
	    case KUIS_QUIT:
                 break;

	    case KUIS_TOGGLE:
                 variable = ktoken_to_string(selection->var_token);
                 kvf_get_attributes(selection->back_kformstruct,
                                    KVF_OPTIONAL,         &optional,
                                    KVF_TITLE,            &title,
                                    NULL);
		 if (optional)
		 {
		     kfprintf(file,"%sif (%s_info->%s_optsel)\n", 
			      indent, control_var, variable, indent);
                     kfprintf(file, "%s    kfprintf(kstderr, \"Just used \");\n",
			      indent);
		 }
		 kfprintf(file,"%skfprintf(kstderr, \"'%s' \");\n", 
			  indent, title);
		 kfprintf(file,"%skfprintf(kstderr, \"has member %%d chosen \\n\", \n\t\t\t%s_info->%s_num);\n", indent, control_var, variable);
		 if ((selection->toggle_next->type == KUIS_FLAG) ||
		     (selection->toggle_next->type == KUIS_INTEGER) ||
		     (selection->toggle_next->type == KUIS_LOGICAL))
		 {
		     kfprintf(file,"%skfprintf(kstderr, \"with a value of %%d \\n\", \n\t\t\t%s_info->%s_val);\n", indent, control_var, variable);
		 }
		 else if (selection->toggle_next->type == KUIS_FLOAT)
		 {
		     kfprintf(file,"%skfprintf(kstderr, \"with a value of %%f \\n\", \n\t\t\t%s_info->%s_val);\n", indent, control_var, variable);
		 }
		 else if (selection->toggle_next->type == KUIS_DOUBLE)
		 {
		     kfprintf(file,"%skfprintf(kstderr, \"with a value of %%g \\n\", \n\t\t\t%s_info->%s_val);\n", indent, control_var, variable);
		 }
		 else if ((selection->toggle_next->type == KUIS_STRING) ||
		          (selection->toggle_next->type == KUIS_INPUTFILE) ||
		          (selection->toggle_next->type == KUIS_OUTPUTFILE))
		 {
		     kfprintf(file,"%skfprintf(kstderr, \"with a value of %%s \\n\", \n\t\t\t%s_info->%s_val);\n", indent, control_var, variable);
		 }
		 else 
		 {
		    errno = KINTERNAL;
		    kerror(KCODEGEN, "kgen_gui_selection_debug",
			   "Toggle member of unsupported type");
		    return(FALSE);
		 }
        	 break;
       

	   case KUIS_MUTEXCL:
	   case KUIS_MUTINCL:
                if (!(kgen_gui_selection_debug(file, selection->group_next, 
					      control_var, indent)))
		    return(FALSE);
		break;

      	   default:
       		   break;
       
       	}  /* end switch */
	kfprintf(file,"\n");
	return(TRUE);
}
