/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Utility routines for file objects
   >>>>
   >>>>   Static:
   >>>>
   >>>>  Private:
   >>>>
   >>>>   Public:
   >>>>
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include "fileP.h"

/*-----------------------------------------------------------
| Routine Name:	kcms_fobj_shift_parent - change internal state for object
|						change
|
| Purpose:	my, old peculier is good!
| Input:	fileobj - file object to remove
| Output:	
| Returns:	TRUE (1) on success, FALSE (0) otherwise
|
| Written By:	Neil Bowers
| Date:		May 31, 1993 12:43
------------------------------------------------------------*/
int
kcms_fobj_shift_parent(
   kobject  fileobj,
   kstring  oldname,
   kstring  newname,
   kstring  old_parent_path,
   kstring  new_parent_path,
   kstring  old_inc_path,
   kstring  new_inc_path)
{
   kstring  oldpath;
   kstring  newpath;
   kstring  filedir;
   char     libinc[KLENGTH];


   if (!kcms_get_attribute(fileobj, KCMS_PATH, &oldpath))
      return FALSE;

   if (!kstrncmp(old_parent_path, oldpath, kstrlen(old_parent_path)))
   {
      newpath = kstring_cat(new_parent_path,
                             oldpath + kstrlen(old_parent_path),
                             NULL);
      fileobj->fullname = kstring_to_token(newpath);
      filedir           = kdirname(newpath, NULL);
      fileobj->dirname  = kstring_to_token(filedir);
   }
   else if (!kstrncmp(old_inc_path, oldpath, kstrlen(old_inc_path)))
   {
      ksprintf(libinc, "%s%s.h", old_inc_path, oldname);
      if (!kstrcmp(oldpath, libinc))
	 newpath = kstring_3cat(new_inc_path, newname, ".h", NULL);
      else
	 newpath = kstring_cat(new_inc_path, oldpath + kstrlen(old_inc_path),
			       NULL);
      fileobj->fullname = kstring_to_token(newpath);
      filedir           = kdirname(newpath, NULL);
      fileobj->dirname  = kstring_to_token(filedir);
   }

   return TRUE;
}
