/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            KDBM Utility routines
   >>>>
   >>>>   Static:
   >>>>  Private:
   >>>>         kcms_db_update_string()
   >>>>         kcms_db_update_fobj()
   >>>>         kcms_db_update_int()
   >>>>         kcms_db_update_logical()
   >>>>         kcms_db_get_key()
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include "databaseP.h"

/*-----------------------------------------------------------
| Routine Name:	kcms_db_remove_key - remove a key from database
|
| Purpose:	This routine will update the db entry for the specified
|		key, or remove it if the str field is NULL
|
| Input:	database  - open kdbm pointer to the database
|		keystring - keystring for the item we want to remove from
|			    the database.
|
| Written By:	Neil Bowers
| Date:		22-jun-94
------------------------------------------------------------*/
void
kcms_db_remove_key(
   kdbm     *database,
   kstring  keystring)
{
   kdatum  key;


   key.dptr = keystring;
   key.dsize = kstrlen(keystring) + 1;
   kdbm_delete(database, key);
}

/*-----------------------------------------------------------
| Routine Name:	kcms_db_update_string - update db entry or remove it.
|
| Purpose:	This routine will update the db entry for the specified
|		key, or remove it if the str field is NULL
|
| Input:	database - open kdbm pointer to the cm database
|		str  - the string data field to store in the database
|		tag  - the match tag to store the data under
|
| Written By:	Steven Jorgensen
| Date:		13-aug-1993
------------------------------------------------------------*/
void
kcms_db_update_string(
   kdbm     *database,
   kstring  field,
   kstring  tag)
{
   kdatum  key;
   kdatum  data;


   key.dptr = tag;
   key.dsize = kstrlen(tag) + 1;
   if ((data.dsize = kstrlen(field)) > 0)
   {
      data.dptr = field;
      data.dsize++;
      kdbm_store(database, key, data, KDBM_REPLACE);
   }
   else
      kdbm_delete(database, key);
}

/*-----------------------------------------------------------
| Routine Name:	kcms_db_update_string_list - update db entry or remove it.
|
| Purpose:	This routine will update the db entry for the specified
|		key, or remove it if the str field is NULL
|
| Input:	database - open kdbm pointer to the cm database
|		str  - the string data field to store in the database
|		tag  - the match tag to store the data under
|
| Written By:	Steven Jorgensen
| Date:		13-aug-1993
------------------------------------------------------------*/
void
kcms_db_update_string_list(
   kdbm     *database,
   klist    *string_list,
   kstring  tag)
{
   kdatum   key;
   kdatum   data;
   kstring  result = NULL;
   kstring  keyword;
   kstring  tmp;
   klist    *list;


   for (list = string_list; list != NULL; list = klist_next(list))
   {
      keyword = (kstring) klist_clientdata(list);
      tmp = kstring_3cat(result, "\n", keyword, NULL);
      kfree(result);
      result = tmp;
   }

   key.dptr = tag;
   key.dsize = kstrlen(tag) + 1;
   if ((data.dsize = kstrlen(result)) > 0)
   {
      data.dptr = result;
      data.dsize++;
      kdbm_store(database, key, data, KDBM_REPLACE);
   }
   else
      kdbm_delete(database, key);
}

/*-----------------------------------------------------------
| Routine Name:	kcms_db_update_fobj - update db entry or remove it.
|
| Purpose:	This routine will update the db entry for the specified
|		key, or remove it if the fobj field is NULL
|
| Input:	database - open kdbm pointer to the cm database
|		fobj - the file object data field to store in the database
|		tag  - the match tag to store the data under
|
| Written By:	Steven Jorgensen
| Date:		13-aug-1993
------------------------------------------------------------*/
void
kcms_db_update_fobj(
   kdbm     *database,
   kobject  fobj,
   kstring  tag)
{
   kstring  tmp = NULL;
   kdatum   key;


   if (fobj != NULL)
   {
      /*UPDATE: should flag this error? -- */
      if (!kcms_get_attribute(fobj, KCMS_PATH, &tmp))
	 return;
      kcms_db_update_string(database, tmp, tag);
   }
   else
   {
      key.dptr = tag;
      key.dsize = kstrlen(tag) + 1;
      kdbm_delete(database, key);
   }
}

/*-----------------------------------------------------------
| Routine Name:	kcms_db_update_int - update db entry or remove it.
|
| Purpose:	This routine will update the db entry for the specified
|		key.
|
| Input:	database - open kdbm pointer to the cm database
|		num  - the integer data field to store in the database
|		tag  - the match tag to store the data under
|
| Written By:	Steven Jorgensen
| Date:		13-aug-1993
------------------------------------------------------------*/
void
kcms_db_update_int(
   kdbm     *dbm,
   int      num,
   kstring  tag)
{
   char tmp[KLENGTH];


   ksprintf(tmp, "%d", num);
   kcms_db_update_string(dbm, tmp, tag);
}

/*-----------------------------------------------------------
| Routine Name:	kcms_db_update_logical - update db entry or remove it.
|
| Purpose:	This routine will update the db entry for the specified
|		key, or remove it if the logical field is FALSE
|
| Input:	database - open kdbm pointer to the cm database
|		num  - the logical data field to store in the database
|		tag  - the match tag to store the data under
|
| Written By:	Steven Jorgensen
| Date:		13-aug-1993
------------------------------------------------------------*/
void
kcms_db_update_logical(
   kdbm     *database,
   int      num,
   kstring  tag)
{
   kcms_db_update_string(database, (num ? "YES" : NULL), tag);
}

/*-----------------------------------------------------------
| Routine Name:	kcms_db_get_key - get an entry from the database
|
| Purpose:	This routine gets a field from the given database.
|
| Input:	database	- open kdbm pointer to the cm database
|		keystr		- the field name for the key
|
| Written By:	Steven Jorgensen
| Date:		13-aug-1993
------------------------------------------------------------*/
char *
kcms_db_get_key(
   kdbm     *database,
   kstring  keystr)
{
   kdatum  key;
   kdatum  keydata;


   key.dptr = keystr;
   key.dsize = kstrlen(keystr) + 1;
   keydata = kdbm_fetch(database, key);
   return kstring_cleanup(keydata.dptr, NULL);
}

/*-----------------------------------------------------------
| Routine Name:	kcms_db_open_fileobj - open file object from object db
|
| Purpose:	This routine gets a field from the given database.
|
| Input:	database	- open kdbm pointer to the cm database
|		keystr		- the field name for the key
|
| Written By:	Neil Bowers
| Date:		24-mar-1995
------------------------------------------------------------*/
void
kcms_db_open_fileobj(
   kobject   object,
   kobject  *fobjptr,
   kdbm     *database,
   kstring   keystr,
   int       file_type,
   int       file_subtype,
   int       genflag,
   int       permissions)
{
   kstring   tmp;


   *fobjptr = NULL;
   tmp = kcms_db_get_key(database, keystr);
   if (tmp == NULL)
      return;

   *fobjptr = kcms_open_fileobj(object, tmp, NULL, file_type, file_subtype,
				genflag, permissions);
   kfree(tmp);
}

/*-----------------------------------------------------------
| Routine Name:	kcms_db_read_dates - load time strings from database
|
| Purpose:	This routine reads three times from the DATES
|
| Input:	database     - open kdbm pointer for a toolbox or
|			       software object database
|		creation     - pointer to a string for the creation date
|		modification - pointer to a string for the modification date
|		generation   - pointer to a string for the generation date
|
| Written By:	Neil Bowers
| Date:		25-mar-1995
------------------------------------------------------------*/
void
kcms_db_read_dates(
   kdbm     *database,
   kstring  *creation,
   kstring  *modification,
   kstring  *generation)
{
   kstring   tmp;
   int       count;
   kstring  *strings;


   *creation = *modification = *generation = NULL;
   tmp = kcms_db_get_key(database, KCMS_KEY_DATES);
   if (tmp == NULL)
      return;

   strings = kparse_string_delimit(tmp, "\n", KLITERAL, &count);
   *creation     = (count > 0 && kstrlen(strings[0]) > 0
		    ? kstrdup(strings[0])
		    : NULL);
   *modification = (count > 1 && kstrlen(strings[1]) > 0
		    ? kstrdup(strings[1])
		    : NULL);
   *generation   = (count > 2 && kstrlen(strings[2]) > 0
		    ? kstrdup(strings[2])
		    : NULL);
}

/*-----------------------------------------------------------
| Routine Name:	kcms_db_write_dates - write time strings to database
|
| Purpose:	This routine writes three times to the DATES key
|
| Input:	database     - open kdbm pointer for a toolbox or
|			       software object database
|		creation     - pointer to a string for the creation date
|		modification - pointer to a string for the modification date
|		generation   - pointer to a string for the generation date
|
| Written By:	Neil Bowers
| Date:		27-mar-1995
------------------------------------------------------------*/
void
kcms_db_write_dates(
   kdbm     *database,
   kstring   creation,
   kstring   modification,
   kstring   generation)
{
   char      buffer[KLENGTH];


   ksprintf(buffer, "%s\n%s\n%s\n",
	    (creation != NULL ? creation : ""),
	    (modification != NULL ? modification : ""),
	    (generation != NULL ? generation : ""));
   kcms_db_update_string(database, buffer, KCMS_KEY_DATES);
}
