 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Remote Daemon Transport Utilities
   >>>>
   >>>>  Private:
   >>>>			phantomd_routines
   >>>>			phantomd_init
   >>>>			phantomd_exit
   >>>>			phantomd_stop
   >>>>			phantomd_start
   >>>>			phantomd_connect
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "phantomd.h"


/*-------------------------------------------------------------
|  
|  Routine Name: phantomd_connect
|  
|       Purpose: This function is used to start a daemon process.
|  
|         Input:
|        Output: returns the number of started deamons (-1 if an error
|	         occurs).
|  
|   Called From: daemon programs
|  
|    Written By:  Mark Young
|  
-------------------------------------------------------------*/

int phantomd_connect(
   RemoteTransport *routines)
{
	if (routines->connect() == -1)
	{
	   kinfo(KSTANDARD, "phantomd_init: Unable to start remote daemon \
transports...\n\n  Unable to start a remote transports in which to communicate \
with other phantom daemons.  Either this machine doesn't have any such \
transports or they have not been enabled for your machine.  Please check \
with the Khoros transport documentation or online Khoros manpage (transport.3) \
for more information.");
	   return(-1);
	}
	return(0);
}


/*-------------------------------------------------------------
|  
|  Routine Name: phantomd_routines(identifier)
|  
|       Purpose: This function is used to find the appropriate daemon
|	         information
|  
|  
|         Input: identifier - the transport identifier string
|  
|        Output: none
|  
|   Called From: various kfile utilities
|  
|    Written By:  Mark Young
|          Date:  Jul 08, 1992 16:22
| Modifications: Converted from daemon_routines() in Khoros 1.0 (MY)
|  
-------------------------------------------------------------*/

RemoteTransport *phantomd_routines(
   char *identifier)
{
	int	i;


	for (i = 0; i < NumRemoteTransports; i++)
	{
	   if (remote_transport[i] != NULL)
	   {
	      if (remote_transport[i]->identifier == NULL)
		 continue;
	      else if (identifier == NULL)
		 return(remote_transport[i]);
	      else if (kstrcmp(identifier,remote_transport[i]->identifier) == 0)
		 return(remote_transport[i]);
	   }
	}
	return(NULL);
}


/*-------------------------------------------------------------
|  
|  Routine Name: phantomd_init
|  
|       Purpose: This function is used to start a daemon process.
|  
|         Input:
|  
|        Output: returns the number of started deamons (-1 if an error
|	         occurs).
|  
|   Called From: daemon programs
|  
|    Written By:  Mark Young
|  
-------------------------------------------------------------*/

int phantomd_init(
   char *identifier,
   int  timeout,
   kfile **ifile,
   kfile **ofile)
{
	kdbm   *dbm;
	kdatum key, data;
	RemoteTransport *routines;
	char   hostname[KLENGTH], temp[KLENGTH], *itransport, *otransport;


	/*
	 *  According to the transport routines
	 */
	routines = phantomd_routines(identifier);

	if (routines == NULL && identifier != NULL)
	{
	   kinfo(KSTANDARD, "phantomd_init: Unsupported remote transport...\
\n\n  Unable to find support for the following transport (%s).", identifier);
	   return(FALSE);
	}
	else if (routines == NULL)
	{
	   kinfo(KSTANDARD, "phantomd_init: Unable to find any remote \
transports...\n\n  Unable to find any remote transports in which to start a \
daemon for.  Either this machine doesn't have any such transports or they \
have not been enabled for your machine.  Please check with the Khoros \
transport documentation or online Khoros manpage (transport.3) for more \
information.");
	   return(FALSE);
	}

	if (kgethostname(NULL, hostname, KLENGTH) == -1)
	{
	   kinfo(KSTANDARD, "phantomd_init: Unable to get local \
hostname... \n\n  Unable to get local hostname in which to add to the \
local phantom daemon database.");
	   return(FALSE);
	}

	if (!(dbm = kdbm_open("~/.phantomd", O_WRONLY|O_CREAT, 0600)))
	{
	   kinfo(KSTANDARD, "phantomd_init: Unable to store remote daemon \
transports information...\n\n  Unable to store remote transports information \
in the user's home directory.  Specifically the failure was due to a create \
error of the dbm info file ~/.phantomd which is used to communicate between \
local khoros processes and the local phantom daemon.  Please check \
with the Khoros transport documentation or online Khoros manpage (transport.3) \
for more information.");
	   return(FALSE);
	}

	if (!(itransport = ktempnam(NULL,"stream=iPhantom")) ||
	    !(otransport = ktempnam(NULL,"stream=oPhantom")))
	{
	   kinfo(KSTANDARD, "nphantomd_init: Unable to create the local \
transport in which local processes communicate with the phantom daemon.  The \
call to ktempnam failed to create the temporary transport using a template \
of '%s'.  Please check with the Khoros transport documentation or online \
Khoros manpage (transport.3) for more information.", "stream=[i,o]Phantom");
	   return(FALSE);
	}

	if (!(*ifile = kfopen(otransport, "R+")) ||
	    !(*ofile = kfopen(itransport, "R+")))
	{
	   kinfo(KSTANDARD, "phantomd_init: Unable to open the local \
transport in which local processes communicate with the phantom daemon.  The \
temporary transport was successfully created by ktempnam, but failed to open \
the transport '%s' using kfopen.  Please check with the Khoros transport \
documentation or online Khoros manpage (transport.3) for more information.",
			*ifile ? itransport : otransport);
	   return(FALSE);
	}

	/*
	 *  Store it in the database so that people will wanna talk to us..
	 */
	ksprintf(temp,"%s %s", itransport, otransport);
	key.dptr  = hostname;
	key.dsize = kstrlen(key.dptr) + 1;
	data.dptr  = temp;
	data.dsize = kstrlen(data.dptr) + 1;
	kdbm_store(dbm, key, data, KDBM_REPLACE);
	kdbm_close(dbm);
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: phantomd_exit - exit handler for local phantomd process
|
|       Purpose: phantomd_exit is called when the local phantomd process
|		 is exited.  At that time we cleanup all remote connections,
|		 terminate any active processes, and remove the local
|		 transport information.
|
|         Input: status      - the current exiting status
|		 client_data - not used
|        Output:
|       Returns: 
|
|    Written By: Mark Young
|          Date: Oct 10, 1993
| Modifications:
|
------------------------------------------------------------*/

void phantomd_exit(
   int   status,
   kaddr client_data)
{
	kdbm   *dbm;
	kdatum key;
	char   hostname[KLENGTH];


	if (kgethostname(NULL, hostname, KLENGTH) == -1)
	{
	   kinfo(KSTANDARD, "phantomd_exit: Unable to get local \
hostname... \n\n  Unable to get local hostname in which to remove from \
the local phantom daemon database.");
	   return;
	}

	if (!(dbm = kdbm_open("~/.phantomd", O_WRONLY, 0600)))
	{
	   kinfo(KSTANDARD, "phantomd_stop: Unable to open remote daemon \
transports information...\n\n  Unable to remove remote transports information \
in the user's home directory.  Specifically the failure was due to an open \
error of the dbm info file ~/.phantomd which is used to communicate between \
local khoros processes and the local phantom daemon.  Please check \
with the Khoros transport documentation or online Khoros manpage (transport.3) \
for more information.");
	   return;
	}
	key.dptr  = hostname;
	key.dsize = kstrlen(key.dptr) + 1;
	kdbm_delete(dbm, key);
	kdbm_close(dbm);
}

/*-------------------------------------------------------------
|  
|  Routine Name: phantomd_stop
|  
|       Purpose: This function is used to stop a daemon process.
|  
|         Input:
|  
|        Output: returns the number of started deamons (-1 if an error
|	         occurs).
|  
|   Called From: daemon programs
|  
|    Written By:  Mark Young
|  
-------------------------------------------------------------*/

int phantomd_stop(
   void)
{
	return(0);
}


/*-------------------------------------------------------------
|  
|  Routine Name: phantomd_start(identifier, machine)
|  
|       Purpose: This function is used to initialize the appropriate daemon
|	         on the remote machine.  Both the identifier and the
|	         machine are optional.  This routine is called by the
|	         different remote transport if they are unable to contact
|	         the remote machine.  The routine will exec "locally" a
|	         program identified by PhantomExec.  This is usually a
|	         the shell script "phantom" which in turns tries to start
|	         the phantomd program on the remote machine.  The reason
|	         why we say usually is because we want to be flexible and
|	         let each site customize the transport & daemon
|	         mechanisms.
|  
|	         If the identifier is NULL then the daemon should use a
|	         default transport.  If the machine is NULL then the
|	         daemon should start the daemon locally.
|  
|         Input: identifier - the transport identifier string
|                machine    - the machine to start the daemon
|  
|        Output: returns the exit status...
|  
|   Called From: various kfile utilities
|  
|    Written By:  Mark Young
|          Date:  Jul 08, 1992 16:22
| Modifications: Converted from start_daemon() in Khoros 1.0 (MY)
|  
-------------------------------------------------------------*/

int phantomd_start(
   char *identifier,
   char *machine)
{
	int	status;
	char	command[KLENGTH], temp[KLENGTH];


	kstrcpy(command, PhantomExec);

	if (machine != NULL)
	{
	   (void) ksprintf(temp," %s", machine);
	   (void) kstrcat(command, temp);
	}

	if (identifier != NULL)
	{
	   (void) ksprintf(temp," -transport %s", identifier);
	   (void) kstrcat(command, temp);
	}
	ksystem(command);
	return(status);
}
