 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "phantomd.h"
/*-----------------------------------------------------------
| 
|  Routine Name: phantomd_get_args
| 
|       Purpose: Gets command line args for phantomd
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname phantomd
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void phantomd_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for phantomd is out of sync with arguments specified in phantomd's *.pane file; please rerun ghostwriter on phantomd.";


	/*
	 * allocate the phantomd structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_logical(pane, "daemon",
			  &(clui_info->daemon_logic),
			  &(clui_info->daemon_flag))))
	{
	    kerror(NULL, "phantomd_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "timeout",
			  &(clui_info->timeout_int),
			  &(clui_info->timeout_flag))))
	{
	    kerror(NULL, "phantomd_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "transport",
			  &(clui_info->transport_string),
			  &(clui_info->transport_flag))))
	{
	    kerror(NULL, "phantomd_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



