 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kset
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kset.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Sets attributes of toolbox or software objects
|
|       Purpose: main program for kset
|
|         Input:
|		char *clui_info->tb_string; {name of toolbox}
|		int   clui_info->tb_flag; {TRUE if -tb specified}
|
|		char *clui_info->oname_string; {name of object}
|		int   clui_info->oname_flag; {TRUE if -oname specified}
|
|		int clui_info->force_flag; {TRUE if -force specified}
|
|		char *clui_info->author_string; {full name of author or point of contact}
|		int   clui_info->author_flag; {TRUE if -author specified}
|
|		char *clui_info->email_string; {email address of author or point of contact}
|		int   clui_info->email_flag; {TRUE if -email specified}
|
|		char *clui_info->icon_string; {string to use as icon name for object }
|		int   clui_info->icon_flag; {TRUE if -icon specified}
|
|		char *clui_info->misc_file; {miscellaneous file to add to object}
|		int   clui_info->misc_flag; {TRUE if -misc specified}
|
|		char *clui_info->addkeyword_string; {Add a keyword to the specified object}
|		int   clui_info->addkeyword_flag; {TRUE if -addkeyword specified}
|
|		char *clui_info->rmkeyword_string; {Remove a keyword to the object specified}
|		int   clui_info->rmkeyword_flag; {TRUE if -rmkeyword specified}
|
|		char *clui_info->description_string; {Short Description}
|		int   clui_info->description_flag; {TRUE if -description specified}
|
|		char *clui_info->category_string; {category of object}
|		int   clui_info->category_flag; {TRUE if -category specified}
|
|		char *clui_info->subcategory_string; {subcategory of object}
|		int   clui_info->subcategory_flag; {TRUE if -subcategory specified}
|
|		char *clui_info->version_string; {version string}
|		int   clui_info->version_flag; {TRUE if -version specified}
|
|		char *clui_info->atb_string; {associated toolbox name}
|		int   clui_info->atb_flag; {TRUE if -atb specified}
|
|		char *clui_info->aoname_string; {associated object name}
|		int   clui_info->aoname_flag; {TRUE if -aoname specified}
|
|		char *clui_info->aargs_string; {associated command-line args}
|		int   clui_info->aargs_flag; {TRUE if -aargs specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
   kstring        routine  = "main()";
   kobject        toolbox  = NULL;
   kobject        object   = NULL;
   unsigned long  update;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "BOOTSTRAP");
	kexit_handler(kset_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "BOOTSTRAP", "kset",
		kset_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kset_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
   if (clui_info->tb_string == NULL && clui_info->oname_string != NULL)
   {
      kerror(NULL, routine, "You must specify a toolbox if you give "
             "an object.");
      kexit(KEXIT_FAILURE);
   }

   if (clui_info->tb_string != NULL
       && (toolbox = kcms_open_toolbox(clui_info->tb_string)) == NULL)
   {
      kerror(NULL, routine, "Unable to open toolbox `%s'.",
             clui_info->tb_string);
      kexit(KEXIT_FAILURE);
   }

   if (clui_info->oname_string != NULL
       && (object = kcms_open_cmobj(toolbox, clui_info->oname_string)) == NULL)
   {
         kerror(NULL, routine, "Unable to open object `%s' in toolbox `%s'.",
                clui_info->oname_string, clui_info->tb_string);
         kcms_close(toolbox);
         kexit(KEXIT_FAILURE);
   }

   if (object != NULL && clui_info->force_flag)
      kcms_set_bit(object, KCMS_CMOBJ_FLAGS, KCMS_BIT_CMOBJ_FORCE);

   /*-- AUTHOR: full name of author or point of contact ---------------*/
   if (clui_info->author_flag)
   {
      if (object != NULL)
         kcms_set_attribute(object, KCMS_CMOBJ_AUTHOR,
                            clui_info->author_string);
      else
         kcms_set_attribute(toolbox, KCMS_TB_AUTHOR,
                            clui_info->author_string);
   }

   /*-- AUTHOR EMAIL: email address of author or point of contact -----*/
   if (clui_info->email_flag)
   {
      if (object != NULL)
         kcms_set_attribute(object, KCMS_CMOBJ_AUTHOR_EMAIL,
                            clui_info->email_string);
      else
         kcms_set_attribute(toolbox, KCMS_TB_AUTHOR_EMAIL,
                            clui_info->email_string);
   }

   /*-- Associated software object -----------------------------------*/
   if ((clui_info->atb_flag || clui_info->aoname_flag || clui_info->aargs_flag)
       && object != NULL)
   {
      kstring  old_tb, old_oname, old_args;
      kstring  new_tb, new_oname, new_args;

      if (kcms_get_attribute(object, KCMS_CMOBJ_ASSOCIATED_OBJECT,
                              &old_tb, &old_oname, &old_args))
      {
         new_tb = kstrdup(clui_info->atb_flag
			  ? clui_info->atb_string
			  : old_tb);
         new_oname = kstrdup(clui_info->aoname_flag
			  ? clui_info->aoname_string
			  : old_oname);
         new_args = kstrdup(clui_info->aargs_flag
			  ? clui_info->aargs_string
			  : old_args);
         kcms_set_attribute(object, KCMS_CMOBJ_ASSOCIATED_OBJECT,
                            new_tb, new_oname, new_args);
         kfree(new_tb);
         kfree(new_oname);
         kfree(new_args);
      }
   }

   /*-- CATEGORY: the object's category -------------------------------*/
   if (clui_info->category_flag)
   {
      if (object != NULL)
         kcms_set_attribute(object, KCMS_CMOBJ_CATEGORY,
                            clui_info->category_string);
      else
         kwarn(NULL, routine, "The CATEGORY attribute is not defined for "
               "a toolbox object;  ignoring.");
   }

   /*-- SUBCATEGORY: the object's subcategory -------------------------*/
   if (clui_info->subcategory_flag)
   {
      if (object != NULL)
         kcms_set_attribute(object, KCMS_CMOBJ_SUBCATEGORY,
                            clui_info->subcategory_string);
      else
         kwarn(NULL, routine, "The SUBCATEGORY attribute is not defined for "
               "a toolbox object;  ignoring.");
   }

   /*-- VERSION: the object's version string --------------------------*/
   if (clui_info->version_flag)
   {
      if (object != NULL)
         kcms_set_attribute(object, KCMS_CMOBJ_VERSION,
                            clui_info->version_string);
      else
         kcms_set_attribute(toolbox, KCMS_TB_VERSION,
			    clui_info->version_string);
   }

   /*-- ICON NAME attribute: optional text string to use as icon -----*/
   if (clui_info->icon_flag)
   {
      if (object != NULL)
         kcms_set_attribute(object, KCMS_CMOBJ_ICON_NAME,
                            clui_info->icon_string);
      else
         kwarn(NULL, routine, "The ICON NAME attribute is not defined for "
               "a toolbox object;  ignoring");
   }

   /*-- Add MISC file: a file we want to be carried with the object ---*/
   if (clui_info->misc_flag)
   {
      if (object != NULL)
         kcms_create_fileobj(object, clui_info->misc_file, NULL,
                             KCMS_FOBJ_TYPE_MISC, KCMS_FOBJ_SUBTYPE_NONE,
                             KCMS_FOBJ_GEN_NONE, KCMS_FOBJ_ACCESS_RDWR);
      else
         kcms_create_fileobj(toolbox, clui_info->misc_file, NULL,
                             KCMS_FOBJ_TYPE_MISC, KCMS_FOBJ_SUBTYPE_NONE,
                             KCMS_FOBJ_GEN_NONE, KCMS_FOBJ_ACCESS_RDWR);
   }

   /*-- Add keyword to the toolbox or software object -----------------*/
   if (clui_info->addkeyword_flag)
   {
      if (object != NULL)
         kcms_add_keyword(object, clui_info->addkeyword_string);
      else
         kcms_add_keyword(toolbox, clui_info->addkeyword_string);
   }

   /*-- Add keyword to the toolbox or software object -----------------*/
   if (clui_info->rmkeyword_flag)
   {
      if (object != NULL)
         kcms_remove_keyword(object, clui_info->rmkeyword_string);
      else
         kcms_remove_keyword(toolbox, clui_info->rmkeyword_string);
   }

   /*-- SHORT DESCRIPTION: short description of object -----*/
   if (clui_info->description_flag)
   {
      if (object != NULL)
         kcms_set_attribute(object, KCMS_CMOBJ_SHORT_DESC,
                            clui_info->description_string);
      else
	 kerror(NULL, routine,
	        "Must specify and object when setting the short description.");

   }
/* -main_before_lib_call_end */

/* -main_library_call */
/* -main_library_call_end */

/* -main_after_lib_call */
   /*-- do we need to generate code for the object? -------------------*/
   if (object != NULL)
   {
      kcms_get_attribute(object, KCMS_CMOBJ_UPDATE_DB, &update);
      if ((update & KCMS_UPDATE_REGEN_CODE) == KCMS_UPDATE_REGEN_CODE)
	 kgen_generate_object(object);
   }

   if (object != NULL)
      kcms_close(object);

   if (toolbox != NULL)
      kcms_close(toolbox);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kset_usage_additions
| 
|       Purpose: Prints usage additions in kset_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kset
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kset_usage_additions(void)
{
	kfprintf(kstderr, "\tSets attributes of toolbox or software objects\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kset_free_args
| 
|       Purpose: Frees CLUI struct allocated in kset_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kset
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kset_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->tb_string);
	kfree(clui_info->oname_string);
	kfree(clui_info->author_string);
	kfree(clui_info->email_string);
	kfree(clui_info->icon_string);
	kfree(clui_info->misc_file);
	kfree(clui_info->addkeyword_string);
	kfree(clui_info->rmkeyword_string);
	kfree(clui_info->description_string);
	kfree(clui_info->category_string);
	kfree(clui_info->subcategory_string);
	kfree(clui_info->version_string);
	kfree(clui_info->atb_string);
	kfree(clui_info->aoname_string);
	kfree(clui_info->aargs_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
