 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for krm
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "krm.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Removes a software object or file from a toolbox
|
|       Purpose: main program for krm
|
|         Input:
|		char *clui_info->tb_string; {toolbox to be removed (or toolbox from which to remove object}
|		int   clui_info->tb_flag; {TRUE if -tb specified}
|
|		char *clui_info->oname_string; {software object to be removed}
|		int   clui_info->oname_flag; {TRUE if -oname specified}
|
|		char *clui_info->i_file; {file to be removed}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		int clui_info->force_flag; {TRUE if -force specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject toolbox = NULL, object = NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "BOOTSTRAP");
	kexit_handler(krm_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "BOOTSTRAP", "krm",
		krm_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	krm_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	/*
	 *  manual error checking because UIS does not support dependancies
 	 */
	if ((clui_info->i_flag) && ((clui_info->oname_flag) || (clui_info->tb_flag)))
	{
	    kinfo(KSTANDARD, "To remove a file, only the [-i] option is necessary;  ignoring [-oname] and/or [-tb]\n");
	}
	if ((clui_info->oname_flag) && (!clui_info->tb_flag))
	{
	    kerror(NULL, "main()", "Cannot remove the software object without a toolbox specified;  please provide the [-tb] option.");
	    kexit(KEXIT_FAILURE);
	}
/* -main_before_lib_call_end */

/* -main_library_call */
	/*
	 *  remove a file
 	 */
	if (clui_info->i_flag)
	{
	   if (!clui_info->force_flag && !kprompt(KSTANDARD, "Yes", "No", 1,
		"Remove '%s'?", clui_info->i_file))
	   {
	      kinfo(KSTANDARD, "\nAborting removing file '%s'\n",
		    clui_info->i_file);
	      kexit(KEXIT_FAILURE);
	   }

	   if (kunlink(clui_info->i_file) == -1)
	   {
	      kerror(NULL, "main()", "Couldn't remove file '%s'",
		     clui_info->i_file);
	      kexit(KEXIT_FAILURE);
	   }
	}

	/*
	 *  remove a toolbox
 	 */
	else if ((clui_info->tb_flag) && (!clui_info->oname_flag))
	{
	   if ((toolbox = kcms_open_toolbox(clui_info->tb_string)) == NULL)
           {
              (void) kerror(NULL, "main()", "Cannot open toolbox '%s'.",
                            clui_info->tb_string);
              kexit(KEXIT_FAILURE);
           }
	   if (clui_info->force_flag)
	      kcms_set_bit(toolbox, KCMS_TB_FLAGS, KCMS_BIT_TB_FORCE);

	   if (!kcms_destroy(toolbox))
           {
	      kcms_close(toolbox);
	      kexit(KEXIT_FAILURE);
           }
	}

	/*
	 *  remove a program or library object
 	 */
	else if ((clui_info->tb_flag) && (clui_info->oname_flag))
	{
	   if ((toolbox = kcms_open_toolbox(clui_info->tb_string)) == NULL ||
               (object  = kcms_open_cmobj(toolbox,
					  clui_info->oname_string)) == NULL)
           {
              (void) kerror(NULL, "main()", "Cannot open %s '%s'.",
                        (!toolbox) ? "toolbox" : "object",
                        (!toolbox) ? clui_info->tb_string :
                        clui_info->oname_string);
              kexit(KEXIT_FAILURE);
           }

	   if (clui_info->force_flag)
	      kcms_set_bit(object, KCMS_CMOBJ_FLAGS, KCMS_BIT_CMOBJ_FORCE);

	   if (!kcms_destroy(object))
	   {
	      if (kerror(NULL,"main()","Remove of object '%s' failed\n",
			clui_info->oname_string) == TRUE)
	      {
		 kinfo(KSTANDARD, "krm: remove aborted\n");
	      }
	      kexit(KEXIT_FAILURE);
	   }
	   kcms_close(toolbox);
	}
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: krm_usage_additions
| 
|       Purpose: Prints usage additions in krm_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname krm
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void krm_usage_additions(void)
{
	kfprintf(kstderr, "\tRemoves a software object or file from a toolbox\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: krm_free_args
| 
|       Purpose: Frees CLUI struct allocated in krm_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname krm
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
krm_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->tb_string);
	kfree(clui_info->oname_string);
	kfree(clui_info->i_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
