
 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Khoros Whatis Utility Routines
   >>>>
   >>>>  Private:
   >>>>      run_kwhatis()
   >>>>   Static:
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "kman.h"


/*-----------------------------------------------------------
|
|  Routine Name: run_kwhatis - routine for printing whatis
|
|       Purpose: This routine will process a manpage.
|         Input: tbname  - the name of the toolbox file
|		 manpage - the man page to be printed
|
|        Output: None
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Jul 07, 1993
| Modifications:
|
------------------------------------------------------------*/

int run_kwhatis(
   char *whatis,
   char **toolboxes,
   int  tb_num)
{
	kfile *file;
	int   i, status;
	char  filename[KLENGTH], string[KLENGTH], *data, *temp, *line;


	temp = (!isatty(1) ? "cat" : ((temp = kgetenv("PAGER")) == NULL) ?
			"more" : temp);
	if ((file = kpopen(temp, "w")) == NULL)
	{
	   kerror(NULL, "run_kwhatis", "Cannot execute the command '%s'",
			temp);
	   return(FALSE);
	}

	ksprintf(string, "^.*%s.*$", whatis);
	for (i = 0; i < tb_num; i++)
	{
           /*
            * open the whatis file and read it
            */
	   ksprintf(filename, "$%s/repos/config/whatis", toolboxes[i]);
	   if ((temp = data = kreadfile(filename, NULL)) == NULL)
	      continue;

	   while ((temp = kparse_string_search(temp, string,
			KIGNORE_CASE, &line, &status)) != NULL)
	   {
	      kfprintf(file, "%s\n", line);
	      kfree(line);
	   }
	   kfree(data);
	}
	kpclose(file);
	return(TRUE);
}
