 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kgenimake
   >>>> 
   >>>>    Written By: Mark Young
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kgenimake_h_
#define _kgenimake_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <bootstrap.h>

/* -include_includes */
#include "kcms/kcms.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
#define IMAKEDIR	0
#define BOOTSTRAP_TEMPLATES	\
	"$BOOTSTRAP/repos/config/imake_config/Templates"
#define DOCUMENTATION_TEMPLATES	\
	"$BOOTSTRAP/repos/config/doc_config/Templates"

#define DIRECTORY_TEMPLATE	"Imakefile.dir"
#define LIBRARY_TEMPLATE	"Imakefile.library"
#define PROGRAM_TEMPLATE	"Imakefile.kroutine"
#define FOR_PROGRAM_TEMPLATE	"Imakefile.fkroutine"
#define XPROGRAM_TEMPLATE	"Imakefile.xvroutine"
#define FOR_XPROGRAM_TEMPLATE	"Imakefile.fxvroutine"
#define EXAMPLE_TEMPLATE	"Imakefile.example"
#define XEXAMPLE_TEMPLATE	"Imakefile.xexample"
#define TESTSUITE_TEMPLATE	"Imakefile.testsuite"
#define CSH_TEMPLATE		"Imakefile.csh"
#define SH_TEMPLATE		"Imakefile.sh"
#define KSH_TEMPLATE		"Imakefile.ksh"
#define PERL_TEMPLATE		"Imakefile.perl"
#define MANUAL_TEMPLATE		"Imakefile.manual"
#define MANUAL_INDEX_TEMPLATE	"Imakefile.mindex"
#define MANUAL_GLOSS_TEMPLATE	"Imakefile.mglossary"
#define MANUAL_DIRECTORY_TEMPLATE	"Imakefile.mdir"
#define PANE_TEMPLATE		"Imakefile.pane"

#define SRCS			"SRCS"
#define CSRCS			"CSRCS"
#define FSRCS			"FSRCS"
#define YSRCS			"YSRCS"
#define LSRCS			"LSRCS"
#define CPLUSPLUS		"C++SRCS"

#define OBJS			"OBJS"
#define UNSHAREDOBJS		"UNSHAREDOBJS"
#define FOBJS			"FOBJS"
#define COBJS			"COBJS"
#define CPLUSOBJS		"C++OBJS"
#define LOBJS			"LOBJS"
#define YOBJS			"YOBJS"
#define FOBJS			"FOBJS"

#define DIRS			"SUBDIRS"
#define HEADER			"HEADERS"
#define SCRIPTS			"SCRIPTS"
#define MANFILE			"MASTER"
#define TBLFILE			"TBL"
#define SECFILE			"SEC"
#define PSFILE			"PS"

#define TOOLBOX_NAME		"TOOLBOX_NAME"
#define BINARY_NAME		"BINARY_NAME"
#define LANGTYPE		"KLANG"
#define OBJECT_TYPE		"OBJECT_TYPE"
#define OBJECT_NAME		"OBJECT_NAME"
/* -include_defines_end */

#define PANEPATH "$BOOTSTRAP/objects/kroutine/kgenimake/uis/kgenimake.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Toolbox name (optional string)
 */
char	*tb_string;	/* Toolbox name STRING */
int	 tb_flag;   	/* Toolbox name FLAG */

/*
 *  Recreate Imakefile from template (optional flag)
 */
int	 recreate_flag;  	/* Recreate Imakefile from template FLAG */

/*----- optional ME group ----*/
/*
 *  The object name (optional string)
 */
char	*oname_string;	/* The object name STRING */
int	 oname_flag;   	/* The object name FLAG */

/*
 *  create directory imakefile (optional flag)
 */
int	 dir_flag;  	/* create directory imakefile FLAG */

/*
 *  create manual directory imakefile (optional flag)
 */
int	 mdir_flag;  	/* create manual directory imakefile FLAG */

/*
 *  create example imakefile (optional flag)
 */
int	 example_flag;  	/* create example imakefile FLAG */

/*
 *  create manual imakefile (optional flag)
 */
int	 manual_flag;  	/* create manual imakefile FLAG */

/*
 *  create X11 example imakefile (optional flag)
 */
int	 xexample_flag;  	/* create X11 example imakefile FLAG */

/*
 *  create manual index Imakefile (optional flag)
 */
int	 mindex_flag;  	/* create manual index Imakefile FLAG */

/*
 *  create testsuite imakefile (optional flag)
 */
int	 testsuite_flag;  	/* create testsuite imakefile FLAG */

/*
 *  create manual glossary Imakefile (optional flag)
 */
int	 mglossary_flag;  	/* create manual glossary Imakefile FLAG */

/*-- optional ME group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kgenimake_get_args PROTO((kform *));
void kgenimake_usage_additions PROTO((void));
void kgenimake_free_args PROTO((int, kaddr));

/* -include_routines */
int generate_imakefile PROTO((char *, char *, int, int));
/* -include_routines_end */

#endif
