 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "ghostwriter.h"
/*-----------------------------------------------------------
| 
|  Routine Name: ghostwriter_get_args
| 
|       Purpose: Gets command line args for ghostwriter
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ghostwriter
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void ghostwriter_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for ghostwriter is out of sync with arguments specified in ghostwriter's *.pane file; please rerun ghostwriter on ghostwriter.";


	/*
	 * allocate the ghostwriter structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_string(pane, "tb",
			  &(clui_info->tb_string),
			  &(clui_info->tb_flag))))
	{
	    kerror(NULL, "ghostwriter_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "oname",
			  &(clui_info->oname_string),
			  &(clui_info->oname_flag))))
	{
	    kerror(NULL, "ghostwriter_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "force",
			  &(clui_info->force_flag))))
	{
	    kerror(NULL, "ghostwriter_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "debug",
			  &(clui_info->debug_flag))))
	{
	    kerror(NULL, "ghostwriter_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



