/*
 * Khoros: $Id$
 */
 
#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            File Title
   >>>>
   >>>>  Static:
   >>>>  Public:
   >>>>             ReadLine()
   >>>>             ProcessLine()
   >>>>             WriteLine()
   >>>>             mycpp()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include <bootstrap.h>
#include <kutils/ksignal.h>
#include "kimakedef.h"

static int   token_last = -1;
static int   token_next = 1;
static int   token_tablesize = 0;
static char  **token_table = NULL;
static kilist **hash_table = NULL;

char *kstrcpy(istr1, istr2)
   char *istr1;
   char *istr2;
{
	char *string = istr1;
	if (istr1 == NULL)
	   return(NULL);
	else if (istr2 == NULL)
	   return(istr1);

	/*EMPTY*/
	while ((*istr1++ = *istr2++) != '\0');
	return(string);
}

/*-----------------------------------------------------------
|
|  Routine Name: kilist_head
|       Purpose: find the head of a list
|         Input: list - list to search
|       Returns: the head of list on success, NULL otherwise
|    Written By: Mark Young
|          Date: Mar 06, 1995
| Modifications: simplified version of klist_head from kutils (SJ)
|
------------------------------------------------------------*/
kilist *kilist_head(list)
   kilist *list;
{
   if (list == NULL)
      return NULL;

   while (list->prev != NULL && (int) list->head == FALSE)
      list = list->prev;

   return list;
}

/*-----------------------------------------------------------
|
|  Routine Name: kilist_tail
|       Purpose: find the tail of a list
|         Input: list - list to search
|       Returns: the tail of list on success, NULL otherwise
|    Written By: Mark Young
|          Date: Mar 06, 1995
| Modifications: simplified version of klist_tail from kutils (SJ)
|
------------------------------------------------------------*/
kilist *kilist_tail(list)
   kilist *list;
{
   if (list == NULL)
      return NULL;

   while (list->next != NULL && (int) list->next->head == FALSE)
      list = list->next;

   return list;
}

/*-----------------------------------------------------------
|
|  Routine Name: kilist_locate
|       Purpose: search for a list entry
|         Input: list - list to search
|                identifier - number to search for
|       Returns: the items kilist entry on success, NULL otherwise
|    Written By: Mark Young
|          Date: Mar 06, 1995
| Modifications: simplified version of klist_locate from kutils (SJ)
|
------------------------------------------------------------*/
kilist *kilist_locate( list, identifier)
   kilist *list;
   int    identifier;
{
   if (list == NULL)
      return NULL;
   do
   {
      if (list->identifier == identifier)
         return list;

      list = list->next;
   } while (list != NULL && (int) list->head == FALSE);
   return NULL;
}

/*-----------------------------------------------------------
|
|  Routine Name: kilist_add
|       Purpose: add an entry to the end of a list
|         Input: list - list to add to
|		 identifier - number to identify the data with
|		 client_data - string to store.
|       Returns: the head of list on success, NULL otherwise
|    Written By: Mark Young
|          Date: Mar 06, 1995
| Modifications: simplified version of klist_insert from kutils (SJ)
|
------------------------------------------------------------*/
kilist *kilist_add( list, identifier, client_data)
   kilist *list;
   int   identifier;
   char  *client_data;
{
   kilist *entry, *head;

   entry = (kilist *) kcalloc(1, sizeof(kilist));
   entry->identifier = identifier;
   entry->client_data = client_data;

   if (list == NULL)
   {
      entry->head = TRUE;
      list = entry;
      list->next  =
      list->prev  = NULL;
      return list;
   }

   list = kilist_tail(list);

   if (list->next != NULL)
      list->next->prev = entry;
   entry->next = list->next;
   list->next  = entry;
   entry->prev = list;
   return kilist_head(entry);
}

/*-----------------------------------------------------------
|
|  Routine Name: kilist_delete
|       Purpose: delete an entry from the list
|         Input: list - list to delete from
|                identifier - number to identify the data with
|                client_data - string to store.
|       Returns: the head of list on success, NULL otherwise
|    Written By: Mark Young
|          Date: Mar 06, 1995
| Modifications: simplified version of klist_insert from kutils (SJ)
|
------------------------------------------------------------*/
kilist *kilist_delete(list, identifier)
   kilist *list;
   int    identifier;
{
   kilist *entry;

   if ((entry = kilist_locate(list, identifier)) == NULL)
      return list;

   if (entry->next != NULL)
   {
      entry->next->prev = entry->prev;
      if ((int) entry->head == TRUE)
         entry->next->head = TRUE;
   }
   if (entry->prev != NULL)
      entry->prev->next = entry->next;

   if (entry == list && entry->next != NULL)
      list = entry->next;
   else if (entry == list)
      list = entry->prev;

   kfree(entry);
   return list;
}

/*-----------------------------------------------------------
|
|  Routine Name: kstring_3cat
|       Purpose: concat 3 strings together
|         Input: istr1 - input string 1
|		 istr2 - input string 2
|		 istr3 - input string 3
|		 ostr  - output string
|       Returns: ostr if it is non-NULL, the kmalloc'ed
|                string if ostr is NULL, or NULL on error.
|    Written By: Steven Jorgensen & Nick Ruprecht
|          Date: Jul 03, 1992
| Modifications: simplified version of kstring_3cat from kutils (SJ)
|
------------------------------------------------------------*/
char *kstring_3cat( istr1, istr2, istr3, ostr )
   char *istr1;
   char *istr2;
   char *istr3;
   char *ostr;
{
   int n1   = kstrlen(istr1),
       n2   = kstrlen(istr2),
       n3   = kstrlen(istr3),
       nout = n1+n2+n3;

   if (nout <= 0)
      return NULL;
   if (!ostr && (ostr = kmalloc(nout+1)) == NULL)
   {
      return(NULL);
   }
   if (n1 > 0 && ostr != istr1)
      kstrcpy(ostr, istr1);
   if (n2 > 0)
      kstrcpy(ostr + n1, istr2);
   if (n3 > 0)
      kstrcpy(ostr + n1 + n2, istr3);

   ostr[nout] = '\0';
   return ostr;
}

/*-----------------------------------------------------------
|
|  Routine Name: _cleanup_string
|       Purpose: cleanup a string of beginning and ending white space
|         Input: istr - input string
|                ostr - output string
|       Returns: ostr if it is not NULL, a pointer to the
|                resulting malloc'ed string if it is NULL.  NULL on
|                an error.
|    Written By: Mark Young
|          Date: Jul 03, 1992
| Modifications: simplified version of kstring_3cat from kutils (SJ)
--------------------------------------------------------------*/
static char *_cleanup_string( string)
   register char *string;
{
   register char *temp;
   while (isspace(*string))
      string++;

   if (*string == '\0')
      return NULL;

   temp = string + kstrlen(string);
   while (isspace(*--temp))
      ;
   *(temp+1) = '\0';

   return string;
}

/*-----------------------------------------------------------
|
|  Routine Name: kstring_cleanup
|       Purpose: cleanup a string of beginning and ending white space
|         Input: istr - input string
|                ostr - output string
|       Returns: ostr if it is not NULL, a pointer to the
|		 resulting malloc'ed string if it is NULL.  NULL on
|		 an error.
|    Written By: Mark Young
|          Date: Jul 03, 1992
| Modifications: simplified version of kstring_3cat from kutils (SJ)
| ------------------------------------------------------------*/
char *kstring_cleanup(istr, ostr)
	char *istr;
	char *ostr;
{
	char *string, *temp;

	if (istr == NULL || strlen(istr) == 0)
	{
	   if (ostr) ostr[0] = '\0';
	   return(NULL);
	}

	if (ostr == NULL)
	   string = kstrdup(istr);
	else if (istr != ostr)
	   string = kstrcpy(ostr, istr);
	else
	   string = ostr;

	if ((temp = _cleanup_string(string)) == NULL)
	{
	   if (ostr != NULL) ostr[0] = '\0';
	      else kfree(string);

	   return(NULL);
	}
	else if (temp != string)
	{
	   kstrcpy(string, temp);
	}
	return(string);
}

/*-----------------------------------------------------------
|
|  Routine Name: khash - polynomial conversion
|       Purpose: polynomial conversion ignoring overflows
|		 [this seems to work remarkably well, in fact better
|		 then the ndbm hash function. Replace at your own risk]
|
|		 ! 	use:  65599	nice.
|		 ! 	      65587   even better. 
|
|         Input: data - the data in which to create the has for
|		 length - the length of the hash to be used.  If -1,
|			  then the length is computed using kstrlen().
|       Returns: returns the associated hash for the given data.
|    Written By: Ozan S. Yigit (oz@nexus.yorku.ca)
|          Date: 1991 
| Modifications: Integrated into Khoros 2.0 (MY) 4/93
------------------------------------------------------------*/
long khash( data, length )
   register char *data;
   register int  length;
{
   register unsigned long n = 0;

#define HASHC	n = *data++ + 65599 * n
   if (length <= -1)
      length = kstrlen(data);

   switch (length % 8)
   {
      case 7: HASHC;
      case 6: HASHC;
      case 5: HASHC;
      case 4: HASHC;
      case 3: HASHC;
      case 2: HASHC;
      case 1: HASHC;
   }

   length >>= 3;
   while (length-- > 0)
   {
      HASHC; HASHC; HASHC; HASHC;
      HASHC; HASHC; HASHC; HASHC;
   }
   return n;
}

/*-----------------------------------------------------------
|
|  Routine Name: ktoken_find - static routine to find a token
|       Purpose: This routine checks to see if the string has been
|		 token'ized.
|         Input: string - the string to check if token'ized
|         	 hash   - if -1 then re-compute the hash from the string
|        Output: indx   - the hash index into the hash_table
|       Returns: the token or 0 if it doesn't exist
|    Written By: Mark Young
|          Date: Nov 16, 1993
------------------------------------------------------------*/
int ktoken_find( string, hash, indx )
   char *string;
   int  hash;
   int  *indx;
{
   kilist *list;

   if (!string)
      return 0;

   if (token_last != -1 && strcmp(string, token_table[token_last]) == 0)
      return token_last;

   if (!hash_table)
   {
      hash_table = (kilist **) kcalloc(TABLESIZE, sizeof(kilist *));
      token_table = (char **) kcalloc(TABLESIZE, sizeof(char *));
      token_tablesize = TABLESIZE;
   }

   if (hash == -1)
      hash = khash(string, -1);
   hash = kabs(hash) % TABLESIZE;
   if (indx)
      *indx = hash;

   for (list = hash_table[hash]; list != NULL; list = list->next)
   {
      if (strcmp(string, list->client_data) == 0)
      {
         token_last = (int) list->identifier;
         return token_last;
      }
   }
   return 0;
}

/*-----------------------------------------------------------
|
|  Routine Name: kstring_to_token - convert a string to a unique integer
|
|       Purpose: Uses a hashing function to convert a string to a unique
|		 integer
|         Input: string - input string
|       Returns: token on success, or 0 on error
|    Written By: Mark Young
|          Date: Jan 10, 1995
------------------------------------------------------------*/
int kstring_to_token( string)
   char *string;
{
   int indx, token;

   if ((token = ktoken_find(string, -1, &indx)) != 0 || !string)
      return token;

   if ((token = token_next++) == token_tablesize)
   {
      token_tablesize += TABLESIZE;
      token_table = (char **) krealloc(token_table, token_tablesize *
				sizeof(char *));
   }
   token_last = token;
   token_table[token] = kstrdup(string);
   hash_table[indx] = kilist_add(hash_table[indx], token, token_table[token]);
   return token;
}


/*-----------------------------------------------------------
|
|  Routine Name: ktoken_to_string - return the string associated with
|				 the specified token
|       Purpose: Returns the string that is associated with the supplied
|		 token.  The idea is that given a unique token for each
|		 string an application uses ktoken_to_string(token) in order
|		 to get the unique string back.  The kstring_to_token() routine
|		 should be used to create the unique token for the specified
|		 string.
|	  Input: token - the token which we will be returning the string for
|       Returns: the string or NULL if the token does not exist
|    Written By: Mark Young
|          Date: Nov 16, 1992
------------------------------------------------------------*/

char *ktoken_to_string(token)
   int token;
{
   return (token < 0 || token >= token_next) ? NULL : token_table[token];
}

/*-----------------------------------------------------------
|
|  Routine Name: kstrstr - find a substring within a string
|       Purpose: This routine is a replacement for the system
|		 library routine strstr.  This routine scans the
|		 input string for the first occurance
|		 of a substring specified by sub_str.
|         Input: istr - the string to search
|		 sub_str   - the sub string to look for.
|       Returns: If the sub_str is found in istr, a pointer indicating the
|		 address of the first character of the substring within the
|		 istr string is returned.  If the substring is not
|		 a part of the input string, a NULL is returned.
|
|		 This routine also protects against NULL on both the input and
|		 substring variables.  If either is NULL, the value of NULL is
|		 returned. 
|    Written By: Hideo Noro & Mark Young & Tom Sauer
|          Date: Jul 03, 1992 14:05
| Modifications: Converted from vstrstr in Khoros 1.0 (SJ)
------------------------------------------------------------*/
char *kstrstr( istr, sub_str)
   char *istr;
   char *sub_str;
{
   char *string;
   int  len;

   if (istr == NULL || sub_str == NULL)
      return(NULL);

   len = kstrlen(sub_str);
   string = istr;
   while (*string != '\0')
   {
      if (strncmp(string, sub_str, len) == 0)
         return string;
      string++;
   }
   return NULL;
}

