/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Khoros System include for variable and
   >>>>		       standard args.
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Aug 21, 1992 10:44
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kutils_kvarargs_h_
#define _kutils_kvarargs_h_


	/*-------------------------------------*
	|       #include 
	---------------------------------------*/

/*
 * Varargs .vs. standard args parameter list handling.
 */
#if ! KSTDC_DEF
#include <varargs.h>
#else
#include <stdarg.h>
#endif


	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/
#if ! KSTDC_DEF
#define kvalist va_alist
#define kvadcl	va_dcl
#else
#define kvalist ...
#define kvadcl
#endif

#define kva_list va_list

	/*-------------------------------------*
	|       macros
	---------------------------------------*/


/************************************************************
*
*  Routine Name: kva_start - sets the start of the variable argument list
*
*       Purpose: This routine sets the "vararg_list" pointer to the
*                start of the variable argument list.
*
* ! Example variable argument routine definition:
* !
* ! var_arg_routine(int p1, int p2, double pN, kva_alist)
* ! {
* !     short    var;          // the next parameter after pN 
* !                            // is expected to be short 
* !     kva_list *vararg_list; // the variable argument list 
* !
* !     kva_start(vararg_list, pN); // pN is the last parameter 
* !                                 // before variable args begin 
* !     :
* !     var = kva_arg(vararg_list, short);
* !     :
* !     kva_end(vararg_list);
* ! }
* !
*
* ! The execution stack when procedure var_arg_routine is executed; 
*  when kva_start is called, the "vararg_list" pointer is set to the
*  address indicated below.
*
* !                            | byte0   int parameter p1
* !                            |  :
* !                            | byte4   int parameter p2
* !                            |  :
* !                            | byte8   double parameter pN
* !                            |  :
* !    args stack address ---->| byte16  short parameter A
* !     "vararg_list"          | byte17
* !                            | byte18  int parameter B
* !                            | byte19
* !                            | byte20  
* !                            | byte21
* !                            |  :
* !
*         Input: last_param - the last argument on the parameter list 
*                             before variable arguments begin
*
*        Output: vararg_list - the variable argument pointer is set to the 
*                              beginning of the variable argument list
*       Returns: 
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Aug 21, 1992 11:01
*      Verified:
*  Side Effects:
* Modifications:
*   Declaration: void kva_start(
*                !   kva_list vararg_list,
*                !   kaddr    last_param)
*
*************************************************************/

#if ! KSTDC_DEF
#define kva_start(vararg_list, last_param) va_start(vararg_list)
#else
#define kva_start(vararg_list, last_param) va_start(vararg_list, last_param)
#endif


/************************************************************
*
*  Routine Name: kva_end - sets the end of the variable argument list
*
*       Purpose: This routine clears the "vararg_list" pointer and
*                shuts down the variable argument access mechanism.
*
* ! Example variable argument routine definition:
* !
* ! var_arg_routine(int p1, int p2, double pN, kva_alist)
* ! {
* !     short    var;          // the next parameter after pN 
* !                            // is expected to be short
* !     kva_list *vararg_list; // the variable argument list
* !
* !     kva_start(vararg_list, pN); // pN is the last parameter
* !                                 // before variable args begin
* !     :
* !     var = kva_arg(vararg_list, short);
* !     :
* !     kva_end(vararg_list);
* ! }
* 
*  The execution stack when procedure var_arg_routine is executed; 
*  when kva_end is called, the "vararg_list" pointer is set to NULL
* !
* !                            | byte0   int parameter p1
* !                            |  :
* !                            | byte4   int parameter p2
* !                            |  :
* !                            | byte8   double parameter pN
* !                            |  :
* !                            | byte16  short parameter A
* !                            | byte17
* !                            | byte18  int parameter B
* !                            | byte19
* !                            | byte20  
* !                            | byte21
* !                            |  :
* !                            |  :
* !
* ! args stack address ----> NULL
* ! "vararg_list"
*
*         Input: vararg_list - the variable argument list to be terminated
*        Output: vararg_list - the variable argument list pointer set to NULL
*       Returns: 
*  Restrictions: On some architectures, this routine is mapped to va_end(),
*                which may or may not have any effect on the vararg_list 
*                pointer.
*    Written By: Mark Young
*          Date: Aug 21, 1992 11:03
*      Verified:
*  Side Effects:
* Modifications:
*   Declaration: void kva_end(
*                !   kva_list vararg_list)
*
*************************************************************/

#define kva_end(vararg_list)		va_end(vararg_list)


/************************************************************
*
*  Routine Name: kva_arg - gets an argument off the variable argument list
*       Purpose: This routine gets an argument off the variable argument list.
*
* ! Example variable argument routine definition:
* !
* ! var_arg_routine(int p1, int p2, double pN, kva_alist)
* ! {
* !     short    var;          // the next parameter after pN 
* !                            // is expected to be short
* !     kva_list *vararg_list; // the variable argument list
* !
* !     kva_start(vararg_list, pN); // pN is the last parameter
* !                                 // before variable args begin
* !     :
* !     var = kva_arg(vararg_list, short);
* !     :
* !     kva_end(vararg_list);
* ! }
*  
*   The execution stack when procedure var_arg_routine is executed; 
*   before kva_arg is called, the "vararg_list" pointer is set to the
*   address indicated below.
* !                            | byte0   int parameter p1
* !                            |  :
* !                            | byte4   int parameter p2
* !                            |  :
* !                            | byte8   double parameter pN
* !                            |  :
* !    args stack address ---->| byte16  short parameter A
* !     "vararg_list"          | byte17
* !                            | byte18  int parameter B
* !                            | byte19
* !                            | byte20  
* !                            | byte21
* !                            |  :
* !
*
* Now, a call to kva_arg(vararg_list, short) moves the "vararg_list" pointer to
* byte18, and returns the pointer to byte16 as a short, so that 
* var_arg_routine() can obtain the value of short parameter A.
*
* ! the resulting execution stack is now:
* !                            | byte0   int parameter p1
* !                            |  :
* !                            | byte4   int parameter p2
* !                            |  :
* !                            | byte8   double parameter pN
* !                            |  :
* !    args stack address -+   | byte16  short parameter A 
* !     "vararg_list"      |   | byte17  (assigned to "var")
* !                        +-->| byte18  int parameter B
* !                            | byte19
* !                            | byte20
* !                            | byte21
* !                            |  :
* !
*         Input: vararg_list - the argument list
*		 type - The data type of the parameter.  If the type specified
*			is not the same as the actual type of the value on the
*                       stack, the behavior is undefined.
*
*			In standard C, arguments that are char or short
*			are converted to int and should be accessed as
*			int. Arguments that are unsigned char or unsigned
*			short are converted to unsigned int and should be
*			accessed as unsigned int.  Arguments that are
*			float are converted to double and should be
*			accessed as double.  
*       Returns: The next paramter on the variable argument list cast to the
*		 type specified by the type parameter
*    Written By: Mark Young
*          Date: Sep 16, 1992 21:02
*   Declaration: type kva_arg(
*                !   kva_list vararg_list,
*                !   type)
*************************************************************/

#define kva_arg(vararg_list, type) va_arg(vararg_list, type)


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/


#endif /* _kutils_kvarargs_h_ */
/* Don't add after this point */
