/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose:  Toplevel include for the kutils library.
   >>>>			This include is what includes all the
   >>>>			other kutils library function and declaration
   >>>>			includes.
   >>>>
   >>>>    Written By:  Mark Young
   >>>>          Date:  May 25, 1993
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kutils_kutils_h_
#define _kutils_kutils_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

#include <kutils/kvarargs.h>
#include <kutils/knotify.h>
#include <kutils/kfile.h>
#include <kutils/kparse.h>
#include <kutils/klist.h>
#include <kutils/karray.h>
#include <kutils/kstrings.h>
#include <kutils/kmemory.h>
#include <kutils/kobject.h>
#include <kutils/kstatus.h>
#include <kutils/kmach.h>


	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

#define KFILE_QUERY      1
#define KFILE_UPDATE     2
#define KFILE_OVERWRITE  3

#define KEDITOR_ICON		"icon"
#define KEDITOR_TITLE		"title"
#define KEDITOR_GEOMETRY	"geometry"
#define KEDITOR_FOREGROUND	"foreground"
#define KEDITOR_BACKGROUND	"background"
#define KEDITOR_PID		"pid"
#define KEDITOR_CHDIR		"chdir"

        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/


        /*-------------------------------------*
        |       macros
        ---------------------------------------*/

/************************************************************
*
*  Routine Name: knumber - the number of items in an array
*
*       Purpose: This function returns the number of items in an array
*
*         Input: array - the array of items
*        Output:
*       Returns: returns the number of items
*
*  Restrictions: 
*    Written By: Mark Young
*          Date: Feb 17, 1993 20:34
*      Verified:
*  Side Effects:
* Modifications:
*   Declaration: int knumber(char **array)
*
*************************************************************/
 
#define knumber(array) (sizeof(array)/sizeof(array[0]))



        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/* dir.c */
char *kdirname	 PROTO((char *, char *));
char *kbasename  PROTO((char *, char *));
int  kremove_dir PROTO((char *));
int  kmake_dir	 PROTO((char *, int));
int  krmdir	 PROTO((char *));
int  kmkdir	 PROTO((char *, int));
int  kchdir	 PROTO((char *));
char *kgetcwd	 PROTO((char *, int));

/* env.c */
char *kgetenv PROTO((char *));
int  kputenv  PROTO((char *));
int  kremenv  PROTO((char *));

/* file.c */
kaddr kreadfile    PROTO((char *, int *));
int   keditfile    PROTO((char *, int, kvalist));
int   kwritefile   PROTO((char *, kaddr, int));
int   kcopyfile    PROTO((char *, char *));
int   ksedfile     PROTO((char *, char *, int, int, int *, kvalist));
int   kcomparefile PROTO((char *, char *, int, int *));

/* hash.c */
long  khash PROTO((char *, int));

/* token.c */
char *ktoken_to_string	PROTO((int));
int  kstring_to_token	PROTO((char *));
int  ktoken_check	PROTO((char *));
int  ktoken_delete	PROTO((char *));

/* regex.c */
char *kre_comp	  PROTO((char *));
int kre_exec	  PROTO((char *));
int kre_subs	  PROTO((char *, char *));
int kre_pos	  PROTO((int, kaddr *, kaddr *));
void kre_modw     PROTO((char *));
void kre_debug    PROTO((char *, kfile *));
int kre_status    PROTO((void));
char *kre_icomp   PROTO((char *));
char *kregex_replace   PROTO((char *, char *, char *, char *));

/* path.c */
char *kfullpath PROTO((char *, char *, char *));
char *kexpandpath PROTO((char *, char *, char *));
char *ktbpath PROTO((char *, char *));

/* program.c */
int  kprog_set_argc	PROTO((int));
int  kprog_set_argv	PROTO((char **));
int  kprog_set_envp	PROTO((char **));
int  kprog_set_program	PROTO((char *));
int  kprog_set_toolbox	PROTO((char *));
int  kprog_get_argc	PROTO((void));
char **kprog_get_argv	PROTO((void));
char **kprog_get_envp	PROTO((void));
char *kprog_get_program PROTO((void));
char *kprog_get_toolbox PROTO((void));
char *kprog_get_command PROTO((void));

/* strftime.c */
int kstrftime PROTO((char *, int, char *, struct tm *));

/* utilities.c */
char **kalias_list2array PROTO((int *));
char   **ktoolbox_file_list2array  PROTO((int *));
int    ktoolbox_query_tbname       PROTO((char *));
int    ktoolbox_file_initialize    PROTO((void));

/* khoros.c */
void khoros_imprint PROTO((void));
void khoros_initialize PROTO((int, char **, char **, char *));

#endif /* _kutils_kutils_h_ */
/* Don't add after this point. */
