/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose:  To provide function declarations and
   >>>>			definitions for the kutils memory utilities
   >>>>
   >>>>    Written By:  Mark Young
   >>>>
   >>>>          Date:  Nov 29, 1992 09:56
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kutils_kmemory_h_
#define _kutils_kmemory_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/


        /*-------------------------------------*
        |       macros
        ---------------------------------------*/

/************************************************************
*
*  Routine Name: kfree - free memory previously allocated
*
*       Purpose: This function is a replacement for the system free()
*		 routine.  The only difference is that kfree() is an
*		 inlined macro that will also NULL your memory pointer, and
*		 protect against a NULL input ptr.
*
*         Input: ptr - the pointer to be freed
*        Output: ptr - the pointer will also be initialized to NULL
*    Written By: Mark Young
*          Date: Jul 06, 1993
* Modifications: Changed header to reflect void return instead of
*		 TRUE or FALSE. SRW 20-July-1994
*   Declaration: (void) kfree(
*		 !  kaddr ptr)
*************************************************************/

#define kfree(ptr) ((void) (_kfree(ptr), ((ptr) = NULL)))


/************************************************************
*
*  Routine Name: kbcopy - copies bytes from src to dest
*       Purpose: This function is a replacement for the BSD system call
*		 bcopy().  The kbcopy() call copies "num" bytes from src
*		 to dest using kmemcpy(), which makes sure that overlapping
*		 strings are handled correctly.  
*
*         Input: src  - the source pointer to copy "num" bytes from
*		 num  - the number of bytes to be copied
*        Output: dest - the destination pointer to copy the bytes to
*    Written By: Mark Young
*          Date: Jul 06, 1993
*   Declaration: void kbcopy(
*		 !  char *src,
*		 !  char *dest,
*		 !  int  num)
*************************************************************/

#define kbcopy(src, dest, num) ((void) kmemcpy((kaddr) (dest), \
			(kaddr) (src), num))


/************************************************************
*
*  Routine Name: kbzero - zeros out 'num' bytes (BSD style)
*
*       Purpose: This function is a replacement for the BSD system call
*		 bzero().  The kbzero() zeros out "num" bytes from ptr.
*		 kbzero() will really use kmemset() with a c value of 0,
*		 so it will be checked to make sure that the "dest" array
*		 is not NULL and "num" is greater than 0.
*         Input: num  - the number of bytes to be zero'ed
*        Output: dest - the destination pointer to be zero'ed
*    Written By: Mark Young
*          Date: Jul 06, 1993
*   Declaration: void kbzero(
*		 !  char *dest,
*		 !  int  num)
*************************************************************/

#define kbzero(dest, num) ((void) kmemset((kaddr) (dest), 0, (unsigned) (num)))


/************************************************************
*
*  Routine Name: kbcmp - compare bytes from src1 and src2 (BSD style)
*
*       Purpose: This function is a replacement for the BSD system call
*		 bcmp() which does not exist on many systems.  The kbcmp()
*		 routine compares "src1" and "src2" for "num" bytes.  kbcmp()
*		 really uses kmemcmp(), so it will be checked to make sure
*		 that both source arrays are not NULL and "num" is greater
*		 than 0.
*
*	         kbcmp() compares its arguments, looking at the first
*		 num bytes, and returns an integer less than, equal to,
*		 or greater than 0, according as src1 is lexicographically
*		 less than, equal to, or greater than src2.
*
*         Input: src1 - the first source pointer to compare from
*		 src2 - the second source pointer to compare from
*		 num  - the number of bytes to be compared
*       Returns: 0 if up to num characters in src1 equals the corresponding
*                 characters in src2.  The positive difference of the
*                 first character that differs between src1 and src2 if
*                 src1 is lexicographically greater than src2.  The negative
*                 difference of the first character that differs, if src2 is
*                 lexicographically greater than src1.
*    Written By: Mark Young
*          Date: Jul 06, 1993
*   Declaration: void kbcmp(
*		 !  char *src1,
*		 !  char *src2,
*		 !  int  num)
*************************************************************/

#define kbcmp(src1, src2, num) kmemcmp((kaddr) (src1), (kaddr) (src2), (unsigned) (num))


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/* memory.c */
void  _kfree	PROTO((kaddr));
kaddr kmalloc	PROTO((unsigned));
kaddr kcalloc	PROTO((unsigned, unsigned));
kaddr krealloc	PROTO((kaddr, unsigned));
kaddr kdupalloc	PROTO((kaddr, unsigned));

kaddr kmemcpy   PROTO((kaddr, kaddr, unsigned));
kaddr kmemccpy  PROTO((kaddr, kaddr, int, unsigned));
int   kmemcmp   PROTO((kaddr, kaddr, unsigned));
kaddr kmemset   PROTO((kaddr, int, unsigned));
kaddr kmemchr   PROTO((kaddr, int, unsigned));
kaddr kmemmove  PROTO((kaddr, kaddr, unsigned));


#endif /* _kutils_kmemory_h_ */
/* Don't add after this point. */
