/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose:  To provide function declarations and
   >>>>			definitions for the kutils array utilities
   >>>>
   >>>>    Written By:  Mark Young
   >>>>
   >>>>          Date:  Nov 29, 1992 09:56
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kutils_karray_h_
#define _kutils_karray_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

        /*-------------------------------------*
        |       defines
        ---------------------------------------*/

/*
 *  Defines used for karray_dirlist for it's list mode
 */
#define KPATH    (1 << 0)
#define KFILE    (1 << 1)
#define KDIR     (1 << 2)
#define KDOT     (1 << 3)
#define KLINK    (1 << 4)
#define KSOCK    (1 << 5)
#define KREAD    (1 << 6)
#define KWRITE   (1 << 7)
#define KEXEC    (1 << 8)
#define KRECURSE (1 << 9)


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/


        /*-------------------------------------*
        |       macros
        ---------------------------------------*/


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

klist *karray_to_list	PROTO((char **, int));
char  **karray_insert	PROTO((char **, kaddr, int, int, int));
char  **karray_add	PROTO((char **, kaddr, int));
char  **karray_copy	PROTO((char **, int, int));
char  **karray_delete	PROTO((char **, kaddr, int));
char  **karray_sort	PROTO((char **, int, int));
char  **karray_merge	PROTO((char **, char **, int, int, int));
char  *karray_to_string	PROTO((char **, int, char *));
char  **karray_filelist	PROTO((char *, char *, int, int *));
char  **karray_dirlist	PROTO((char *, char *, char *, int, int, int *));
void  karray_free	PROTO((char **, int, kfunc_void));
int   karray_locate	PROTO((char **, kaddr, int));

#endif /* _kutils_karray_h_ */
/* Don't add after this point. */
