/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Include file for KCMS public API
   >>>>
   >>>>    Written By: Steven Jorgensen & Neil Bowers
   >>>>
   >>>>          Date: Oct 30, 1992 14:54
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kcms_kcms_h_
#define _kcms_kcms_h_


	/*-------------------------------------*
	|       #include
	---------------------------------------*/

#include <bootstrap.h>

#include <kcms/attributes.h>
#include <kcms/fileobj.h>
#include <kcms/cmobj.h>
#include <kcms/tbobj.h>
#include <kcms/ghost.h>
#include <kcms/error.h>
#include <kcms/keys.h>


	/*-------------------------------------*
	|       #defines
	---------------------------------------*/

/*-- defines for update flag.  these are bit flags --------------------*/

#define KCMS_UPDATE_NONE		0L
#define KCMS_UPDATE_SYNC		(1L << 0)
#define KCMS_UPDATE_REGEN		(1L << 1)
#define KCMS_UPDATE_NEW			(1L << 2)
#define KCMS_UPDATE_CACHE		(1L << 3)
#define KCMS_UPDATE_REGEN_CODE		(1L << 4)

/*-- definitions for template identifiers -----------------------------*/

#define KCMS_TEMPLATE_TODO		1
#define KCMS_TEMPLATE_BUGS		2
#define KCMS_TEMPLATE_DONE		3
#define KCMS_TEMPLATE_CHANGELOG		4

#define KCMS_TEMPLATE_UIS_PANE		5
#define KCMS_TEMPLATE_UIS_FORM		6

#define KCMS_TEMPLATE_SRC_LIBRARY	10
#define KCMS_TEMPLATE_SRC_PROGRAM	11
#define KCMS_TEMPLATE_SRC_INCLUDE	12

#define KCMS_TEMPLATE_FORTRAN_LIBRARY	13
#define KCMS_TEMPLATE_FORTRAN_PROGRAM	14

#define KCMS_TEMPLATE_MISC		15

#define KCMS_TEMPLATE_DOC		16
#define KCMS_TEMPLATE_HLP		17
#define KCMS_TEMPLATE_MANUAL		18
#define KCMS_TEMPLATE_INDEX		19
#define KCMS_TEMPLATE_GLOSSARY		20

#define KCMS_TEMPLATE_INFO_FILE		21
#define KCMS_TEMPLATE_CONFIG_FILE	22
#define KCMS_TEMPLATE_TB_INCLUDE_FILE	23
#define KCMS_TEMPLATE_TB_ALIAS_FILE	24

#define KCMS_TEMPLATE_TB_TODO		25
#define KCMS_TEMPLATE_TB_CHANGELOG	26

	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

typedef struct _header_info
{
   kstring    name;
   kstring    shortdesc;
   kstring    purpose;
   int	      in_cnt;
   kstring  **input;
   int	      out_cnt;
   kstring  **output;
   kstring    returns;
   kstring    restrictions;
   kstring    author;
   kstring    date;
   kstring    verified;
   kstring    sideeff;
   kstring    mods;
   kstring    declaration;
   kstring    filename;
   time_t     parse_time;
} header_info;

/*-- the basic kcms method function: takes a kobject, returns a boolean --*/
typedef int (*kcms_method) PROTO((kobject));

	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/


	/*-------------------------------------*
	|       macros
	---------------------------------------*/


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

kobject	 kcms_open_toolbox	     PROTO((kstring));
kobject	 kcms_create_toolbox	     PROTO((kstring, kstring));
kobject  kcms_add_toolbox            PROTO((kstring, kstring));
kstring *kcms_query_toolboxes	     PROTO((int *));
kstring  kcms_get_copyright          PROTO((kobject, int, int));
klist   *kcms_get_objects            PROTO((kobject, int));
int      kcms_create_manual          PROTO((kobject, kstring));

kobject	 kcms_open_cmobj	     PROTO((kobject, kstring));
kobject	 kcms_create_cmobj	     PROTO((kobject, kstring, int));
kobject	 kcms_generate_cmobj	     PROTO((kobject, kstring, int, kstring,
					    kstring, kstring, kstring, kstring,
					    int, int, int, int, kobject));

kobject	 kcms_open_fileobj	     PROTO((kobject, kstring, kstring, int,
					    int, int, int));
kobject	 kcms_create_fileobj	     PROTO((kobject, kstring, kstring, int,
					    int, int, int));
int      kcms_copy_template_file     PROTO((kobject));
kstring  kcms_query_template         PROTO((kobject, int));

int      kcms_close		     PROTO((kobject));
int      kcms_destroy		     PROTO((kobject));
int      kcms_sync                   PROTO((kobject));
int      kcms_rename                 PROTO((kobject, kstring));
kobject	 kcms_duplicate              PROTO((kobject, kobject));
int      kcms_foreach                PROTO((kobject,
					    kcms_method,
					    int,
					    int));

int      kcms_get_attribute	     PROTO((kobject, kvalist));
int      kcms_get_attributes	     PROTO((kobject, kvalist));
int      kcms_get_indirect_attribute PROTO((kobject, kvalist));
int      kcms_vget_attribute         PROTO((kobject, int, kva_list *));

int      kcms_set_attribute	     PROTO((kobject, kvalist));
int      kcms_set_attributes	     PROTO((kobject, kvalist));
int      kcms_vset_attribute         PROTO((kobject, int, kva_list *));
int      kcms_set_indirect_attribute PROTO((kobject, kvalist));
kstring *kcms_list_get_attribute     PROTO((klist *, int, int *));

kstring  kcms_attr_int2string        PROTO((int, int));
int      kcms_attr_string2int        PROTO((int, kstring));

int	 kcms_legal_identifier	     PROTO((kstring, int));

int kcms_env_deletetb PROTO((char *));

int kcms_add_callback                PROTO((kobject, int,
					    void (*callback)(kobject, int,
							     void *), void *));
int kcms_remove_callback             PROTO((kobject, int,
					    void (*callback)(kobject, int,
							     void *), void *));

header_info *kcms_header_info_copy   PROTO((header_info *));

int      kcms_get_imake_symbols      PROTO((kstring *, kstring *, kstring *,
					    int *));

void     kcms_header_info_free	     PROTO((header_info *));

/*-- utilities.c ------------------------------------------------------*/

int      kcms_set_bit                PROTO((kobject, int, unsigned long));
int      kcms_clear_bit              PROTO((kobject, int, unsigned long));
int      kcms_query_bit              PROTO((kobject, int, unsigned long,
					    int *));
int      kcms_add_keyword            PROTO((kobject, kstring));
int      kcms_remove_keyword         PROTO((kobject, kstring));

kstring  kcms_get_date			PROTO((void));


#endif /* _kcms_kcms_h_ */
/* Don't add after this point */
