#!/usr/bin/perl
#========================================================================
#
# Program Name: kgplot - plot 1D-viff files using gnuplot
# Purposed:	long description goes here
#
# RCS ID:	Khoros: $Id$
# RCS Log:	$Log$
#========================================================================

# Copyright (C) 1993, 1994, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.

@INC = (@INC, '/usr/khoros2.0/lib');
require "khoros.pl";
require "kutils.pl";

$whatis = 'plot 1D-viff files using gnuplot';
@ksrcconf_args  = (
        '[i]',      'Input',             'Input 1D data',
        '[o]',      'Output image',      'Image with plot',
	'[style]' , 'Plot Style',        'Plot Style',
	'[title]' , 'Plot Title',        'Plot Title',
        '[labelx]', 'Label for x',       'Label for x coordinate',
        '[labely]', 'Label for y',       'Label for y coordinate',
	'[format]', 'Output Format',     'Output File Format',
        '[set1]',   'set',               'string for additional setting',
        '[set2]',   'set',               'string for additional setting',
	'[sizex]' , 'Width Plot Frame',  'width of plot frame',
	'[sizey]' , 'Height Plot Frame', 'height of plot frame',
        '[border]', 'With Border',       'indicate Border or not'
);

@style_list = ( 'lines', 'points', 'linespoints', 'impulses', 'dots');
@format_list = ( 'viff', 'pbm', 'gif',  'postscript');

# initialize Khoros perl lib
&khoros'initialize("DIP",$whatis,@ksrcconf_args);

&khoros'parse_args(@ARGV);                   # parse the command-line

# ------------------------------------------------------------------------
# Put your code here
# ------------------------------------------------------------------------

$TMPDIR = $ENV{'TMPDIR'} || '/usr/tmp';
$opt_i = $khoros'seenswitch{"i"};
$opt_o = $khoros'seenswitch{"o"};
$opt_style = $khoros'seenswitch{"style"};
$opt_format = $khoros'seenswitch{"format"};
$opt_border = $khoros'seenswitch{"border"};
$opt_sizex  = $khoros'seenswitch{"sizex"};
$opt_sizey  = $khoros'seenswitch{"sizey"};
$opt_set1   = $khoros'seenswitch{"set1"};
$opt_set2   = $khoros'seenswitch{"set2"};
$opt_labelx = $khoros'seenswitch{"labelx"};
$opt_labely = $khoros'seenswitch{"labely"};

if ( ! $opt_i || ! $opt_o )
{
   print "\t>>> i and o are required arguments\n";
   print "\t>>> use -U for detail\n";
   exit(1);
}

if ( ! $opt_style)
{
   $style = 0;
}
else
{
$style = $khoros'argval{"style"} - 1;
};

if (! $opt_format)
{
   $format = 0;
}
else
{
   $format = $khoros'argval{"format"} - 1;
};

if (! $opt_set1)   { $set1 = "";}
else               { $set1 = "set ".$khoros'argval{"set1"};}
if (! $opt_set2)   { $set2 = "";}
else               { $set2 = "set ".$khoros'argval{"set2"};}

if (! $opt_labelx) { $labelx = "";}
else               { $labelx = $khoros'argval{"labelx"};}
if (! $opt_labely) { $labely = "";}
else               { $labely = $khoros'argval{"labely"};}

if (! $opt_sizex)
{    $sizex = 0.5;}
else
{    $sizex = $khoros'argval{"sizex"};}
if (! $opt_sizey)
{    $sizey = 0.5;}
else
{    $sizey = $khoros'argval{"sizey"};}
if (! $opt_border)
{    $border = 'border';}
else
{
    if ( $khoros'argval{"border"} == 1) {$border = 'border';}
    else                                {$border = 'noborder';}
}

$i = $khoros'argval{"i"};
$o = $khoros'argval{"o"};
$ro = $o;
$title = $khoros'argval{"title"};

open(GNUFILE, ">$TMPDIR/kgplot.gnu$$") || do
{
  print "\t>>> couldn't create file $TMPDIR/kgplot.gnu$$\n";
  exit(1);
};

if ( $format == 3) 
{
  $rformat = 'postscript eps';
}
elsif ($format == 2)
{
  $ro = "$TMPDIR/kgplot.pbm$$";
  $rformat = 'pbm small';
}
else
{
  $rformat = 'pbm small';
};

print GNUFILE <<EndOfGnufile;
set output "$ro"
set terminal $rformat
set xlabel "$labelx"
set ylabel "$labely"
set size $sizex,$sizey
set $border
$set1
$set2
plot "$TMPDIR/kgplot.$$" title "$title" with $style_list[$style] 
EndOfGnufile
close (GNUFILE);

system("kprdata -i $i -val -ind -f $TMPDIR/kgplot.$$");
system("gnuplot $TMPDIR/kgplot.gnu$$");

#viff output
if ($format == 0)
{
  system("kformats -i $o -o $o -viff");
};

#gif output
if ($format == 2)
{
  system("ppmtogif 2> /dev/null $ro >$o");
};

#system("/bin/rm -f $TMPDIR/kgplot.$$ $TMPDIR/kgplot.gnu$$ $TMPDIR/kgplot.pbm$$");




