#!/bin/csh -f

#
# Khoros: $Id$
#
# $Log$
#

# Copyright (C) 1993, 1994, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.

#************************************************************
#
#  Routine Name: kdftogif - shell script named kdftogif
#
#       Purpose: Convert a KDF file to GIF
#
# Modifications: This is a temporary script as this is supported in
#                the new version
#************************************************************/

unsetenv KHOROS_IPC
set error_flag = 0

set i_flag = 0
set o_flag  = 0

set i_file_flag = 0
set o_file_flag = 0

set i_file =             #default = empty
set o_file =             #default = empty


while ($#argv)
  switch($argv[1])
      case -i:
        set i_flag = 1
        breaksw
      case -o:
        set o_flag = 1
        breaksw
      case -U:
        goto usage
        breaksw
      case -[A-T]*:	# not valid switches
      case -[V-Z]*;
      case -[a-h]*:
      case -[j-n]*:
      case -[p-z]*:
        set error_flag = 1
        goto usage
        breaksw
      default:
        if ($i_flag) then
                set i_file = $argv[1]
                set i_file_flag = 1
                set i_flag = 0
        else if ($o_flag) then
                set o_file = $argv[1]
                set o_file_flag = 1
                set o_flag = 0
        endif
        breaksw
  endsw
  shift
end


if (! $i_file_flag || ! $o_file_flag) then
 /bin/sh -c 'echo "Input and Output file required" |>&2'
      		echo "Input and Output file required"
      		set error_flag = 1
      		goto usage
endif

kformats -i $i_file -o - -pnm | ppmtogif > $o_file

if ($status) then
        /bin/sh -c 'echo "Error in kformats or ppmtogif" |>&2'
	echo "Error in kformats or ppmtogif"
	set error_flag = 1
   	goto cleanup
endif

cleanup:
    unset i_flag
    unset o_flag

    unset i_file_flag
    unset o_file_flag

    unset i_file
    unset o_file

    if ($error_flag) then
        unset error_flag
        exit 1          # an error
    else
        unset error_flag
        exit 0
    endif

usage:
    echo ""
    echo "kdf2gif: KDF to GIF converter"
    echo ""
    echo "Usage:"
    echo "  [-i]     input file"
    echo "  [-o]     output file"
    echo ""
    echo "  [-U]     get this message"
    echo ""
    goto cleanup
