# ========================================================================
# html-lib.pl
#
# A perl library with helper routines for perl scripts which want to
# generate HTML pages on the fly.
# ========================================================================

sub BeginPage
{
   local($title) = @_;


   $| = 1;

   # content-type cookie
   print "Content-Type: text/html\n\n";

   print "<HTML><HEAD>\n";
   print "<TITLE>$title</TITLE></HEAD>\n";
   print "<HEAD>\n";
   print "<H1 ALIGN=CENTER>$title</H1><HR><P>\n";
}

sub EndPage
{
   print "</BODY></HTML>\n";
   exit 0;
}

# ========================================================================
# Function:	GetTitle()
# Purpose:	This function takes a fullpath to a file, and tries to
#		determined the title of that page.  The title is taken to be:
#			1) The text from the <H1> ... </H1> element
#			2) The text from the <TITLE> element
#		If the file cannot be opened, then `undef' is returned.
#		If a TITLE or H1 heading was not found, then the filename
#		itself is returned.
# ========================================================================
sub GetTitle
{
   local($filename) = @_;
   local(*INFILE);
   local($title);

   open(INFILE, "< $filename") || return undef;
   $title = $filename;

   while (<INFILE>)
   {
      $title = $1 if /<TITLE>\s*(.*)\s*<\/TITLE>/i;
      ($title = $1),last if /<H1>\s*(.*)\s*<\/H1>/i;
   }
   close INFILE;

   return $title;
}

#
# last thing we do is signify that everything's ok
#
1;
