#
# dip-config.pl
#
# This is the configuration file included by all DIP scripts
# You should only have to change values in this script

require 'dip-site.pl';

# ------------------------------------------------------------------------
# TMPDIR is a temporary working directory, which is determined from:
#	$TMPDIR		which can be set in site.pl; or
#	TMPDIR		environment variable, if set; or
#	/usr/tmp	as a last default.
# ------------------------------------------------------------------------
$TMPDIR = $TMPDIR || $ENV{'TMPDIR'} || '/usr/tmp';


# ------------------------------------------------------------------------
# LD_LIBRARY_PATH
#	If the $LD_LIBRARY_PATH array is defined, then set the
#	LD_LIBRARY_PATH environment variable
# ------------------------------------------------------------------------
if (defined $LD_LIBRARY_PATH)
{
   $ENV{'LD_LIBRARY_PATH'} = $LD_LIBRARY_PATH;
}

# ------------------------------------------------------------------------
# KHOROS_TOOLBOX
#
# ------------------------------------------------------------------------

$KHOROS_TOOLBOX = $KHOROS_TOOLBOX || $ENV{'KHOROS_TOOLBOX'};
if (!defined $KHOROS_TOOLBOX)
{
   die "Cannot determine KHOROS_TOOLBOX.  This should be set in site.pl\n";
}

@TBFILES = split(/:/, $KHOROS_TOOLBOX);
foreach $tbfile (@TBFILES)
{
   open(TBFILE, "< $tbfile") || do
   {
      warn "Could not read toolbox file $tbfile: $!\n";
      next;
   };

   while (<TBFILE>)
   {
      next unless /^([^:]+):([^:]+)/;
      $toolbox = "\U$1";
      $tbpath  = $2;
      $TBPATH{$1} = $2;

      # add toolbox/bin to path, and set DIP_PATH for easy use
      $ENV{'PATH'} .= ":$tbpath/bin";
   }
}


# ------------------------------------------------------------------------
# DIPHOME
#
#	This is the path to the top of the DIP toolbox.  This is just a
#	convenience for reference the array of toolbox paths.
# ------------------------------------------------------------------------
$DIPHOME = $TBPATH{'DIP'};


# ------------------------------------------------------------------------
# WWWDIP
#
#	This is a URL head, which can be used to reference the pages of
#	the DIP course itself.
# ------------------------------------------------------------------------
$WWWDIP = "file://localhost$DIPHOME/html";
#$CGIDIP = "http://localhost/dip/cgi-bin";
$CGIDIP = "http://localhost/dipcourse/cgi-bin";

1;
