/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvpset.c
 >>>>
 >>>>      Program Name: vpset
 >>>>
 >>>> Date Last Updated: Sat Apr 27 10:32:10 1991 
 >>>>
 >>>>          Routines: lvpset - the library call for vpset
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvpset - library call for vpset
*
* Purpose:
*    
*    Set a pixel in an image to a given value
*    
*    
* Input:
*    
*         img -- input xvimage structure
*         img2 -- mask image, xvimage structure
*         x -- X coordinate of pixel to modify
*         y -- Y coordinate of pixel to modify
*         b -- band number of pixel to modify
*         v -- value to set the pixel to
*    
*    
* Output:
*    
*         1. img -- output xvimage structure img is used for both  the
*         input xvimage structure and the output result xvimage struc-
*         ture.  This is done to save space, but you must  be  careful
*         not to overwrite important data.
*         lvpset returns a zero upon failure.
*    
*    
*
* Written By: Scott Wilson
****************************************************************/


/* -library_def */
int
lvpset(img,x,y,b,v)
struct xvimage *img;
int x,y,b;
float v;
/* -library_def_end */

/* -library_code */
{
    int    *i;
    short  *s;
    float  *f;
    double *d;
    unsigned char *c;
    int rows,cols,k;

    rows = img->number_of_rows;
    cols = img->number_of_cols;
    k = BPIXEL(b,x,y,rows,cols);

    if ( x < 0 || x >= cols || y < 0 || y >= cols || b < 0 ||
         b >= img->num_data_bands)
      {
        fprintf(stderr,"lvpset: Specified pixel is off-image!\n");
        return(0);
      }

    switch (img->data_storage_type)
      {
        case VFF_TYP_BIT :
          fprintf(stderr,"lvpset: Don't know how to vpset a BIT image!\n");
          return(0);
          break;
        case VFF_TYP_1_BYTE : 
          c = (unsigned char *)(img->imagedata);
          c[k] = v;
          break;
        case VFF_TYP_2_BYTE :
          s = (short *)(img->imagedata);
          s[k] = v;
          break;
        case VFF_TYP_4_BYTE :
          i = (int *)(img->imagedata);
          i[k] = v;
          break;
        case VFF_TYP_FLOAT :
          f = (float *)(img->imagedata);
          f[k] = v;
          break;
        case VFF_TYP_DOUBLE :
          d = (double *)(img->imagedata);
          d[k] = v;
          break;
        case VFF_TYP_COMPLEX :
        case VFF_TYP_DCOMPLEX :
          fprintf(stderr,"lvpset: Don't know how to vpset a COMPLEX image!\n");
          return(0);
          break;
        default:
          fprintf(stderr,"lvpset: Unsupported data storage type, %d\n",img->data_storage_type);
          return(0);
          break;
      }
      return(1);
}
/* -library_code_end */
