.TH UnidrawIntro 3U "11 June 1990" "Unidraw" "InterViews Reference Manual"
.SH NAME
Unidraw library for graphical object editor development
.SH SYNOPSIS
.B #include <Unidraw/\fIclass\fP.h>
.br
.B #include <Unidraw/Components/\fIclass\fP.h>
.br
.B #include <Unidraw/Commands/\fIclass\fP.h>
.br
.B #include <Unidraw/Tools/\fIclass\fP.h>
.br
.B #include <Unidraw/Graphic/\fIclass\fP.h>
.LP
.B "CC ... \-lUnidraw ... -lInterViews -lX -lm"
.SH DESCRIPTION
Unidraw is an architecture for creating object-oriented graphical
editors in domains such as technical and artistic drawing, music
composition, and circuit design.  Unidraw simpifies the construction
of these editors by providing programming abstractions that are common
across domains.  Unidraw defines four basic abstractions:
\fBcomponents\fP encapsulate the appearance and semantics of objects
in a domain, \fBtools\fP support direct manipulation of components,
\fBcommands\fP define operations on components and other objects, and
\fBexternal representations\fP define the mapping between components
and the file format generated by the editor.  Unidraw also supports
multiple views, graphical connectivity and confinement, and dataflow
between components.
.PP
The Unidraw library contains a collection of classes that implement
the Unidraw architecture.  The Unidraw library is used together with
the rest of InterViews, except the \fIgraphic\fP structured graphics
library, to develop domain-specific graphical object editors.
InterViews interactors and composition mechanisms support an
application's look and feel, while the Unidraw library supports
functionality unique to graphical object editors.  Currently, the
Unidraw library provides its own structured graphics classes, which
are similar to but incompatible with the graphic library classes.
Therefore you must not use both graphic and Unidraw classes in the
same application.
.PP
General Unidraw classes are declared in header files in the Unidraw
include file subdirectory. Component, command, tool, and structured
graphics classes are declared in corresponding subdirectories under
the Unidraw subdirectory.
.SH SEE ALSO
InterViews(3I)
.LP
.IR "Generalized Graphical Object Editing",
John M. Vlissides, Technical Report CSL-TR-90-427, Stanford
University, June 1990.
