'\"et
.if t .TH IMPASTE 1IM "September 25, 1991" "San Diego Supercomputer Center" "IMAGE TOOLS" 
.if n .TH IMPASTE 1IM "September 25, 1991" "SDSC" "IMAGE TOOLS"
.SH NAME
impaste  -  Paste an image atop a background and store in a new file
.SH SYNOPSIS
\fBimpaste\fR [\fIoptions\fR] \fIinfilename\fR \fIbackfilename\fR
[\fIoutfilename\fR] 
.SH DESCRIPTION
\fBimpaste\fR pastes an input image atop a background image and stores the
result in a new file or back in the background image file.
.LP
If the input file contains multiple images, each input image is pasted
onto a fresh copy of the background image and added to the output
file.  The output file contains one new image for each input image.
.LP
If the input and background files each contain multiple images, a
one-for-one mapping occurs where input image #1 is pasted atop
background image #1, and so on.  The output file contains one new
image for each input image. 
.LP
The input, background, and output image file formats may be different.
.SH OPTIONS
\fBimpaste\fR has a variety of options in the following five categories:
.LP
.RS +0.5i
.TS
l l.
File Selection	What input and output files to use
Format Selection	What image file format to use
Format Control	What variant of a file format to generate
Standard	Standard generic options on all SDSC tools
Manipulation	How the image can be manipulated
.TE
.RE
.LP
\fIFile Selection\fR, \fIFormat Selection\fR, \fIFormat Control\fR,
and \fIStandard\fR options are common to all SDSC image tools and are
discussed in depth in the \fBman\fP page for \fBimconv\fR(1IM).
.LP
If you don't specify an output file, the background image file is
treated as the output file.  This allows paste-in-place operations.
.LP
The input image or the background image, but not both, may be taken
from \fBstdin\fP. 
.LP
All options can be abbreviated to the first few unique characters.
.SS "Manipulation Options"
The pasting location within the background image is specified by:
.LP
.RS +0.5i
.TS
l l.
\fB-xposition\fI x\fR	Left edge of paste location
\fB-yposition\fI y\fR	Top edge of paste location
.TE
.RE
.LP
The paste location may be outside the bounds of the input image.  The
portion of the input image that lies within the bounds of the
background image will be pasted.  (0,0) is the upper left corner of
the image.  Both positions default to values that center the incoming
image left-to-right and top-to-bottom within the background image.
.LP
By giving a repeat count in the X and Y directions, the input image may
be pasted repeatedly to create a tiling effect using the following:
.LP
.RS +0.5i
.TS
l l.
\fB-xrepeat\fI nx\fR	Number of times to paste horizontally
\fB-yrepeat\fI ny\fR	Number of times to paste vertically
\fB-xdirection\fI xdir\fR	Horizontal tiling direction
\fB-ydirection\fI ydir\fR	Vertical tiling direction
.TE
.RE
.LP
\fB-xrepeat\fR and \fB-yrepeat\fR indicate how many times to paste the
input image onto the same background image.  A value of 1 (default)
pastes the image once.  Values greater than 1
repeat the paste in X and Y.  A value of 0 for either repeat count
requests an "infinite" repeat that tiles the image as many times as
necessary to reach the horizontal or vertical edge of the background
image.  
.LP
\fB-xdirection\fR and \fB-ydirection\fR select how tiling should advance
from image to image.  \fB-xdirection\fR takes one of the following as its
argument:
.LP
.RS +0.5i
.TS
l l.
\fBleft\fR	Tiling advances to the left
\fBright\fR	Tiling advances to the right
.TE
.RE
.LP
By default, tiling advances to the right.
.LP
\fB-ydirection\fR takes one of the following as its argument:
.LP
.RS +0.5i
.TS
l l.
\fBup\fR	Tiling advances upward
\fBdown\fR	Tiling advances downward
.TE
.RE
.LP
By default, tiling advances downward.
.SH NOTES
Pasting takes place without regard to alpha planes, write protect planes,
and so on.  The input image is always placed pixel-for-pixel atop the
background image.
.LP
Internally, an input image is converted to the same depth as the
background image prior to being pasted.
.LP
Pasting of non-RGB images can cause unexpected results but is allowed.
Consider this scenario:  An input color index image uses color indexes
1, 2, and 3 for red, green, and blue.  The background color index
image uses color indexes 1, 2, and 3 as well, but its color lookup
table (CLT) defines them 
as orange, white, and black.  When the input image is pasted atop the
background image, its color indexes are copied across and use the
background image's CLT.  Input pixels that used to be red 
become orange, input green pixels become white, and input blue pixels
become black because they now reference the background image's CLT.
If this is not what you want, convert the images to RGB prior to
invoking \fBimpaste\fR.
.LP
For notes regarding file format conversion and standard image tool
options, see the \fBman\fP page on \fBimconv\fR(1IM).
.LP
Error messages are reported to \fBstderr\fR.
.SH EXAMPLES
To paste a logo at (10,20) on a background image and save the result in
a new file, use the following:
.RS 0.5i
.LP
\fBimpaste logo.rgb background.hdf -xpos 10 -ypos 20 result.rla\fR
.RE
.LP
To paste an image in the center of a background and save it back in
the same background file, use the following:
.RS 0.5i
.LP
\fBimpaste image.pix background.pix\fR
.RE
.LP
To tile a pattern across the whole background, use the following:
.RS 0.5i
.LP
\fBimpaste pattern.x -xpos 0 -ypos 0 -xrepeat 0 -yrepeat 0 background.tiff\fR
.RE
.LP
To tile a pattern three times in X and none in Y, starting at (-10,
-20), use the following:
.RS 0.5i
.LP
\fBimpaste pattern.ras -xrepeat 3 -xpos -10 -ypos -20 background.ras\fR
.RE
.LP
.SH "SEE ALSO"
\fBimconv\fR(1IM), \fBimfile\fR(1IM), \fBimflip\fR(1IM),
\fBimformats\fR(1IM), \fBimgray\fR(1IM),
\fBimmono\fR(1IM), \fBimscale\fR(1IM)
.sp 1
For information on SDSC's image library, see \fBimintro\fR(3IM). 
.sp 1
For information on the individual image file formats, see
their respective \fBman\fR pages:
\fBimeps\fR(3IM),
\fBimgif\fR(3IM),
\fBimhdf\fR(3IM),
\fBimicon\fR(3IM),
\fBimiff\fR(3IM),
\fBimmpnt\fR(3IM),
\fBimpbm\fR(3IM),
\fBimpcx\fR(3IM),
\fBimpgm\fR(3IM),
\fBimpic\fR(3IM),
\fBimpict\fR(3IM),
\fBimpix\fR(3IM),
\fBimpnm\fR(3IM),
\fBimppm\fR(3IM),
\fBimps\fR(3IM),
\fBimras\fR(3IM),
\fBimrgb\fR(3IM),
\fBimrla\fR(3IM),
\fBimrle\fR(3IM),
\fBimrpbm\fR(3IM),
\fBimrpgm\fR(3IM),
\fBimrpnm\fR(3IM),
\fBimrppm\fR(3IM),
\fBimsynu\fR(3IM),
\fBimtiff\fR(3IM),
\fBimx\fR(3IM),
\fBimxbm\fR(3IM),
\fBimxwd\fR(3IM).
.SH AUTHOR
Dave Nadeau
.br
San Diego Supercomputer Center
.LP
See the individual file format \fBman\fR pages for the authors of the underlying
format read and write code.  The names of these \fBman\fR pages begin
with the letters "im" followed by the format name.
For example, the name of the TIFF \fBman\fR page is \fBimtiff\fR.
To display it, enter \fBman imtiff\fR.
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
