/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgLaplacian.c                                                */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:46 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Laplacian"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *i1,*i2;
  int width,height,x,y;
  int v_x,v_y,v_width,v_height,y_end;
  double min,max,sum;
  it_float *flt_ptr,*r0_ptr,*r1_ptr,*r2_ptr;

  IFHELP
    {
      fprintf(stderr,"img%s - Calculate image Laplacian at each pixel\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Float\n");
      fprintf(stderr,"  stdout: Float\n");
      exit(0);
    }
  imgStart(PRGNAME);

  do {
    i1=i_read_image_file(stdin,IT_FLOAT,IM_FRAGMENT);
    if(i1==NULL)
      ERROR("can't import image file");
    width=i1->width;
    height=i1->height;

    i2=i_create_image(width,height,IT_FLOAT,IM_FRAGMENT);
    if(i2==NULL)
      ERROR("out of memory");

    /* Convolve with a 3x3 Laplacian kernel */
    v_x=i1->valid_x+1;
    v_y=i1->valid_y+1;
    v_width=i1->valid_width-2;
    v_height=i1->valid_height-2;
    y_end=v_y+v_height;
    imgInitMinMax(min,max);
    for(y=v_y;y<y_end;y++)
      {
	r0_ptr=im_float_row(i1,y-1)+v_x;
	r1_ptr=im_float_row(i1,y)+v_x-1;
	r2_ptr=im_float_row(i1,y+1)+v_x;
	flt_ptr=im_float_row(i2,y)+v_x;
	for(x=0;x<v_width;x++)
	  {
	    sum= *r0_ptr++;
	    sum+= *r2_ptr++;
	    sum+= *r1_ptr++;
	    sum-= (4.0*(*r1_ptr++));
	    sum+= *r1_ptr--;
	    *flt_ptr++=sum;
	    if(sum>max) max=sum;
	    if(sum<min) min=sum;
	  }
      }
    
    i2->min_value=min;
    i2->max_value=max;
    i2->valid_x=v_x;
    i2->valid_y=v_y;
    i2->valid_width=v_width;
    i2->valid_height=v_height;

    i_destroy_image(i1);
    i_write_image_file(stdout,i2,IF_BINARY);
    i_destroy_image(i2);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
